// Name: Menu Tuning
// Description: Forms Main menu and allows to choose menu item on top level
// Author: kartu
//
// HISTORY:
//	2010-04-20 kravitz - Code of Main menu forming is moved here from BrowseFolders.js
//	2010-04-20 kravitz - Menu item on top level setting

// Shortcuts
var log = Core.log.getLogger("MenuTuning");
var NodeKinds = Core.ui.NodeKinds;
var MainMenu = kbook.root;

// Localize
var str = Core.lang.getStrings("MenuTuning");

var L = function (key) {
	if (str.hasOwnProperty(key)) {
		return str[key];
	} else {
		return "MenuTuning." + key;
	}
};

var MenuTuning = {
	name: "MenuTuning",
	union: "MenuSettings",
	unionTitle: L("UNION_TITLE"),
	icon: "LIST",
	optionDefs: [{
		name: "outer",
		title: L("OPTION_OUTER"),
		icon: "LIST",
		defaultValue: "addons",
		values: ["nowPlaying", "music", "pictures", "addons"],
		valueTitles: {
			nowPlaying: Core.ui.nodes.nowPlaying.title,
			music: Core.ui.nodes.music.title,
			pictures: Core.ui.nodes.pictures.title,
			addons: L("NODE_ADDONS")
		}
	}]
};

MenuTuning.formOthers = function (outer) {
	var node = Core.ui.nodes[outer];
	var others = Core.ui.nodes.others;
	node.parent = MainMenu;
	node._myseparator = 1;
	MainMenu.nodes[8] = node;

	var values = this.optionDefs[0].values;
	others.nodes = [];
	for (var i = 0, n = values.length; i < n; i++) {
		if (values[i] !== outer) {
			node = Core.ui.nodes[values[i]];
			node.parent = others;
			node._myseparator = 0;
			others.nodes.push(node);
		}
	}
};

MenuTuning.onSettingsChanged = function (propertyName, oldValue, newValue) {
	if (oldValue === newValue) {
		return;
	}
	if (propertyName === "outer") {
		this.formOthers(newValue);
	}
};

MenuTuning.onInit = function () {
	// "Others" node show "Now Playing", "Audio", "Pictures" and "Addons" nodes
	var othersNode = Core.ui.createContainerNode({
		parent: kbook.root,
		title: L("NODE_OTHERS"),
		kind: NodeKinds.AUDIO,
		comment: function () {
			return _rl_itemsCount(this.nodes.length); //FIXME
		}
	});
	// Update from ContainerNode doesn't work for whatever reason, probably it is accessing the wrong "nodes"
	othersNode.update = function (model) {
		for (var i = 0, n = this.nodes.length; i < n; i++) {
			if (this.nodes[i].update) {
				this.nodes[i].update.call(this.nodes[i], model);
			}
		}
	};
	Core.ui.nodes.others = othersNode;
	// "Addons" node show games and utilites nodes
	var addonsNode = Core.ui.createContainerNode({
		parent: kbook.root,
		title: L("NODE_ADDONS"),
		kind: NodeKinds.GAME,
		comment: function () {
			return _rl_itemsCount(this.nodes.length); //FIXME
		}
	});
	Core.ui.nodes.addons = addonsNode;
	// Adjust Main menu
	Core.ui.nodes.bookmarks._myseparator = 0;
	MainMenu.nodes[6] = Core.ui.nodes.collections;
	Core.ui.nodes.collections._myseparator = 1;
	MainMenu.nodes[7] = Core.ui.nodes.others;
	// Form "Others" menu
	this.formOthers(this.options.outer);
};

return MenuTuning;
