// Name: Goodbye
// Description: Calls finalization routines of addons (temporary release)
// Author: kravitz
//
// NOTE(s):
// 	- Reassigns original USBDispatcher.onConnected()
// 	- Reassigns original kbook.model.doDeviceShutdown()

// Shortcuts
var log = Core.log.getLogger("goodbye");
var getSoValue = Core.system.getSoValue;

var sayGoodbye = function () {
	_rl_saveToFile();
	_rm_saveToFile();
};

var USBDispatcher = getSoValue("USBDispatcher");
var oldUSBDispatcherOnConnected = USBDispatcher.onConnected;
USBDispatcher.onConnected = function () {
	try {
		sayGoodbye();
	} catch (e) {
		log.error("Error in OnConnected: " + e);
	}
	oldUSBDispatcherOnConnected.apply(this, arguments);
};

var oldDoDeviceShutdown = kbook.model.doDeviceShutdown;
kbook.model.doDeviceShutdown = function () {
	try {
		sayGoodbye();
	} catch (e) {
		log.error("Error in doDeviceShutdown: " + e);
	}
	oldDoDeviceShutdown.apply(this, arguments);
};
