// Name: Bookmarks
// Description: Bookmarks addons
// Author: kravitz
//
// History:
//	2010-04-02 kravitz - Remove Oldest Bookmarks utility
//	2010-04-05 kravitz - Localized

// Shortcuts
var log = Core.log.getLogger("Bookmarks");
var getSoValue = Core.system.getSoValue;
var cloneObj = Core.system.cloneObj;

// Localize
var str = Core.lang.getStrings("Bookmarks");

var L = function (key) {
	if (str.hasOwnProperty(key)) {
		return str[key];
	} else {
		return "Bookmarks." + key;
	}
};

// This addon
var Bookmarks = {
	removeOldestBookmarksNode: null
};

// Removes all bookmarks except the newest one (in like onEnterRemoveAllBookmarks).
Bookmarks.removeOldestBookmarks = function (book) {
	var media = getSoValue(book, "media");
	var bookmarks = getSoValue(media, "bookmarks");
	var c = bookmarks.length;
	if (c < 2) {
		// Nothing to remove
		return;
	}
	bookmarks.splice(0, c - 1);
	media.bookmarkDate = Date.now();
	// media.commit(kbook.bookData);
	var commit = getSoValue(media, "commit");
	commit.call(media, kbook.bookData);
	// media.doSyncAnnotations(kbook.bookData.data);
	var doSyncAnnotations = getSoValue(media, "doSyncAnnotations");
	var data = getSoValue(kbook.bookData, "data");
	doSyncAnnotations.call(media, data);
	// kbook.globalBookmarkListNode.construct();
	var globalBookmarkListNode = getSoValue(kbook, "globalBookmarkListNode");
	var construct = getSoValue(globalBookmarkListNode, "construct");
	construct.call(globalBookmarkListNode);

	kbook.model.commitCache();
	kbook.model.current.gotoNode(kbook.model.current, kbook.model);
};

Bookmarks.onChangeBook = function (book) {
	var utilities = book.nodes[book.nodes.length - 1]; // Utilities node (must be last)
	if (typeof utilities.isRemoveOldestBookmarksNode === "undefined") {
		// Insert RemoveOldest node into utilities
		utilities.nodes.splice(1, 0, this.removeOldestBookmarksNode);
		utilities.isRemoveOldestBookmarksNode = true;
	}
	// Temporarily change parent of RemoveOldest node
	this.removeOldestBookmarksNode.parent = utilities;
};

Bookmarks.onInit = function () {
	var node = cloneObj(kbook.children.utilities.children.removeAllBookmarks);
	node.cache = kbook.model.cache;
	node.parent = null;
	FskCache.tree.xdbNode.construct.call(node);
	node.title = L("TITLE_REMOVE_OLDEST");
	node.name = node.title;
	node.nodes = [];
	node.onEnter = null;
	node.enter = function () {
		try {
			Bookmarks.removeOldestBookmarks(kbook.model.currentBook);
		} catch (e) {
			log.error("error in removeOldestBookmarks: " + e);
		}
	};
	this.removeOldestBookmarksNode = node;
};

//FIXME Handlers export...

_bm_onChangeBook = function (n) {
	Bookmarks.onChangeBook(n);
};

return Bookmarks;
