/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class StopWatch {
    private long start_time = 0L;
    private long end_time = 0L;
    private boolean running = false;
    private long prev_elapsed_time;
    File watch_file;

    public StopWatch() {
        this.watch_file = null;
    }

    public StopWatch(File out_file) {
        this.watch_file = out_file;
        this.prev_elapsed_time = -1L;
    }

    public void reset() {
        this.start_time = 0L;
        this.end_time = 0L;
        this.running = false;
    }

    public void start() {
        this.reset();
        this.start_time = System.currentTimeMillis();
        this.running = true;
    }

    public void stop() {
        this.end_time = System.currentTimeMillis();
        this.running = false;
    }

    public long getElapsedTimeMillis() {
        if (this.running) {
            return System.currentTimeMillis() - this.start_time;
        }
        return this.end_time - this.start_time;
    }

    public long getElapsedTimeSecs() {
        return this.getElapsedTimeMillis() / 1000L;
    }

    public String getElapsedTimeFormatted() {
        return StopWatch.formatTime(this.getElapsedTimeSecs());
    }

    public void updateWatchFile() {
        long elapsed_time = this.getElapsedTimeMillis();
        if (this.prev_elapsed_time == -1L) {
            this.prev_elapsed_time = this.readWatchFile();
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.watch_file, false));
            bw.write(Long.toString(elapsed_time + this.prev_elapsed_time));
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public long readWatchFile() {
        long previous_elapsed_time = 0L;
        if (this.watch_file.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(this.watch_file));
                previous_elapsed_time = Long.parseLong(br.readLine());
                br.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return previous_elapsed_time;
    }

    public static String formatTime(long secs) {
        long days = secs / 86400L;
        long hrs = secs / 3600L;
        long mins = secs / 60L;
        long leftover_hrs = hrs % 24L;
        long leftover_mins = mins % 60L;
        long leftover_secs = secs % 60L;
        if (days > 0L) {
            return String.valueOf(days) + " days " + leftover_hrs + " hrs " + leftover_mins + " mins " + leftover_secs + " secs";
        }
        if (hrs > 0L) {
            return String.valueOf(hrs) + " hrs " + leftover_mins + " mins " + leftover_secs + " secs";
        }
        if (mins > 0L) {
            return String.valueOf(mins) + " mins " + leftover_secs + " secs";
        }
        return String.valueOf(secs) + " secs";
    }
}

