/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertManga {
    public static File default_bookmark = new File("./default.manga");

    public static void renamePages(File folder, int page_filename_length) {
        File cur_image;
        ArrayList<File> image_files = FileUtils.getImageFileList(folder);
        Collections.sort(image_files);
        ArrayList<File> cover_image_files = new ArrayList<File>();
        ArrayList<File> credit_image_files = new ArrayList<File>();
        int i = 0;
        while (i < image_files.size()) {
            cur_image = image_files.get(i);
            if (cur_image.getName().toLowerCase().contains("cover")) {
                image_files.remove(i);
                cover_image_files.add(cur_image);
                --i;
            } else if (cur_image.getName().toLowerCase().contains("credit")) {
                image_files.remove(i);
                credit_image_files.add(cur_image);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < cover_image_files.size()) {
            image_files.add(0, (File)cover_image_files.get(cover_image_files.size() - i - 1));
            ++i;
        }
        i = 0;
        while (i < credit_image_files.size()) {
            image_files.add((File)credit_image_files.get(i));
            ++i;
        }
        i = 0;
        while (i < image_files.size()) {
            cur_image = image_files.get(i);
            String extension = ExtFilter.getExtension(cur_image);
            String new_name = Integer.toString(i);
            while (new_name.length() < page_filename_length) {
                new_name = "0" + new_name;
            }
            File new_image = new File(String.valueOf(cur_image.getParent()) + File.separatorChar + new_name + extension);
            cur_image.renameTo(new_image);
            ++i;
        }
    }

    public static ArrayList<Integer> processBindFile(File bind_file) {
        ArrayList<Integer> binds = new ArrayList<Integer>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(bind_file));
            boolean done = false;
            while (!done) {
                String line = br.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                line = line.replaceAll(" ", "");
                if ((line = line.replaceAll("\t", "")).equals("") || line.charAt(0) == '#' || line.charAt(0) == '/') continue;
                binds.add(Integer.parseInt(line));
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return binds;
    }

    public static void bindFolders(ArrayList<File> folders, File bind_folder, String output_folder_filename, ImageMagick im, boolean use_zip, String zip_extension, boolean use_pdf, boolean use_kindle_bookmark, int page_filename_length) {
        if (folders.isEmpty() || folders.size() == 0) {
            return;
        }
        File first_folder = folders.get(0);
        ArrayList<File> first_folder_image_list = FileUtils.getImageFileList(first_folder);
        try {
            int i = 0;
            while (i < first_folder_image_list.size()) {
                File cur_image = first_folder_image_list.get(i);
                FileUtils.copyFile(cur_image, new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + cur_image.getName()));
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int next_starting_number = first_folder_image_list.size();
        int i = 1;
        while (i < folders.size()) {
            File cur_folder = folders.get(i);
            ArrayList<File> cur_folder_image_list = FileUtils.getImageFileList(cur_folder);
            Collections.sort(cur_folder_image_list);
            int j = 0;
            while (j < cur_folder_image_list.size()) {
                File cur_image = cur_folder_image_list.get(j);
                String extension = ExtFilter.getExtension(cur_image);
                String new_name = Integer.toString(next_starting_number + j);
                while (new_name.length() < page_filename_length) {
                    new_name = "0" + new_name;
                }
                try {
                    FileUtils.copyFile(cur_image, new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + new_name + extension));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            next_starting_number += cur_folder_image_list.size();
            ++i;
        }
        if (use_kindle_bookmark) {
            ArrayList<File> bind_folder_image_list = FileUtils.getImageFileList(bind_folder);
            Collections.sort(bind_folder_image_list);
            File bookmark_file = new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + bind_folder.getName() + ".manga");
            File bookmark_save_file = new File(String.valueOf(bind_folder.getAbsolutePath()) + File.separatorChar + bind_folder.getName() + ".manga_save");
            ConvertManga.writeBookmark(bind_folder, bookmark_file, bookmark_save_file, bind_folder_image_list.get(0));
        }
        File zip_file = new File(String.valueOf(output_folder_filename) + bind_folder.getName() + zip_extension);
        File pdf_file = new File(String.valueOf(output_folder_filename) + bind_folder.getName() + ".pdf");
        if (use_zip) {
            FileUtils.zipFolder(bind_folder, zip_file);
        }
        if (use_pdf) {
            im.pdfImageFolder(bind_folder, pdf_file);
        }
    }

    public static void writeBookmark(File cur_dir, File bookmark_file, File bookmark_save_file, File first_file) {
        try {
            FileOutputStream out = new FileOutputStream(bookmark_file);
            byte[] b = new byte[]{0};
            ((OutputStream)out).write(b);
            ((OutputStream)out).close();
            BufferedWriter bw = new BufferedWriter(new FileWriter(bookmark_save_file));
            bw.write("LAST=/mnt/us/pictures/" + cur_dir.getName() + "/" + first_file.getName());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void outputUsage() {
        System.out.println("\nCanti v1.2, author: Andrew Mantel");
        System.out.println("Purpose: Convert a collection of manga scans for ereader devices such as the Kindle DX, Kindle 2, and iPad.");
        System.out.println("Usage: ConvertManga [mandatory_arguments] [other_options]");
        System.out.println("\nMandatory Arguments: (these arguments MUST be specified)");
        System.out.println("-parent_folder /path/to/parent_folder/");
        System.out.println("  The parent folder containing subfolders representing chapters.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path (for example, \"C:\\\\Program Files\\\\manga parent folder\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("-title \"Manga Title\"");
        System.out.println("  Title of the manga, such as \"School Rumble\".");
        System.out.println("-num_chars_keep_suffix [integer]");
        System.out.println("  Number of characters to keep from original subfolder suffix.");
        System.out.println("\nOther Options: (these are all optional)");
        System.out.println("-manga_prefix \"[manga_prefix]\"");
        System.out.println("  This is placed after the manga title but before the subfolder suffix.");
        System.out.println("  Recommended value is something like \"Ch.\" or \"Vol.\" so that the output will look like \"School_Rumble_-_Ch.001\"");
        System.out.println("-bind_prefix \"[bind_prefix]\"");
        System.out.println("  This is places after the manga title but before the binding number of bound manga.");
        System.out.println("  Recommend value is something like \"Vol.\" or \"Bind.\" so that the output will look like \"School_Rumble_-_Vol.1\"");
        System.out.println("  If not specified, the default value is \"Vol.\"");
        System.out.println("-output_folder /path/to/output_folder/");
        System.out.println("  The output parent folder. Default is to use the -parent_folder.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path (for example, \"C:\\\\Program Files\\\\manga parent folder\\\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("\nSee ConvertManga.properties for conversion settings.");
        System.out.println("\nSee readme.txt for manga organization requirements and other tips.");
        System.out.println("");
        System.exit(0);
    }

    public static boolean isFolderProcessed(File progress_file, File folder) {
        boolean found = false;
        String folder_path = folder.getAbsolutePath();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(progress_file));
            while (!found && (line = br.readLine()) != null) {
                if (!line.equals(folder_path)) continue;
                found = true;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return found;
    }

    public static void addProcessedFolder(File progress_file, File folder) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(progress_file, true));
            bw.write(String.valueOf(folder.getAbsolutePath()) + "\n");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        int i;
        ExtFilter zip_filter;
        String parent_folder_filename = null;
        String output_folder_filename = null;
        String title = null;
        String manga_prefix = "";
        String bind_prefix = "Vol.";
        String prefix = null;
        File progress_file = null;
        File bind_file = null;
        boolean use_bind = false;
        int num_chars_keep_suffix = 3;
        ArrayList<Object> binds = new ArrayList();
        if (args.length == 0) {
            ConvertManga.outputUsage();
        } else if (args.length % 2 != 0) {
            System.out.println("ERROR: Invalid number of arguments.");
            ConvertManga.outputUsage();
        } else {
            boolean parsed_parent_folder = false;
            boolean parsed_title = false;
            boolean parsed_num_chars_keep_suffix = false;
            int i2 = 0;
            while (i2 < args.length) {
                String option = args[i2];
                String option_value = args[++i2];
                if (option.equalsIgnoreCase("-parent_folder")) {
                    parent_folder_filename = option_value;
                    if (parent_folder_filename.charAt(parent_folder_filename.length() - 1) != File.separatorChar) {
                        parent_folder_filename = String.valueOf(parent_folder_filename) + File.separatorChar;
                    }
                    parsed_parent_folder = true;
                } else if (option.equalsIgnoreCase("-title")) {
                    title = option_value;
                    title = title.replaceAll(" ", "_");
                    parsed_title = true;
                } else if (option.equalsIgnoreCase("-manga_prefix")) {
                    manga_prefix = option_value;
                    manga_prefix = manga_prefix.replaceAll(" ", "_");
                } else if (option.equalsIgnoreCase("-bind_prefix")) {
                    bind_prefix = option_value;
                    bind_prefix = bind_prefix.replaceAll(" ", "_");
                } else if (option.equalsIgnoreCase("-num_chars_keep_suffix")) {
                    num_chars_keep_suffix = Integer.parseInt(option_value);
                    parsed_num_chars_keep_suffix = true;
                } else if (option.equalsIgnoreCase("-output_folder")) {
                    output_folder_filename = option_value;
                    if (output_folder_filename.charAt(output_folder_filename.length() - 1) != File.separatorChar) {
                        output_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar;
                    }
                } else {
                    System.out.println("ERROR: Invalid option \"" + option + "\"");
                    ConvertManga.outputUsage();
                }
                ++i2;
            }
            if (!(parsed_parent_folder && parsed_title && parsed_num_chars_keep_suffix)) {
                System.out.println("ERROR: Not all mandatory arguments were specified.");
                ConvertManga.outputUsage();
            }
            if (output_folder_filename == null) {
                output_folder_filename = parent_folder_filename;
            } else {
                File output_folder_file = new File(output_folder_filename);
                if (!output_folder_file.exists()) {
                    output_folder_file.mkdir();
                }
            }
            progress_file = new File(String.valueOf(output_folder_filename) + "progress.txt");
            if (!progress_file.exists()) {
                progress_file.createNewFile();
            }
            if ((bind_file = new File(String.valueOf(parent_folder_filename) + "bind.txt")).exists()) {
                use_bind = true;
                binds = ConvertManga.processBindFile(bind_file);
            }
            prefix = String.valueOf(title) + " - " + manga_prefix;
            prefix = prefix.replaceAll(" ", "_");
        }
        PropertiesLoader pl = new PropertiesLoader();
        boolean use_zip = pl.getZip();
        String zip_extension = ".zip";
        if (use_zip && !(zip_filter = new ExtFilter("zip")).isValid(zip_extension = pl.getZipFormat())) {
            System.out.println("ERROR: " + zip_extension + " is not a valid zip extension. Defaulting to .zip");
            zip_extension = ".zip";
        }
        boolean use_pdf = pl.getPdf();
        boolean use_kindle_bookmark = pl.getKindleBookmark();
        int page_filename_length = pl.getPageFilenameLength();
        pl.printProperties();
        if (use_bind) {
            System.out.println("Found bind.txt file, will perform binding after processing manga.\n");
        }
        ImageMagick im = new ImageMagick();
        StopWatch sw = new StopWatch();
        sw.start();
        File parentFolder = new File(parent_folder_filename);
        File outputFolder = new File(output_folder_filename);
        ArrayList<File> folderList = FileUtils.getFolderList(parentFolder);
        Collections.sort(folderList);
        if (use_bind) {
            int total_num_binds = 0;
            i = 0;
            while (i < binds.size()) {
                total_num_binds += ((Integer)binds.get(i)).intValue();
                ++i;
            }
            if (total_num_binds > folderList.size()) {
                System.out.println("ERROR: Total number of binds (" + total_num_binds + ") is greater than the number of manga folders (" + folderList.size() + ") in " + parent_folder_filename + ". The number of binds must be equal to or less than the number of manga folders. Please correct the bind.txt file before running again.");
                System.exit(1);
            }
        }
        if (use_bind && manga_prefix.equals(bind_prefix)) {
            System.out.println("WARNING: manga_prefix is the same as bind_prefix. Changing bind_prefix to \"Bind.\".");
            bind_prefix = "Bind.";
        }
        ArrayList<File> newFolderList = new ArrayList<File>();
        System.out.println("Copying files to new folders...");
        i = 0;
        while (i < folderList.size()) {
            String dest;
            File destination;
            File source = folderList.get(i);
            String sourceFilename = source.getName();
            if (!source.exists()) {
                System.out.println("File or directory does not exist.");
                System.exit(0);
            }
            if (!(destination = new File(dest = String.valueOf(output_folder_filename) + File.separatorChar + prefix + sourceFilename.substring(sourceFilename.length() - num_chars_keep_suffix))).exists()) {
                destination.mkdir();
                FileUtils.copyDirectory(source, destination);
            }
            newFolderList.add(destination);
            ++i;
        }
        long time_before_processing = sw.getElapsedTimeSecs();
        System.out.println("Converting all manga scans using ImageMagick...");
        int num_folders_processed = 0;
        int i3 = 0;
        while (i3 < newFolderList.size()) {
            boolean already_zipped = false;
            boolean already_pdfed = false;
            File cur_folder = (File)newFolderList.get(i3);
            if (num_folders_processed != 0) {
                String approx_time_remaining = StopWatch.formatTime((long)(newFolderList.size() - i3) * (sw.getElapsedTimeSecs() - time_before_processing) / (long)num_folders_processed);
                System.out.println("  Processing folder: " + cur_folder.getName() + "... (approx " + approx_time_remaining + " remaining)");
            } else {
                System.out.println("  Processing folder: " + cur_folder.getName() + "...");
            }
            File bookmark_file = new File(String.valueOf(cur_folder.getAbsolutePath()) + File.separatorChar + cur_folder.getName() + ".manga");
            File bookmark_save_file = new File(String.valueOf(cur_folder.getAbsolutePath()) + File.separatorChar + cur_folder.getName() + ".manga_save");
            File zip_file = new File(String.valueOf(output_folder_filename) + cur_folder.getName() + zip_extension);
            File pdf_file = new File(String.valueOf(output_folder_filename) + cur_folder.getName() + ".pdf");
            boolean processed = ConvertManga.isFolderProcessed(progress_file, cur_folder);
            if (zip_file.exists()) {
                already_zipped = true;
            }
            if (pdf_file.exists()) {
                already_pdfed = true;
            }
            if (!processed) {
                ConvertManga.renamePages(cur_folder, page_filename_length);
                ArrayList<File> image_files = FileUtils.getImageFileList(cur_folder);
                Collections.sort(image_files);
                int j = 0;
                while (j < image_files.size()) {
                    File cur_image = image_files.get(j);
                    im.processImage(cur_image);
                    ++j;
                }
                if (image_files.size() > 0 && use_kindle_bookmark) {
                    ConvertManga.writeBookmark(cur_folder, bookmark_file, bookmark_save_file, image_files.get(0));
                }
                ConvertManga.addProcessedFolder(progress_file, cur_folder);
                ++num_folders_processed;
            }
            if (use_zip && !use_bind && !already_zipped) {
                FileUtils.zipFolder(cur_folder, zip_file);
            }
            if (use_pdf && !use_bind && !already_pdfed) {
                im.pdfImageFolder(cur_folder, pdf_file);
            }
            ++i3;
        }
        if (use_bind) {
            System.out.println("\nBeginning binding...");
            ArrayList<File> unbound_folders = FileUtils.getFolderList(outputFolder);
            Collections.sort(unbound_folders);
            int i4 = 0;
            while (i4 < binds.size()) {
                int cur_bind = (Integer)binds.get(i4);
                String bind_title = String.valueOf(title) + "_-_" + bind_prefix + Integer.toString(i4 + 1);
                bind_title = bind_title.replaceAll(" ", "_");
                String bind_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar + bind_title;
                File bind_folder = new File(bind_folder_filename);
                if (bind_folder.exists()) {
                    FileUtils.deleteDirectory(bind_folder);
                }
                bind_folder.mkdir();
                ArrayList<File> folders_to_bind = new ArrayList<File>();
                int j = 0;
                while (j < cur_bind) {
                    folders_to_bind.add(unbound_folders.remove(0));
                    ++j;
                }
                System.out.println("  Binding folders:");
                j = 0;
                while (j < folders_to_bind.size()) {
                    System.out.println("    " + ((File)folders_to_bind.get(j)).getName());
                    ++j;
                }
                System.out.println("  to form " + bind_title + "...");
                ConvertManga.bindFolders(folders_to_bind, bind_folder, output_folder_filename, im, use_zip, zip_extension, use_pdf, use_kindle_bookmark, page_filename_length);
                ++i4;
            }
        }
        sw.stop();
        System.out.println("\nFinished.");
        System.out.println("Total time: " + StopWatch.formatTime(sw.getElapsedTimeSecs()));
        System.out.println("Check folder " + output_folder_filename + " for output.");
    }
}

