#!/usr/local/bin/python 
# -*- coding: utf-8 -*-

import sys
import sqlite3
from optparse import OptionParser
import os
import re






usage = "Usage: %prog [options] your_zotero.sqlite"

opt = OptionParser(usage)


opt.add_option("-i",
               help="Create index if 1, drop index if 0, default 1",
               type="int",
               dest="withidx",
               default=1
)
opt.add_option("-o",
               help="Create Publication column if 1, do not if 0, default 0",
               type="int",
               dest="opf",
               default=0
)
opt.add_option("-m",
               help="Create meta_db if 1, do not if 0, default 1",
               type="int",
               dest="with_metadb",
               default=1
)
opt.add_option("-d",
               help="Output directory, default is current",
               type="string",
               dest="outdir",
               default=""
)

(options,args)=opt.parse_args()

withidx = options.withidx
opf = options.opf
with_metadb = options.with_metadb
outdir = options.outdir


if outdir != "":
  outdir=re.sub("\/$","",outdir)
  outdir=outdir + "/"

zbishare = outdir + "Programs/_zbi/share/zbi"



if len(args) == 0:
  opt.print_help()
  sys.exit()
else:
  zoterodbfile = args[0]

if not os.path.isfile(zoterodbfile):
  print "zotero dbfile ", zoterodbfile, " not exists."
  sys.exit()

if not os.path.isdir(zbishare):
  os.makedirs(zbishare)
  

db = sqlite3.connect(zbishare + "/zbi.sqlite")
db.execute("ATTACH \'"+ zoterodbfile +"\' AS zotero")




zoterois2 = db.execute("SELECT COUNT(*) FROM zotero.sqlite_master WHERE type='table' AND name='creatorData';").fetchone()[0]





print "zotero version ", zoterois2+1
print "Create Index", withidx
print "Publication Column ", opf
print "Create MetaDB ", with_metadb



if withidx > 0:
 rmidx = re.compile("\/\\* withoutidx \\*\/.*?\/\\* withoutidx \\*\/",re.M | re.S)
else:
 rmidx = re.compile("\/\\* withidx \\*\/.*?\/\\* withidx \\*\/",re.M | re.S)


if opf > 0:
 rmopf = re.compile("\/\\* noopf \\*\/.*?\/\\* noopf \\*\/",re.M | re.S)
else:
 rmopf = re.compile("\/\\* opf \\*\/.*?\/\\* opf \\*\/",re.M | re.S)


if zoterois2 > 0:
 rmversion = re.compile("\/\\* zotero1 \\*\/.*?\/\\* zotero1 \\*\/",re.M | re.S)
else:
 rmversion = re.compile("\/\\* zotero2 \\*\/.*?\/\\* zotero2 \\*\/",re.M | re.S)


rmcomment = re.compile("\/\\* .*? \\*\/")

sqlfile = open("sql.txt",'r')

sql = rmcomment.sub("",rmopf.sub("",rmidx.sub("",rmversion.sub("",sqlfile.read()))))
sql = re.sub("\n","",sql)
sql = re.sub(";",";\n",sql)


sqlfile.close()

#print sql


db.executescript(sql)

db.execute("DETACH 'zotero'")
db.close


conffile = open(zbishare + "/zbi.conf",'w')

conffile.write("""

[DATABASE]
on_memory=0
with_idx=%(withidx)s
publication=%(opf)s

[META-DATA]
with_metadb=%(with_metadb)s

[FLAG]
change_applied=1
"""%locals()
)

conffile.close()


sys.exit()
