#!/usr/local/bin/ruby 

begin
require "rubygems"
rescue LoadError
end

require 'optparse'
require 'sqlite3'



withidx = 1
opf = 0
with_metadb = 1
outdir = ""


opt = OptionParser.new

opt.summary_width = 10
opt.banner = "Usage: zotero2zbi.rb [options] your_zotero.sqlite"
opt.on('-i [01]','Create index if 1, drop index if 0, default 1',Integer) {|v| withidx = v if v}
opt.on('-o [01]','Create Publication column if 1, do not if 0, default 0',Integer) {|v| opf = v if v}
opt.on('-m [01]','Create meta_db if 1, do not if 0, default 1',Integer) {|v| with_metadb = v if v}
opt.on('-d [DIR]','Output directory, default is current',String) {|v| outdir = v if v}

opt.parse!(ARGV)

if outdir != ""
  outdir.sub(/\/$/,"")
  outdir << "/"
end

zbishare = outdir+"Programs/_zbi/share/zbi"

zoterodbfile = ARGV.shift.to_s

if zoterodbfile == "" 
  puts opt.to_s
  exit
end

unless File.file?(zoterodbfile)
  puts "zotero dbfile " + zoterodbfile + " not exists."
  exit
end


FileUtils::mkdir_p(zbishare)

db = SQLite3::Database.new(zbishare+"/zbi.sqlite")

db.execute("ATTACH '#{zoterodbfile}' AS zotero")



zoterois2 = db.get_first_value("SELECT COUNT(*) FROM zotero.sqlite_master WHERE type='table' AND name='creatorData';").to_i

puts "zotero version #{zoterois2+1}"
puts "Create Index #{withidx}"
puts "Publication Column #{opf}"
puts "Create MetaDB #{with_metadb}"


if withidx > 0
 rmidx = Regexp.new("\/\\* withoutidx \\*\/.*?\/\\* withoutidx \\*\/",Regexp::MULTILINE)
else
 rmidx = Regexp.new("\/\\* withidx \\*\/.*?\/\\* withidx \\*\/",Regexp::MULTILINE)
end

if opf > 0
 rmopf = Regexp.new("\/\\* noopf \\*\/.*?\/\\* noopf \\*\/",Regexp::MULTILINE)
else
 rmopf = Regexp.new("\/\\* opf \\*\/.*?\/\\* opf \\*\/",Regexp::MULTILINE)
end


if zoterois2 > 0
 rmversion = Regexp.new("\/\\* zotero1 \\*\/.*?\/\\* zotero1 \\*\/",Regexp::MULTILINE)
else
 rmversion = Regexp.new("\/\\* zotero2 \\*\/.*?\/\\* zotero2 \\*\/",Regexp::MULTILINE)
end

rmcomment = Regexp.new("\/\\* .*? \\*\/")

sqlfile = open("sql.txt")

sql = sqlfile.read.gsub(rmversion,"").gsub(rmidx,"").gsub(rmopf,"").gsub(rmcomment,"").gsub(/\n/,"").gsub(/\;/,";\n")

sqlfile.close


db.transaction do
  db.execute_batch(sql)
end

db.execute("DETACH 'zotero'")

db.close



conffile = open(zbishare + "/zbi.conf","w")

conffile.print <<EOF

[DATABASE]
on_memory=0
with_idx=#{withidx}
publication=#{opf}

[META-DATA]
with_metadb=#{with_metadb}

[FLAG]
change_applied=1
EOF

conffile.close


exit



