#!/usr/local/bin/perl

use DBI;
use Getopt::Long;
use File::Path;

my $zoterois2, $withidx, $opf, $with_metadb, $outdir, $zbishare;

my $usage = 
    "Usage: zotero2zbi.rb [options] your_zotero.sqlite\n".
    "    -i [01]    Create index if 1, drop index if 0, default 1\n".
    "    -o [01]    Create Publication column if 1, do not if 0, default 0\n".
    "    -m [01]    Create meta_db if 1, do not if 0, default 1\n".
    "    -d [DIR]   Output directory, default is current\n";



$withidx = 1;
$opf = 0;
$with_metadb = 1;
$outdir = "";

GetOptions(
    'index:1'=>\$withidx,
    'optioncolumn:0'=>\$opf,
    'metadb:1'=>\$with_metadb,
    'directory:s'=>\$outdir,
    );

if ($outdir ne ""){
    $outdir =~ s/\/$//;
    $outdir = $outdir . "/";
}

$zbishare = $outdir . "Programs/_zbi/share/zbi";


unless(@ARGV){
    print "$usage";
    exit;
}




my $zoterodbfile = $ARGV[0];
#print $zoterodbfile."\n";

unless (-e $zoterodbfile){
    print "zotero dbfile " . $zoterodbfile . " not exists.\n";
    exit;
}

eval{
    mkpath($zbishare);
};
die "$@" if ($@);


my $dbfile = $zbishare . "/zbi.sqlite"; 
my $dbh = DBI->connect("dbi:SQLite:dbname=$dbfile","","")
    or die $DBI::errstr;

$dbh->func(5000,"busy_timeout");


$dbh->do("ATTACH '$zoterodbfile' AS zotero") or die $dbh->errstr;


my $sth = $dbh->prepare("SELECT COUNT(*) FROM zotero.sqlite_master WHERE type='table' AND name='creatorData';") or die $dbh->errstr;

$sth->execute or die $sth->errstr;

#while (my @row = $sth->fetchrow_array){
#    print join(',', @row)."\n";
#}
#my $result = $sth->fetchall_arrayref;
#my $zoterois2 = int( shift(@{@$result[0]}) );

$zoterois2 = int( shift(@{@{$sth->fetchall_arrayref}[0]}) );

print "zotero version ", $zoterois2+1, "\n";
print "Create Index $withidx \n";
print "Publication Column $opf \n";
print "Create MetaDB $with_metadb \n";




if ($withidx > 0){
 $rmidx = "\/\\* withoutidx \\*\/.*?\/\\* withoutidx \\*\/";
}else{
 $rmidx = "\/\\* withidx \\*\/.*?\/\\* withidx \\*\/";
}






if ($zoterois2 > 0){
 $rmversion = "\/\\* zotero1 \\*\/.*?\/\\* zotero1 \\*\/";
}else{
 $rmversion = "\/\\* zotero2 \\*\/.*?\/\\* zotero2 \\*\/";
}




open(SQLFILE, "<sql.txt");

$sqlfile = join("",<SQLFILE>);

close(SQLFILE);

$sqlfile =~ s/$rmversion//gs;
$sqlfile =~ s/$rmidx//gs;
$sqlfile =~ s/\/\* opf \*\/.*?\/\* opf \*\///gs if $opf == 0;
$sqlfile =~ s/\/\* noopf \*\/.*?\/\* noopf \*\///gs if $opf > 0;
$sqlfile =~ s/\/\*.*?\*\///g;
$sqlfile =~ s/\n//g;


# print $sqlfile;

@sqls = split( /\;/, $sqlfile);


$dbh->begin_work;

foreach(@sqls){
#    print;
#    print "\n";
    $dbh->do($_) or die $dbh->errstr;
}

$dbh->commit;





$dbh->do("DETACH 'zotero' ") or die $dbh->errstr;



$dbh->disconnect;



my $conffile = $zbishare . "/zbi.conf";

my $contents = <<"EOF";

[DATABASE]
on_memory=0
with_idx=$withidx
publication=$opf

[META-DATA]
with_metadb=$with_metadb

[FLAG]
change_applied=1
EOF




open(CONFFILE,">$conffile");
print CONFFILE $contents;
close(CONFFILE);




exit;
