/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;

public class ConvertManga {
    public static File default_bookmark = new File("./default.manga");

    public static void renamePages(File folder, int page_filename_length) {
        File cur_image;
        ArrayList<File> image_files = FileUtils.getImageFileList(folder);
        Collections.sort(image_files);
        ArrayList<File> cover_image_files = new ArrayList<File>();
        ArrayList<File> credit_image_files = new ArrayList<File>();
        int i = 0;
        while (i < image_files.size()) {
            cur_image = image_files.get(i);
            if (cur_image.getName().toLowerCase().contains("cover")) {
                image_files.remove(i);
                cover_image_files.add(cur_image);
                --i;
            } else if (cur_image.getName().toLowerCase().contains("credit")) {
                image_files.remove(i);
                credit_image_files.add(cur_image);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < cover_image_files.size()) {
            image_files.add(0, (File)cover_image_files.get(cover_image_files.size() - i - 1));
            ++i;
        }
        i = 0;
        while (i < credit_image_files.size()) {
            image_files.add((File)credit_image_files.get(i));
            ++i;
        }
        i = 0;
        while (i < image_files.size()) {
            cur_image = image_files.get(i);
            String extension = ExtFilter.getExtension(cur_image);
            String new_name = Integer.toString(i);
            while (new_name.length() < page_filename_length) {
                new_name = "0" + new_name;
            }
            File new_image = new File(String.valueOf(cur_image.getParent()) + File.separatorChar + new_name + extension);
            cur_image.renameTo(new_image);
            ++i;
        }
    }

    public static void writeBookmark(File cur_dir, File bookmark_file, File bookmark_save_file, File first_file) {
        try {
            FileOutputStream out = new FileOutputStream(bookmark_file);
            byte[] b = new byte[]{0};
            ((OutputStream)out).write(b);
            ((OutputStream)out).close();
            BufferedWriter bw = new BufferedWriter(new FileWriter(bookmark_save_file));
            bw.write("LAST=/mnt/us/pictures/" + cur_dir.getName() + "/" + first_file.getName());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void outputUsage() {
        System.out.println("\nPurpose: Convert a collection of manga scans into ereader devices such as the Kindle DX, Kindle 2, and iPad.");
        System.out.println("Usage: ConvertManga [mandatory_arguments] [other_options]");
        System.out.println("\nMandatory Arguments: (these arguments MUST be specified)");
        System.out.println("-parent_folder /path/to/parent_folder/");
        System.out.println("  The parent folder containing subfolders representing chapters.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path (for example, \"C:\\\\Program Files\\\\manga parent folder\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("-prefix \"Manga Title - Ch.\"");
        System.out.println("  The naming convention used for each new subfolder title.");
        System.out.println("-num_chars_keep_suffix [integer]");
        System.out.println("  Number of characters to keep from original subfolder suffix.");
        System.out.println("\nOther Options: (these are all optional)");
        System.out.println("-output_folder /path/to/output_folder/");
        System.out.println("  The output parent folder. Default is to use the -parent_folder.");
        System.out.println("  If the path contains spaces, then put double-quotes around the path (for example, \"C:\\\\Program Files\\\\manga parent folder\\\\\"");
        System.out.println("  Windows users: Use double back-spaces \\\\ instead of single back-spaces \\ in the path.");
        System.out.println("\nSee ConvertManga.properties for conversion settings.");
        System.out.println("\nSee readme.txt for manga organization requirements and other tips.");
        System.out.println("");
        System.exit(0);
    }

    public static boolean isFolderProcessed(File progress_file, File folder) {
        boolean found = false;
        String folder_path = folder.getAbsolutePath();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(progress_file));
            while (!found && (line = br.readLine()) != null) {
                if (!line.equals(folder_path)) continue;
                found = true;
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return found;
    }

    public static void addProcessedFolder(File progress_file, File folder) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(progress_file, true));
            bw.write(String.valueOf(folder.getAbsolutePath()) + "\n");
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        String parent_folder_filename = null;
        String output_folder_filename = null;
        String prefix = null;
        File progress_file = null;
        int num_chars_keep_suffix = 3;
        if (args.length == 0) {
            ConvertManga.outputUsage();
        } else if (args.length % 2 != 0) {
            System.out.println("ERROR: Invalid number of arguments.");
            ConvertManga.outputUsage();
        } else {
            boolean parsed_parent_folder = false;
            boolean parsed_prefix = false;
            boolean parsed_num_chars_keep_suffix = false;
            int i = 0;
            while (i < args.length) {
                String option = args[i];
                String option_value = args[++i];
                if (option.equalsIgnoreCase("-parent_folder")) {
                    parent_folder_filename = option_value;
                    if (parent_folder_filename.charAt(parent_folder_filename.length() - 1) != File.separatorChar) {
                        parent_folder_filename = String.valueOf(parent_folder_filename) + File.separatorChar;
                    }
                    parsed_parent_folder = true;
                } else if (option.equalsIgnoreCase("-prefix")) {
                    prefix = option_value;
                    prefix = prefix.replaceAll(" ", "_");
                    parsed_prefix = true;
                } else if (option.equalsIgnoreCase("-num_chars_keep_suffix")) {
                    num_chars_keep_suffix = Integer.parseInt(option_value);
                    parsed_num_chars_keep_suffix = true;
                } else if (option.equalsIgnoreCase("-output_folder")) {
                    output_folder_filename = option_value;
                    if (output_folder_filename.charAt(output_folder_filename.length() - 1) != File.separatorChar) {
                        output_folder_filename = String.valueOf(output_folder_filename) + File.separatorChar;
                    }
                } else {
                    System.out.println("ERROR: Invalid option \"" + option + "\"");
                    ConvertManga.outputUsage();
                }
                ++i;
            }
            if (!(parsed_parent_folder && parsed_prefix && parsed_num_chars_keep_suffix)) {
                System.out.println("ERROR: Not all mandatory arguments were specified.");
                ConvertManga.outputUsage();
            }
            if (output_folder_filename == null) {
                output_folder_filename = parent_folder_filename;
            } else {
                File output_folder_file = new File(output_folder_filename);
                if (!output_folder_file.exists()) {
                    output_folder_file.mkdir();
                }
            }
            progress_file = new File(String.valueOf(output_folder_filename) + File.separatorChar + "progress.txt");
            if (!progress_file.exists()) {
                progress_file.createNewFile();
            }
        }
        PropertiesLoader pl = new PropertiesLoader();
        boolean use_zip = pl.getZip();
        boolean use_pdf = pl.getPdf();
        boolean use_kindle_bookmark = pl.getKindleBookmark();
        int page_filename_length = pl.getPageFilenameLength();
        pl.printProperties();
        ImageMagick im = new ImageMagick();
        StopWatch sw = new StopWatch();
        sw.start();
        File parentFolder = new File(parent_folder_filename);
        ArrayList<File> folderList = FileUtils.getFolderList(parentFolder);
        Collections.sort(folderList);
        ArrayList<File> newFolderList = new ArrayList<File>();
        System.out.println("Copying files to new folders...");
        int i = 0;
        while (i < folderList.size()) {
            String dest;
            File destination;
            File source = folderList.get(i);
            String sourceFilename = source.getName();
            if (!source.exists()) {
                System.out.println("File or directory does not exist.");
                System.exit(0);
            }
            if (!(destination = new File(dest = String.valueOf(output_folder_filename) + File.separatorChar + prefix + sourceFilename.substring(sourceFilename.length() - num_chars_keep_suffix))).exists()) {
                destination.mkdir();
                FileUtils.copyDirectory(source, destination);
            }
            newFolderList.add(destination);
            ++i;
        }
        long time_before_processing = sw.getElapsedTimeSecs();
        System.out.println("Converting all manga scans using ImageMagick...");
        int num_folders_processed = 0;
        int i2 = 0;
        while (i2 < newFolderList.size()) {
            boolean delete_directory = false;
            boolean already_zipped = false;
            boolean already_pdfed = false;
            File cur_folder = (File)newFolderList.get(i2);
            if (num_folders_processed != 0) {
                String approx_time_remaining = StopWatch.formatTime((long)(newFolderList.size() - i2) * (sw.getElapsedTimeSecs() - time_before_processing) / (long)num_folders_processed);
                System.out.println("  Processing folder: " + cur_folder.getName() + "... (approx " + approx_time_remaining + " remaining)");
            } else {
                System.out.println("  Processing folder: " + cur_folder.getName() + "...");
            }
            File bookmark_file = new File(String.valueOf(cur_folder.getAbsolutePath()) + File.separatorChar + cur_folder.getName() + ".manga");
            File bookmark_save_file = new File(String.valueOf(cur_folder.getAbsolutePath()) + File.separatorChar + cur_folder.getName() + ".manga_save");
            File zip_file = new File(String.valueOf(output_folder_filename) + cur_folder.getName() + ".zip");
            File pdf_file = new File(String.valueOf(output_folder_filename) + cur_folder.getName() + ".pdf");
            boolean processed = ConvertManga.isFolderProcessed(progress_file, cur_folder);
            if (zip_file.exists()) {
                already_zipped = true;
            }
            if (pdf_file.exists()) {
                already_pdfed = true;
            }
            if (!processed) {
                ConvertManga.renamePages(cur_folder, page_filename_length);
                ArrayList<File> image_files = FileUtils.getImageFileList(cur_folder);
                Collections.sort(image_files);
                int j = 0;
                while (j < image_files.size()) {
                    File cur_image = image_files.get(j);
                    im.processImage(cur_image);
                    ++j;
                }
                if (image_files.size() > 0 && use_kindle_bookmark) {
                    ConvertManga.writeBookmark(cur_folder, bookmark_file, bookmark_save_file, image_files.get(0));
                }
                ConvertManga.addProcessedFolder(progress_file, cur_folder);
                ++num_folders_processed;
            }
            if (use_zip && !already_zipped) {
                FileUtils.zipFolder(cur_folder, zip_file);
            }
            if (use_pdf && !already_pdfed) {
                im.pdfImageFolder(cur_folder, pdf_file);
            }
            if (delete_directory) {
                FileUtils.deleteDirectory(cur_folder);
            }
            ++i2;
        }
        sw.stop();
        System.out.println("\nFinished.");
        System.out.println("Total time: " + StopWatch.formatTime(sw.getElapsedTimeSecs()));
        System.out.println("Check folder " + output_folder_filename + " for output.");
    }
}

