/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class PropertiesLoader {
    private Properties props = new Properties();
    private static String key_width = "width";
    private static String key_height = "height";
    private static String key_max_dpi = "max_dpi";
    private static String key_autotrim = "autotrim";
    private static String key_trim_fuzz = "trim_fuzz";
    private static String key_color_mode = "color_mode";
    private static String key_num_colors = "num_colors";
    private static String key_page_filename_length = "page_filename_length";
    private static String key_pdf = "pdf";
    private static String key_zip = "zip";
    private static String key_image_format = "image_format";
    private static String key_image_magick_dir = "image_magick_dir";
    private static String key_kindle_bookmark = "kindle_bookmark";
    private static String properties_filename = "ConvertManga.properties";

    public PropertiesLoader() {
        try {
            FileInputStream fis = new FileInputStream(properties_filename);
            this.props.load(fis);
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getWidth() {
        return this.intKeyValue(this.props.getProperty(key_width));
    }

    public int getHeight() {
        return this.intKeyValue(this.props.getProperty(key_height));
    }

    public int getMaxDPI() {
        return this.intKeyValue(this.props.getProperty(key_max_dpi));
    }

    public int getPageFilenameLength() {
        return this.intKeyValue(this.props.getProperty(key_page_filename_length));
    }

    public boolean getAutotrim() {
        return this.booleanKeyValue(this.props.getProperty(key_autotrim));
    }

    public int getTrimFuzz() {
        return this.intKeyValue(this.props.getProperty(key_trim_fuzz));
    }

    public String getColorMode() {
        return this.props.getProperty(key_color_mode);
    }

    public int getNumColors() {
        return this.intKeyValue(this.props.getProperty(key_num_colors));
    }

    public boolean getPdf() {
        return this.booleanKeyValue(this.props.getProperty(key_pdf));
    }

    public boolean getZip() {
        return this.booleanKeyValue(this.props.getProperty(key_zip));
    }

    public String getImageFormat() {
        return this.props.getProperty(key_image_format);
    }

    public String getImageMagickDir() {
        return this.props.getProperty(key_image_magick_dir);
    }

    public boolean getKindleBookmark() {
        return this.booleanKeyValue(this.props.getProperty(key_kindle_bookmark));
    }

    public int intKeyValue(String value) {
        return Integer.parseInt(value);
    }

    public boolean booleanKeyValue(String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return false;
    }

    public void printProperties() {
        System.out.println("\nUsing these settings stored in " + properties_filename + ":");
        System.out.println("  width (in pixels):  " + this.getWidth());
        System.out.println("  height (in pixels): " + this.getHeight());
        System.out.println("  maximum dpi: " + this.getMaxDPI());
        boolean use_autotrim = this.getAutotrim();
        System.out.println("  autotrim pages: " + use_autotrim);
        if (use_autotrim) {
            System.out.println("    trim fuzz: " + this.getTrimFuzz() + "%");
        }
        System.out.println("  color mode: " + this.getColorMode());
        int num_colors = this.getNumColors();
        if (num_colors != -1) {
            System.out.println("  num colors: " + num_colors);
        } else {
            System.out.println("  num colors: full");
        }
        System.out.println("  pdf chapters: " + this.getPdf());
        System.out.println("  zip chapters: " + this.getZip());
        System.out.println("  image format: " + this.getImageFormat());
        System.out.println("  kindle bookmark: " + this.getKindleBookmark());
        System.out.println("  ImageMagick home directory: " + this.getImageMagickDir());
        System.out.println("");
    }
}

