﻿// Description: Sample localization file
// Author: kartu
// 
// Language: catalan
// Translate by surquizu
return {
	// Standard stuff
	Sony: {
		// USB connected
		DO_NOT_DISCONNECT: "No Desconectar!",
		USB_CONNECTED: "USB conectat",
		DEVICE_LOCKED: "Lector Bloquejat",

		// About, translate either all or none
		ABOUT_PRSP: "PRS+ Script: @@@script@@@\n" +
			"PRS+ Firmware: @@@firmware@@@\n" +
			"Autor: Mikheil Sukhiashvili aka kartu (kartu3@gmail.com) using work of: " + 
			"igorsk, boroda, obelix, pepak, llasram and others.\n" +
			"© GNU Lesser General Public License.",
		ABOUT_1: "Copyright ©2006-2008 Sony Corporation",
		ABOUT_2: "Adobe, the Adobe logo, Reader and PDF are either registered trademarks or" + 
			" trademarks of Adobe Systems Incorporated in the United States and/or other countries.",
		ABOUT_3: "MPEG Layer-3 audio coding technology and patents licensed by Fraunhofer IIS and Thomson." + 
			" MPEG-4 AAC audio coding technology licensed by Fraunhofer IIS (www.iis.fraunhofer.de/amm/).",
		ABOUT_4: "Application software designed and implemented by Kinoma (www.kinoma.com). Portions Copyright ©2006,2007 Kinoma, Inc.",
		ABOUT_5: "Bitstream is a registered trademark, and Dutch, Font Fusion, and Swiss are trademarks, of Bitstream, Inc.",
		ABOUT_6: "Portions of this software are Copyright ©2005 The FreeType Project (www.freetype.org). All rights reserved.",
		ABOUT_7: "This software is based in part on the work of the Independent JPEG Group.",
		AUTHORIZED_SONY: "Authorized for the eBook Store.",
		NOT_AUTHORIZED_SONY: "Not authorized for the eBook Store.",
		AUTHORIZED_ADOBE: "This device is authorized for Adobe DRM protected content.",
		NOT_AUTHORIZED_ADOBE: "This device is not authorized for Adobe DRM protected content.",
		SONY_FW_VERSION: "Version",
		DEVICE_ID: "Device",
		
		// Mime & card names
		RICH_TEXT_FORMAT: "Text de Format Enriquit",
		ADOBE_PDF: "Adobe PDF",
		EPUB_DOCUMENT: "Document EPUB",
		BBEB_BOOK: "Llibre BBeB",
		PLAIN_TEXT: "Text Sense Format",
		INTERNAL_MEMORY: "Memòria Interna",
		MEMORY_STICK: "Memory Stick",
		SD_CARD: "Targeta SD",
		
		// Main.xml & kbook.so stuff
		INVALID_FORMAT: "Format No V"+String.fromCharCode(224)+"lid!",
		FORMATTING: "Formatejant...",
		LOADING: "Carregant ...",
		LOW_BATTERY: "Bateria Baixa!",
		HR_WARNING: "Vols ESBORRAR tot el contingut i restablir els ajustaments inicials i l'estat de l'autoritzaci"+String.fromCharCode(243)+" del DRM?\n\nSi - Clica 5\nNo - Clica MENU",
		DEVICE_SHUTDOWN: "Apagar Lector",
		PRESS_MARK_TO_SHUTDOWN: "Clica MARK per apagar",
		THIS_DEVICE: "el lector.",
		PRESS_MARK_TO_DELETE: "Clica MARK per",
		THIS_BOOK: "esborrar el llibre.",
		FORMAT_INTERNAL_MEMORY: "Formatejar Memòria Interna",
		PRESS_MARK_TO_FORMAT: "Clica MARK per a formatejar",
		MSG_INTERNAL_MEMORY: "la memòria interna.",
		RESTORE_DEFAULTS: "Restablir Valors Inicials",
		PRESS_MARK_TO_RESTORE: "Clica MARK per a restablir",
		DEFAULT_SETTINGS: "els valors inicials.",
		UPPER_PAGE: "P"+String.fromCharCode(192)+"GINA",
		ONE_OF_ONE: "1 de 1",
		NO_BATTERY: "Sense Bateria!",
		FORMATTING_INTERNAL_MEMORY: "Formatejant Memòria Interna...",
		SHUTTING_DOWN: "Apagant...",
		
		// Root menu
		CONTINUE: "Continuar Llegint",
		BOOKS_BY_TITLE: "Llibres per T"+String.fromCharCode(237)+"tol",
		BOOKS_BY_AUTHOR: "Llibres per Autor",
		BOOKS_BY_DATE: "Llibres per Data",
		COLLECTIONS: "Col·leccions",
		ALL_BOOKMARKS: "Marcadors",
		NOW_PLAYING: "Reproduint-se Ara",
		MUSIC: ""+String.fromCharCode(192)+"udio",
		PICTURES: "Imatges",
		SETTINGS: "Ajustaments",

		// In Settings
		// orientation
		ORIENTATION: "Orientaci"+String.fromCharCode(243)+"",
		HORIZONTAL: "Horitzontal",
		VERTICAL: "Vertical",
		// set date
		SET_DATE: "Data i Hora",
		YEAR: "Any",
		MONTH: "Mes",
		DATE: "D"+String.fromCharCode(237)+"a", // Day
		HOUR: "Hora",
		MINUTE: "Minut",
		// slideshow
		SLIDESHOW: "Presentaci"+String.fromCharCode(243)+" Diapositives",
		SS_ON: "Activat",
		SS_OFF: "Desactivat",
		SS_TURN: "Estat",
		SS_DURATION: "Durada",
		SECONDS: "Segons",
		// auto standby (aka sleep mode)
		AUTOSTANDBY: "Mode en Repòs",
		AS_ON: "Activat",
		AS_OFF: "Desactivat",
		AS_TURN: "Estat",
		// about
		ABOUT: "Sobre el Reader",
		// reset to factory settings
		RESET_TO_FACTORY: "Valors Inicials",
		
		// In Advanced Settings
		ADVANCED_SETTINGS: "Ajustaments Avan"+String.fromCharCode(231)+"ats",
		// screen lock (aka device lock)
		SCREEN_LOCK: "Bloquejar Lector",
		SL_OFF: "Desactivat",
		SL_ON: "Activat",
		SL_CODE: "Codi",
		SL_TURN: "Estat",
		// format device
		FORMAT_DEVICE: "Formatejar Lector",
		
		// In Book menu
		BEGIN: "Inici",
		END: "Final",
		BOOKMARKS: "Marcadors",
		CONTENTS: "Index de Continguts",
		HISTORY: "Historial",
		INFO: "Informaci"+String.fromCharCode(243)+"",
		UTILITIES: "Utilitats",
		
		// In Book Utilities
		REMOVE_ALL_BOOKMARKS: "Esborrar Marcadors",
		CLEAR_HISTORY: "Esborrar Historial",
		DELETE_BOOK: "Esborrar Llibre",
		
		// In Books by Date
		TODAY: "Avui",
		EARLIER_THIS_WEEK: "Principis de Setmana",
		LAST_WEEK: "Darrera Setmana",
		EARLIER_THIS_MONTH: "Principis de Mes",
		LAST_MONTH: "Darrer Mes",
		EARLIER_THIS_QUARTER: "Principis de Trimestre",
		LAST_QUARTER: "Darrer Trimestre",
		EARLIER_THIS_YEAR: "Principis d'Any",
		LAST_YEAR: "Darrer Any",
		OLDER: "Mes Antics",		
		
		PAGE: "P"+String.fromCharCode(224)+"gina",
		PART: "Part",
		OF: "de",
		NO_BOOK: "Cap llibre",
		NO_SONG: "Cap can"+String.fromCharCode(231)+""+String.fromCharCode(243)+"",

		// Info title strings, comma separated, no spaces after comma
		INFO_TITLES: "Portada,T"+String.fromCharCode(237)+"tol,Autor,Editorial,Categor"+String.fromCharCode(237)+"a,eBook ID,Tipus,Data,Mida,Ubicaci"+String.fromCharCode(243)+",Arxius,Drets Digitals,Caducitat",
		
		// Titles and criterions for "Books by Title" and "Books by Folder"
		// title is displayed, "criterion" is used for sorting.
		//
		// NOTE: if localization doesn't need custom Books by sorting, just remove CUSTOM_SORT, TITLE_*, CRITERION_* items
		CUSTOM_SORT: true, 
		TITLE_1: "0-9",
		CRITERION_1: "0123456789",
		TITLE_2: "A B C",
		CRITERION_2: "ABCabc",
		TITLE_3: "D E F",
		CRITERION_3: "DEFdef",
		TITLE_4: "G H I",
		CRITERION_4: "GHIghi",
		TITLE_5: "J K L",
		CRITERION_5: "JKLjkl",
		TITLE_6: "M N O",
		CRITERION_6: "MNOmno",
		TITLE_7: "P Q R S",
		CRITERION_7: "PQRSpqrs",
		TITLE_8: "T U V",
		CRITERION_8: "TUVWtuvw",
		TITLE_9: "W X Y Z",
		CRITERION_9: "XYZxyz",
		TITLE_0: "Altres",
		CRITERION_0: "",

		// Utility function, no need to localize
		toDoubleDigit: function (num) {
			if (num < 10) {
				return "0" + num;
			} else {
				return num;
			}
		},
		FUNC_GET_DATE_TIME: function (date) {
			return this.FUNC_GET_DATE(date) + " " + this.FUNC_GET_TIME(date);
		},
		FUNC_GET_DATE: function (date) {
			var day, month, year;
			day = this.toDoubleDigit(date.getDate());
			month = this.toDoubleDigit(date.getMonth() + 1); 
			year = date.getFullYear();
			return month + "/" + day + "/" + year;
		},
		FUNC_GET_TIME: function (date) {
			var hour, minute;
			hour = this.toDoubleDigit(date.getHours());
			minute = this.toDoubleDigit(date.getMinutes());
			return hour + ":" + minute;
		},
		FUNC_X_PAGES: function (n) {
			return this.FUNC_X_SOMETHING(n, "p"+String.fromCharCode(224)+"gines", "1 p"+String.fromCharCode(224)+"gina", "Cap p"+String.fromCharCode(224)+"gina");
		},
		FUNC_X_ITEMS: function (n) {
			return this.FUNC_X_SOMETHING(n, "elements", "1 element", "Cap element");
		},
		FUNC_X_SETTINGS: function (n) {
			return this.FUNC_X_SOMETHING(n, "ajustaments", "1 ajustament", "Cap Ajustament");
		},
		FUNC_X_PICTURES: function (n) {
			return this.FUNC_X_SOMETHING(n, "imatges", "1 imatge", "Cap imatge");
		},
		FUNC_X_SONGS: function (n) {
			return this.FUNC_X_SOMETHING(n, "can"+String.fromCharCode(231)+"ons", "1 can"+String.fromCharCode(231)+"o", "Cap can"+String.fromCharCode(231)+"o");
		},
		FUNC_X_BOOKMARKS: function (n) {
			return this.FUNC_X_SOMETHING(n, "marcadors", "1 marcador", "Cap marcador");
		},
		FUNC_X_COLLECTIONS: function (n) {
			return this.FUNC_X_SOMETHING(n, "col"+String.fromCharCode(183)+"leccions", "1 col"+String.fromCharCode(183)+"lecci"+String.fromCharCode(243)+"", "Cap col"+String.fromCharCode(183)+"lecci"+String.fromCharCode(243)+"");
		},
		FUNC_X_BOOKS: function (n) {
			return this.FUNC_X_SOMETHING(n, "llibres", "1 llibre", "Cap llibre");
		},
		FUNC_X_SOMETHING: function (n, many, one, zero) {
			if (n > 1) {
				return n + " " + many;
			} else if (n == 1) {
				return one;
			} else {
				return zero;
			}
		}
	},
	
	// PRS+ stuff
	MenuCaptions: {
	TITLE: "Men"+String.fromCharCode(250)+" T"+String.fromCharCode(237)+"tols",
	TITLE_COMMENT: "Permet escollir l'estil dels t"+String.fromCharCode(237)+"tols dels men"+String.fromCharCode(250)+"s",
	OPTION_STYLE: "Estil T"+String.fromCharCode(237)+"tols",
	VALUE_SONY_DEFAULT: "Original Sony",
	VALUE_ALWAYS_SMALL: "T"+String.fromCharCode(237)+"tols petits",
	VALUE_ALWAYS_BIG: "T"+String.fromCharCode(237)+"tols grans"
	},
	
	TextEncoding: {
		TITLE:"Codificaci"+String.fromCharCode(243)+" de Text",
		COMMENT:"Afecta als llibres en format TXT i RTF, requereix reiniciar",
		OPTION_TITLE:"Codificaci"+String.fromCharCode(243)+"",
		DESCRIPTION:"Permet escollir la codificaci"+String.fromCharCode(243)+" del text",
		LATIN:"Car"+String.fromCharCode(224)+"cters llatins",
		RUSSIAN:"Car"+String.fromCharCode(224)+"cters russos (win1251)"
	},
	
	KeyBindings: {
	TITLE: "Configuraci"+String.fromCharCode(243)+" Tecles",
	DESCRIPTION: "Permet asignar accions a les tecles",
	
	DEFAULT_VALUE: "per defecte",
		
		// Contexts
	GLOBAL:  "En tot moment",
	IN_MENU: "En els men"+String.fromCharCode(250)+"s",
	IN_BOOK:  "Durant la lectura",
		
		// Button groups
	NUM_BUTTONS: "Tecles num"+String.fromCharCode(232)+"riques",
	JP_BUTTONS: "Tecles del Joypad",
	OTHER_BUTTONS: "Altres tecles",
	VOLUME_BUTTONS: "Tecles del volum",
		
		// Buttons
	BN_SIZE: "Zoom",
	BN_BOOKMARK: "Marca de lectura",
	BN_BL_NEXT: "Abaix esquerra 'seg"+String.fromCharCode(252)+"ent'",
	BN_BL_PREVIOUS: "Abaix esquerra 'anterior'",
	BN_SB_NEXT: "Lateral 'seguent'",
	BN_SB_PREVIOUS:  "Lateral 'anterior'",
	BN_MENU: "Men"+String.fromCharCode(250)+"",
	BN_JP_LEFT: "Joypad esquerre",
	BN_JP_RIGHT: "Joypad dreta",
	BN_JP_UP: "Joypad amunt",
	BN_JP_DOWN: "Joypad abaix",
	BN_JP_CENTER: "Joypad centre",
	BN_H_SIZE: "Mantenir zoom",
	BN_H_BOOKMARK: "Mantenir marca de lectura",
	BN_H_BL_NEXT: "Mantenir abaix esq. 'seg"+String.fromCharCode(252)+"ent'",
	BN_H_BL_PREVIOUS: "Mantenir abaix esq. 'anterior'",
	BN_H_MENU: "Mantenir men"+String.fromCharCode(250)+"",
	BN_H_SB_NEXT: "Mantenir lateral 'seg"+String.fromCharCode(252)+"ent'",
	BN_H_SB_PREVIOUS: "Mantenir lateral 'anterior'",
	BN_H_JP_CENTER: "Mantenir joypad centre",
	BN_H_1: "Mantenir 1",
	BN_H_2: "Mantenir 2",
	BN_H_3: "Mantenir 3",
	BN_H_4: "Mantenir 4",
	BN_H_5: "Mantenir 5",
	BN_H_6: "Mantenir 6",
	BN_H_7: "Mantenir 7",
	BN_H_8: "Mantenir 8",
	BN_H_9: "Mantenir 9",
	BN_H_0: "Mantenir 0",
	BN_VOLUME_DOWN: "Volum -",
	BN_H_VOLUME_DOWN: "Mantenir Volum -",
	BN_VOLUME_UP: "Volum +",
		
		// Actions
	ACTION_SHUTDOWN: "Apagar",
	ACTION_NEXT_PAGE: "P"+String.fromCharCode(224)+"gina Seg"+String.fromCharCode(252)+"ent",
	ACTION_PREVIOUS_PAGE: "Pagina Anterior",
	ACTION_NEXT_IN_HISTORY: "Proper en l'Historial",
	ACTION_PREVIOUS_IN_HISTORY: "Anterior en l'Historial",
	ACTION_NEXT_SONG: "Seg"+String.fromCharCode(252)+"ent can"+String.fromCharCode(231)+""+String.fromCharCode(243)+"",
	ACTION_PREVIOUS_SONG: "Anterior can"+String.fromCharCode(231)+""+String.fromCharCode(243)+"",
	},
	
	Screenshot: {
	TITLE: "Captura de Pantalles",
	ACTION_TITLE: "Captura de Pantalla",
	SAVING_TO: "Salvant a ",
	FAILED_TO_SAVE: "Captura fallida",
	OPT_SAVETO: "Salvar a ...",
	OPT_FEEDBACK: "Mostra progr"+String.fromCharCode(233)+"s de salvar",
	MEMORY_STICK: "Memory Stick",
	FEEDBACK_ON: "Activat",
	FEEDBACK_OFF: "Desactivat",
	SD_CARD: "Targeta SD",
	INTERNAL_MEMORY: "Mem"+String.fromCharCode(242)+"ria Interna"
	},
	
	BrowseFolders: {
	TITLE:  "Explorador de Carpetes",
	OPTION_SORTING_MODE: "Tipus d'Ordre",
	VALUE_BY_TITLE: "Per t"+String.fromCharCode(237)+"tol",
	VALUE_BY_AUTHOR_THEN_TITLE: "Per autor i despr"+String.fromCharCode(233)+"s t"+String.fromCharCode(237)+"tol",
	VALUE_BY_AUTHOR_SWAPPING: "Per autor amb intercanvi nom/cognom",
	VALUE_BY_FILENAME: "Per nom d'arxiu",
	OPTION_TITLE_SORTER: "Ordenar amb TitleSorter",
	ENABLED: "Activat",
	DISABLED: "Desactivat",
	OPTION_IM_ROOT: "Arrel de la Mem"+String.fromCharCode(242)+"ria Interna",
	OPTION_CARD_SCAN: "Escaneja targetes SD/MS",
	OPTION_MOUNT: "Usar muntatge amb SD/MS (experimental)",
	NODE_RESCAN_INTERNAL_MEMORY: "Escaneja Mem"+String.fromCharCode(242)+"ria Interna",
	NODE_COPY_TO_INTERNAL_MEMORY: "Copia a Mem"+String.fromCharCode(242)+"ria Interna",
	NODE_COPY_TO_INTERNAL_MEMORY_COMMENT: "Copia arxius a l'arrel de la mem"+String.fromCharCode(242)+"ria interna",
	NODE_COPY_AND_RESCAN: "Copia i Escaneja mem"+String.fromCharCode(242)+"ria interna",
	NODE_COPY_AND_RESCAN_COMMENT: "Copia arxius a l'arrel de la Mem"+String.fromCharCode(242)+"ria Interna i escaneja",
	ERROR_TARGET_EXISTS: "Error, l'arxiu dest"+String.fromCharCode(237)+" existeix",
	NODE_AUDIO_AND_PICTURES: ""+String.fromCharCode(192)+"udio - Imatges",
	NODE_BROWSE_FOLDERS: "Llibres per Carpetes",
	NODE_BROWSE_FOLDERS_COMMENT: "Explorar",
	NODE_INTERNAL_MEMORY: "Mem"+String.fromCharCode(242)+"ria Interna",
	NODE_MEMORY_STICK: "Memory Stick",
	NODE_MEMORY_STICK_MOUNT: "Memory Stick a trav"+String.fromCharCode(233)+"s de muntatge",
	NODE_SD_CARD: "Targeta SD",
	NODE_SD_CARD_MOUNT: "Targeta SD a trav"+String.fromCharCode(233)+"s de muntatge",
	NODE_GAMES_AND_UTILITIES: "Jocs - Aplicacions"
	},
	
	Clock: {
	OPTION_STYLE: "Estil Rellotge",
	VALUE_24H: "Format 24 hores",
	VALUE_12H: "Format 12 hores",
	OPTION_MODE: ""+String.fromCharCode(218)+"s del Rellotge",
	VALUE_ALWAYS_SHOWN: "Es mostra sempre",
	VALUE_SHOWN_ONLY_IN_MENU: "Nom"+String.fromCharCode(233)+"s en els men"+String.fromCharCode(250)+"s",
	VALUE_SHOWN_WHEN_READING: "Nom"+String.fromCharCode(233)+"s en la lectura",
	VALUE_OFF: "Desactivat",
	ACTION_TOGGLE_CLOCK: "Alternar rellotge",
	AM: "am",
	PM: "pm"
	},
	
	PageIndex: {
	TITLE: "Paginaci"+String.fromCharCode(243)+" Llibres i Men"+String.fromCharCode(250)+"s",
	INDEX_STYLE_BOOK: "Format Paginaci"+String.fromCharCode(243)+" Llibre",
	INDEX_MODE_BOOK: "Mostra Paginaci"+String.fromCharCode(243)+" Llibre",
	INDEX_MODE_MENU: "Mostra Paginaci"+String.fromCharCode(243)+" Men"+String.fromCharCode(250)+"s",
	INDEX_STYLE_MENU: "Format Paginaci"+String.fromCharCode(243)+" Men"+String.fromCharCode(250)+"s",
	OF: "de",
	ALWAYS_SHOWN: "Sempre",
	NEVER_SHOWN: "Mai",
	NOT_SHOWN_IF_SINGLE_PAGE: "Nom"+String.fromCharCode(233)+"s si hi ha mes d'una p"+String.fromCharCode(224)+"gina"
	},
	
	EpubUserStyle: {
		TITLE:"EPUB Estil d'Usuari",
		COMMENT:"Experimental, Nom"+String.fromCharCode(233)+"s s'aplica a llibres oberts despr"+String.fromCharCode(233)+"s",
		OPTION_EPUB_CSS_FILE:"Arxius .css de l'usuari",
		VALUE_DISABLED:"desactivat"
	}
};
