// Description: Sample localization file
// Author: kartu
//
// Language: English
//
return {
        // Standard stuff
        Sony: {
                // USB connected
                DO_NOT_DISCONNECT: "No desconectar",
                USB_CONNECTED: "USB conectado",
                DEVICE_LOCKED: "Dispositivo bloqueado",

                // About, translate either all or none
                ABOUT_PRSP: "PRS+ Script: @@@script@@@\n" +
                        "PRS+ Firmware: @@@firmware@@@\n" +
                        "Author: Mikheil Sukhiashvili aka kartu (kartu3@gmail.com) using work of: " + 
                        "igorsk, boroda, obelix, pepak, llasram and others.\n" +
                        " GNU Lesser General Public License.",
                ABOUT_1: "Copyright 2006-2008 Sony Corporation",
                ABOUT_2: "Adobe, the Adobe logo, Reader and PDF are either registered trademarks or" + 
                        " trademarks of Adobe Systems Incorporated in the United States and/or other countries.",
                ABOUT_3: "MPEG Layer-3 audio coding technology and patents licensed by Fraunhofer IIS and Thomson." + 
                        " MPEG-4 AAC audio coding technology licensed by Fraunhofer IIS (www.iis.fraunhofer.de/amm/).",
                ABOUT_4: "Application software designed and implemented by Kinoma (www.kinoma.com). Portions Copyright 2006,2007 Kinoma, Inc.",
                ABOUT_5: "Bitstream is a registered trademark, and Dutch, Font Fusion, and Swiss are trademarks, of Bitstream, Inc.",
                ABOUT_6: "Portions of this software are Copyright 2005 The FreeType Project (www.freetype.org). All rights reserved.",
                ABOUT_7: "This software is based in part on the work of the Independent JPEG Group.",
                AUTHORIZED_SONY: "Authorized for the eBook Store.",
                NOT_AUTHORIZED_SONY: "Not authorized for the eBook Store.",
                AUTHORIZED_ADOBE: "This device is authorized for Adobe DRM protected content.",
                NOT_AUTHORIZED_ADOBE: "This device is not authorized for Adobe DRM protected content.",
                SONY_FW_VERSION: "Version",
                DEVICE_ID: "Device",
                
                // Mime & card names
                RICH_TEXT_FORMAT: "RTF",
                ADOBE_PDF: "Adobe PDF",
                EPUB_DOCUMENT: "EPUB documento",
                BBEB_BOOK: "BBeB libro",
                PLAIN_TEXT: "Texto sencillo",
                INTERNAL_MEMORY: "Memora interna",
                MEMORY_STICK: "Memory Stick",
                SD_CARD: "Memoria SD",
                
                // Main.xml & kbook.so stuff
                INVALID_FORMAT: "Formato no v"+String.fromCharCode(225)+"lido!",
                FORMATTING: "Formateando...",
                LOADING: "Cargando...",
                LOW_BATTERY: "Bater"+String.fromCharCode(237)+"a baja!",
                HR_WARNING: "Quiere BORRAR todos los contenidos, restaurar a los ajuste de f"+String.fromCharCode(225)+"brica, y borrar autorizaci"+String.fromCharCode(243)+"n DRM?\n\nS"+String.fromCharCode(237)+" - Presionar 5\nNo - Presionar MENU",
                DEVICE_SHUTDOWN: "Apagando dispositivo",
                PRESS_MARK_TO_SHUTDOWN: "Presionar MARCADOR para apagar",
                THIS_DEVICE: "Este dispositivo.",
                PRESS_MARK_TO_DELETE: "Presionar MARCADOR para",
                THIS_BOOK: "Borrar libro.",
                FORMAT_INTERNAL_MEMORY: "Formatear memoria interna",
                PRESS_MARK_TO_FORMAT: "Presionar MARCADOR para formatear",
                MSG_INTERNAL_MEMORY: "Memoria interna.",
                RESTORE_DEFAULTS: "Restaurar por defecto",
                PRESS_MARK_TO_RESTORE: "Presionar MARCADOR para restaurar",
                DEFAULT_SETTINGS: "Ajustes por defecto.",
                UPPER_PAGE: "P"+String.fromCharCode(193)+"GINA",
                ONE_OF_ONE: "1 DE 1",
                NO_BATTERY: "Sin bater"+String.fromCharCode(237)+"a!",
                FORMATTING_INTERNAL_MEMORY: "Formateando memoria interna...",
                SHUTTING_DOWN: "Apagando...",
                
                // Root menu
                CONTINUE: "Continuar leyendo",
                BOOKS_BY_TITLE: "Libros por T"+String.fromCharCode(237)+"tulo",
                BOOKS_BY_AUTHOR: "Libros por Autor",
                BOOKS_BY_DATE: "Libros por Fecha",
                COLLECTIONS: "Colecciones",
                ALL_BOOKMARKS: "Todos los Marcadores",
                NOW_PLAYING: "Reproduciendo ahora",
                MUSIC: "M"+String.fromCharCode(250)+"sica",
                PICTURES: "Im"+String.fromCharCode(225)+"genes",
                SETTINGS: "Ajustes",

                // In Settings
                // orientation
                ORIENTATION: "Orientaci"+String.fromCharCode(243)+"n",
                HORIZONTAL: "Horizontal",
                VERTICAL: "Vertical",
                // set date
                SET_DATE: "Ajustar Fecha",
                YEAR: "Ao",
                MONTH: "Mes",
                DATE: "Fecha", // D"+String.fromCharCode(237)+"a
                HOUR: "Hora",
                MINUTE: "Minuto",
                // slideshow
                SLIDESHOW: "Modo diapositivas",
                SS_ON: "Activado",
                SS_OFF: "Desactivado",
                SS_TURN: "Ajustar",
                SS_DURATION: "Duraci"+String.fromCharCode(243)+"n",
                SECONDS: "Segundos",
                // auto standby (aka sleep mode)
                AUTOSTANDBY: "Modo en Reposo",
                AS_ON: "Activado",
                AS_OFF: "Desactivado",
                AS_TURN: "Ajustar",
                // about
                ABOUT: "Acerca de",
                // reset to factory settings
                RESET_TO_FACTORY: "Resetar a ajustes de f"+String.fromCharCode(225)+"brica",
                
                // In Advanced Settings
                ADVANCED_SETTINGS: "Ajustes avanzados",
                // screen lock (aka device lock)
                SCREEN_LOCK: "Bloquedo de dispositivo",
                SL_OFF: "Desactivado",
                SL_ON: "Activado",
                SL_CODE: "Clave",
                SL_TURN: "Ajustar",
                // format device
                FORMAT_DEVICE: "Formatear dispositivo",
                
                // In Book menu
                BEGIN: "Inicio",
                END: "Final",
                BOOKMARKS: "Marcadores",
                CONTENTS: "Contenidos",
                HISTORY: "Historial",
                INFO: "Informaci"+String.fromCharCode(243)+"n",
                UTILITIES: "Aplicaciones",
                
                // In Book Utilities
                REMOVE_ALL_BOOKMARKS: "Quitar todos los Marcadores",
                CLEAR_HISTORY: "Borrar Historial",
                DELETE_BOOK: "Eliminar Libro",
                
                // In Books by Date
                TODAY: "Hoy",
                EARLIER_THIS_WEEK: "Primeros de Esta Semana",
                LAST_WEEK: "La Semana Pasada",
                EARLIER_THIS_MONTH: "Primeros de Este Mes",
                LAST_MONTH: "El Mes Pasado",
                EARLIER_THIS_QUARTER: "Primeros de Este Trimestre",
                LAST_QUARTER: ""+String.fromCharCode(218)+"ltimo Trimestre",
                EARLIER_THIS_YEAR: "Primeros de Este Ao",
                LAST_YEAR: "El Ao Pasado",
                OLDER: "M"+String.fromCharCode(225)+"s antiguo",         
                
                PAGE: "P"+String.fromCharCode(225)+"gina",
                PART: "Parte",
                OF: "de",
                NO_BOOK: "No hay libro",
                NO_SONG: "No hay canci"+String.fromCharCode(243)+"n",

                // Info title strings, comma separated, no spaces after comma
                INFO_TITLES: "Cover,Title,Author,Publisher,Category,eBook ID,Kind,Date,Size,Location,File,Digital Rights,Expires",
                
                // Titles and criterions for "Books by Title" and "Books by Folder"
                // title is displayed, "criterion" is used for sorting.
                //
                // NOTE: if localization doesn't need custom Books by sorting, just remove CUSTOM_SORT, TITLE_*, CRITERION_* items
                CUSTOM_SORT: true, 
                TITLE_1: "0-9",
                CRITERION_1: "0123456789",
                TITLE_2: "A B C",
                CRITERION_2: "ABCabc",
                TITLE_3: "D E F",
                CRITERION_3: "DEFdef",
                TITLE_4: "G H I",
                CRITERION_4: "GHIghi",
                TITLE_5: "J K L",
                CRITERION_5: "JKLjkl",
                TITLE_6: "M N O",
                CRITERION_6: "MNOmno",
                TITLE_7: "P Q R S",
                CRITERION_7: "PQRSpqrs",
                TITLE_8: "T U V W",
                CRITERION_8: "TUVWtuvw",
                TITLE_9: "X Y Z",
                CRITERION_9: "WXYZwxyz",
                TITLE_0: "Other",
                CRITERION_0: "",

                // Utility function, no need to localize
                toDoubleDigit: function (num) {
                        if (num < 10) {
                                return "0" + num;
                        } else {
                                return num;
                        }
                },
                FUNC_GET_DATE_TIME: function (date) {
                        return this.FUNC_GET_DATE(date) + " " + this.FUNC_GET_TIME(date);
                },
                FUNC_GET_DATE: function (date) {
                        var day, month, year;
                        day = this.toDoubleDigit(date.getDate());
                        month = this.toDoubleDigit(date.getMonth() + 1); 
                        year = date.getFullYear();
                        return month + "/" + day + "/" + year;
                },
                FUNC_GET_TIME: function (date) {
                        var hour, minute;
                        hour = this.toDoubleDigit(date.getHours());
                        minute = this.toDoubleDigit(date.getMinutes());
                        return hour + ":" + minute;
                },
                FUNC_X_PAGES: function (n) {
                        return this.FUNC_X_SOMETHING(n, "pages", "1 page", "No page");
                },
                FUNC_X_ITEMS: function (n) {
                        return this.FUNC_X_SOMETHING(n, "items", "1 item", "No item");
                },
                FUNC_X_SETTINGS: function (n) {
                        return this.FUNC_X_SOMETHING(n, "settings", "1 setting", "No setting");
                },
                FUNC_X_PICTURES: function (n) {
                        return this.FUNC_X_SOMETHING(n, "pictures", "1 picture", "No picture");
                },
                FUNC_X_SONGS: function (n) {
                        return this.FUNC_X_SOMETHING(n, "songs", "1 song", "No song");
                },
                FUNC_X_BOOKMARKS: function (n) {
                        return this.FUNC_X_SOMETHING(n, "bookmarks", "1 bookmark", "No bookmark");
                },
                FUNC_X_COLLECTIONS: function (n) {
                        return this.FUNC_X_SOMETHING(n, "collections", "1 collection", "No collection");
                },
                FUNC_X_BOOKS: function (n) {
                        return this.FUNC_X_SOMETHING(n, "books", "1 book", "No book");
                },
                FUNC_X_SOMETHING: function (n, many, one, zero) {
                        if (n > 1) {
                                return n + " " + many;
                        } else if (n == 1) {
                                return one;
                        } else {
                                return zero;
                        }
                }
        },
        
        // PRS+ stuff
        MenuCaptions: {
                TITLE: "Men"+String.fromCharCode(250)+" Estilo T"+String.fromCharCode(237)+"tulos",
                TITLE_COMMENT: "Permite Cambiar Estilo T"+String.fromCharCode(237)+"tulos",
                OPTION_STYLE: "Estilo T"+String.fromCharCode(237)+"tulos",
                VALUE_SONY_DEFAULT: "Original Sony",
                VALUE_ALWAYS_SMALL: "T"+String.fromCharCode(237)+"tulos pequeos",
                VALUE_ALWAYS_BIG: "T"+String.fromCharCode(237)+"tulos grandes"
        },
        
        TextEncoding: {
                TITLE: "Codificaci"+String.fromCharCode(243)+"n de texto",
                COMMENT: "Afecta a los libros en formato TXT,RTF, requiere reiniciar",
                OPTION_TITLE: "Codificaci"+String.fromCharCode(243)+"n",
                DESCRIPTION: "Permite elegir la codificaci"+String.fromCharCode(243)+"n del texto",
                LATIN: "Car"+String.fromCharCode(225)+"cteres latinos",
                RUSSIAN:  "Car"+String.fromCharCode(225)+"cteres rusos (win1251)"
        },
        
        KeyBindings: {
                TITLE: "Configuraci"+String.fromCharCode(243)+"n Teclas",
                DESCRIPTION: "Allows to bind actions to keys",
                
                DEFAULT_VALUE: "Por defecto",
                
                // Contexts
                GLOBAL:  "En todo momento",
                IN_MENU: "En los men"+String.fromCharCode(250)+"s",
                IN_BOOK:  "Durante la lectura",
                
                // Button groups
                NUM_BUTTONS: "Teclas num"+String.fromCharCode(233)+"ricas",
                JP_BUTTONS: "Teclas del Joypad",
                OTHER_BUTTONS: "Otras teclas",
                VOLUME_BUTTONS: "Teclas de volumen",
                
                // Buttons
                BN_SIZE: "Zoom",
                BN_BOOKMARK: "Marcador",
                BN_BL_NEXT: "Abajo izquierda 'siguiente'",
                BN_BL_PREVIOUS: "Abajo izquierda 'anterior'",
                BN_SB_NEXT: "Lateral 'anterior'",
                BN_SB_PREVIOUS:  "Lateral 'anterior'",
                BN_MENU: "Men"+String.fromCharCode(250)+",
                BN_JP_LEFT: "Joypad izquierda",
                BN_JP_RIGHT: "Joypad derecha",
                BN_JP_UP: "Joypad arriba",
                BN_JP_DOWN: "Joypad abajo",
                BN_JP_CENTER: "Joypad centro",
                BN_H_SIZE: "Mantener zoom",
                BN_H_BOOKMARK: "Mantener marcador",
                BN_H_BL_NEXT: "Holding bottom left 'next page'",
                BN_H_BL_PREVIOUS: "Mantener abajo izq. 'anterior'",
                BN_H_MENU: "Mantener men"+String.fromCharCode(250)+"",
                BN_H_SB_NEXT: "Mantener lateral 'siguiente'",
                BN_H_SB_PREVIOUS: "Mantener lateral 'anterior'",
                BN_H_JP_CENTER: "Mantener joypad centro",
                BN_H_1: "Mantener 1",
                BN_H_2: "Mantener 2",
                BN_H_3: "Mantener 3",
                BN_H_4: "Mantener 4",
                BN_H_5: "Mantener 5",
                BN_H_6: "Mantener 6",
                BN_H_7: "Mantener 7",
                BN_H_8: "Mantener 8",
                BN_H_9: "Mantener 9",
                BN_H_0: "Mantener 0",
                BN_VOLUME_DOWN: "Volumen -",
                BN_H_VOLUME_DOWN: "Mantener Volumen -",
                BN_VOLUME_UP: "Volumen +",
                BN_H_VOLUME_UP: "Mantener Volumen +",
                
                // Actions
                ACTION_SHUTDOWN: "Apagar",
                ACTION_NEXT_PAGE: "P"+String.fromCharCode(225)+"gina siguiente",
                ACTION_PREVIOUS_PAGE: "P"+String.fromCharCode(225)+"gina anterior",
                ACTION_NEXT_IN_HISTORY: "Siguiente en el Historial",
                ACTION_PREVIOUS_IN_HISTORY: "Anterior en el Historial",
                ACTION_PREVIOUS_SONG: "Canci"+String.fromCharCode(243)+"n anterior",
                ACTION_NEXT_SONG: "Canci"+String.fromCharCode(243)+"n siguiente"
        },
        
        Screenshot: {
                TITLE: "Capturar Pantalla",
                ACTION_TITLE: "Hacer una captura de pantalla",
                SAVING_TO: "Salvando en ",
                FAILED_TO_SAVE: "Fallo de grabaci"+String.fromCharCode(243)+"n",
                OPT_SAVETO: "Salvar en...",
                OPT_FEEDBACK: "Mostrar progreso salvado",
                MEMORY_STICK: "Memory Stick",
                FEEDBACK_ON: "Activado",
                FEEDBACK_OFF: "Desactivado",
                SD_CARD: "Tarjeta SD",
                INTERNAL_MEMORY: "Memoria interna"
        },
        
        BrowseFolders: {
                TITLE:  "Explorador de Carpetas",
                OPTION_SORTING_MODE: "Tipo de Orden",
                VALUE_BY_TITLE: "BPor t"+String.fromCharCode(237)+"tulo",
                VALUE_BY_AUTHOR_THEN_TITLE: "Por autor y luego t"+String.fromCharCode(237)+"tulo",
                VALUE_BY_AUTHOR_SWAPPING: "Por autor intercambiando nombre/apellido",
                VALUE_BY_FILENAME: "Por nombre de archivo",
                OPTION_TITLE_SORTER: "Usar clasificador t"+String.fromCharCode(237)+"tulos",
                ENABLED: "Activado",
                DISABLED: "Desactivado",
                OPTION_IM_ROOT: "Ra"+String.fromCharCode(237)+"z de la Memoria Interna",
                OPTION_CARD_SCAN: "Escaneo de tarjetas SD/MS",
                OPTION_MOUNT: "Montar SD/MS(experimental)",
                NODE_RESCAN_INTERNAL_MEMORY: "Reescanear memoria interna",
                NODE_COPY_TO_INTERNAL_MEMORY: "Copiar a memoria interna",
                NODE_COPY_TO_INTERNAL_MEMORY_COMMENT: "Copies file to the internal memory root",
                NODE_COPY_AND_RESCAN: "Copiar y escanear memoria interna",
                NODE_COPY_AND_RESCAN_COMMENT: "Copias archivo a ra"+String.fromCharCode(237)+"z memoria interna y escanear libros",
                ERROR_TARGET_EXISTS: "Error, etiqueta archivo exite",
                NODE_AUDIO_AND_PICTURES: "Audio - Im"+String.fromCharCode(225)+"genes",
                NODE_BROWSE_FOLDERS: "Libros por carpetas",
                NODE_BROWSE_FOLDERS_COMMENT: "Explorar",
                NODE_INTERNAL_MEMORY: "emoria interna",
                NODE_MEMORY_STICK: "Memory Stick",
                NODE_MEMORY_STICK_MOUNT: "Memory Stick montada",
                NODE_SD_CARD: "Tarjeta SD",
                NODE_SD_CARD_MOUNT: "Tarjeta SD montada",
                NODE_GAMES_AND_UTILITIES: "Juegos - Utilidades"
        },
        
        Clock: {
                OPTION_STYLE: "Estilo Reloj",
                VALUE_24H: "Formato 24 horas",
                VALUE_12H: "Formato 12 horas",
                OPTION_MODE: "Uso del Reloj"",
                VALUE_ALWAYS_SHOWN: "Se muestra siempre",
                VALUE_SHOWN_ONLY_IN_MENU: "Solo en el men"+String.fromCharCode(250)+"",
                VALUE_SHOWN_WHEN_READING: "Solo en la lectura",
                VALUE_OFF: "Desactivado",
                ACTION_TOGGLE_CLOCK: "Alternar Reloj",
                AM: "am",
                PM: "pm"
        },
        
        PageIndex: {
                TITLE: "Indice Men"+String.fromCharCode(250)+"s-P"+String.fromCharCode(225)+"ginas,
                INDEX_STYLE_BOOK: "Estilo "+String.fromCharCode(237)+"ndice libros",
                INDEX_MODE_BOOK: "Modo "+String.fromCharCode(237)+"ndice libros",
                INDEX_MODE_MENU: "Modo "+String.fromCharCode(237)+"ndice men"+String.fromCharCode(250)+"s",
                INDEX_STYLE_MENU: "Estilo "+String.fromCharCode(237)+"ndice men"+String.fromCharCode(250)+"s",
                OF: "de",
                ALWAYS_SHOWN: "Mostrar siempre",
                NEVER_SHOWN: "No mostrar",
                NOT_SHOWN_IF_SINGLE_PAGE: "Solo si tiene m"+String.fromCharCode(225)+"s de una p"+String.fromCharCode(225)+"gina"
        },
        
        EpubUserStyle: {
                TITLE: "Estilo usuario EPUB",
                COMMENT: "Experimental, afecta a los libros abiertos despu"+String.fromCharCode(233)+"s",
                OPTION_EPUB_CSS_FILE: "Archivo usario EPUB css",
                VALUE_DISABLED: "Desactivado"
        }
};
