#!/usr/bin/env  python
__license__   = 'GPL v3'
__copyright__ = '2010, Jason Cassidy'
__docformat__ = 'restructuredtext en'

'''
Fetch metadata using Library Thing Web service API see http://www.librarything.com
Mostly a copy from the Amazon plugin
'''
import sys, re
from datetime import datetime
from urllib import urlencode
from urllib import quote

from lxml import etree
from dateutil import parser
from calibre import browser
from calibre.ebooks.metadata import MetaInformation, string_to_authors
from calibre.ebooks.metadata.fetch import MetadataSource
import re

LIBWS_NS = 'http://www.librarything.com/'

def LIBWS(tag):
    return '{%s}%s'%(LIBWS_NS, tag)

def check_for_errors(root):
    err = root.attrib["stat"]
    if err is not None and err == 'fail':
        try:
            pub = root.find('./err').attrib["code"]
            if pub == '105':
                return False
        except:
            pass
        raise Exception('Failed to get metadata with error: '\
                + etree.tostring(root, method='text', pretty_print=True,
                    encoding=unicode))
    return True

def get_libraryThingISBNS(title, authors, publisher, isbn):
    if isbn:
        return [isbn]
    elif title:
    	base_url='http://www.librarything.com/api/thingTitle/'
        url=base_url+quote(title)
        try:
	    br = browser()
	    br.set_handle_redirect(False)
	    response=br.open(url)
	    response_xml = response.read()
            root = etree.fromstring(response_xml)
            returnedISBNS=[x.text for x in root.findall('.//isbn')]
            if len(returnedISBNS) > 3:
                return [returnedISBNS[0],returnedISBNS[1],returnedISBNS[2]]
            return returnedISBNS
        except:
            pass
    return None

    
    
def get_social_metadata(title, authors, publisher, isbn, myKey):
    mi = MetaInformation(title, authors)
    base_url='http://www.librarything.com/services/rest/1.0/?'
    if isbn:
        url=base_url+urlencode({
            'method':'librarything.ck.getwork',
            'isbn':isbn,
            'apikey':myKey,
            })
    elif title:
        url=base_url+urlencode({
            'method':'librarything.ck.getwork',
            'name':title,
            'apikey':myKey,
            })
    if url:	
    	br = browser()
        response_xml = br.open(url).read()
        try:
            root = etree.fromstring(response_xml)
	except:
            raise Exception('Failed to get metadata received invalid response, check developer key')
        if not check_for_errors(root):
            return None
        try:
            ftitle=root.find('.//'+LIBWS('item'))
            mi.libthingid = ftitle.get("id")
        except Exception, e:
            pass
        try:
	    ftitle=root.find('.//'+LIBWS('field')+"[@name='canonicaltitle']")
            mi.title = ftitle.findtext('.//'+LIBWS('fact'))
        except:
            pass

        theAuthors = [x.text for x in root.findall('.//'+LIBWS('author'))]
        if authors:
            mi.authors = []
            for x in theAuthors:
                mi.authors.extend(string_to_authors(x))
        try:
            pub = root.find('.//'+LIBWS('field')+"[@name='originalpublicationdate']")
            d = pub.findtext('.//'+LIBWS('fact')).split('(')[0]
            if d:
                default = datetime.utcnow()
                default = datetime(default.year, default.month, 15)
                d = parser.parse(d, default=default)
                mi.pubdate = d
                mi.publisher = 'Unknown'
        except:
            pass
	try:
            series=root.find('.//'+LIBWS('field')+"[@name='series']").findtext('.//'+LIBWS('fact')).split('(')
            mi.series = series[0].strip()
            mi.series_index =float(re.sub('[^0-9]','',series[1].split(')')[0]))
        except:
            pass
        try:
	    comments = root.find('.//'+LIBWS('field')+"[@name='description']").find('.//'+LIBWS('fact'))
	    if comments is not None:
		mi.comments = etree.tostring(comments, method='text', encoding=unicode)
		mi.comments = re.sub('<\!\[CDATA\[', '\n\n', mi.comments)
		mi.comments = re.sub('\]\]', '', mi.comments)
		mi.comments = re.sub('<br>', '\n\n', mi.comments)
		mi.comments = mi.comments.strip()
        except:
            pass
        mi.isbn=isbn
        return mi


class LibraryThing(MetadataSource):

    name = 'LibraryThing'
    description = _('Downloads metadata from LibraryThing.com')
    author = 'Jason Cassidy'
    version = '101'
    def fetch(self):
        if not self.site_customization:
            return	
        if not self.isbn and not self.title:
            return
        try:
            theisbns=get_libraryThingISBNS(self.title, self.author, self.publisher, self.isbn)
            if theisbns is None:
                return
            theResults=[]
            if len(theisbns)>0:
                for myisbn in theisbns:
                    theResult=get_social_metadata(self.title, self.author, self.publisher, myisbn,self.site_customization)
                    if theResult:
                    	if len(theResults)>0:
                            for myresult in theResults:
                                if myresult.libthingid != theResult.libthingid:
                                    theResults.append(theResult)
                        else:
                            theResults.append(theResult)
                self.results = theResults
        except Exception, e:
            self.exception = e
            import traceback            
            self.tb = traceback.format_exc()

    @property
    def string_customization_help(self):
        ans = _('To use librarything.com you must sign up for a %sdeveloper key%s '
                'and enter your developer key below.')
        return '<p>'+ans%('<a href="http://www.librarything.com/services/keys.php">', '</a>')


def main(args=sys.argv):
    print get_social_metadata(None, None, None, '9781416551720', 'some key')
    return 0

if __name__ == '__main__':
    sys.exit(main())
