package eu32k.manga2cbz;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

import javax.swing.JFrame;
import javax.swing.JTextArea;

/**
 * http://tanksoftware.com/juk/developer/src/com/
 * tanksoftware/util/RedirectedFrame.java A Java Swing class that captures
 * output to the command line (eg, System.out.println) RedirectedFrame
 * <p>
 * This class was downloaded from: Java CodeGuru (http://codeguru.earthweb.com/java/articles/382.shtml) <br>
 */

public class RedirectedFrame extends JFrame {
   private static final long serialVersionUID = 7221380000741141152L;
   final String fileName;

   final JTextArea aTextArea = new JTextArea();
   private final PrintStream aPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));

   public RedirectedFrame(boolean catchErrors, boolean logFile, String fileName, int width, int height, int closeOperation) {

      setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icon.png")));

      this.fileName = fileName;

      Container c = getContentPane();

      setTitle("manga2cbz for iRex DR800S(G) " + MangaConverter.version);
      setSize(width, height);
      c.setLayout(new BorderLayout());

      this.aTextArea.setOpaque(false);
      this.aTextArea.setLineWrap(true);
      this.aTextArea.setWrapStyleWord(true);
      this.aTextArea.setEditable(false);
      this.aTextArea.setFont(new Font("Comic Sans MS", Font.PLAIN, 10));

      MyJScrollPane scrollPane = new MyJScrollPane(this.aTextArea);

      c.add("Center", scrollPane);
      displayLog();

      System.setOut(this.aPrintStream); // catches System.out messages
      if (catchErrors) {
         System.setErr(this.aPrintStream); // catches error messages
      }

      // set the default closing operation to the one given
      setDefaultCloseOperation(closeOperation);
   }

   class FilteredStream extends FilterOutputStream {
      public FilteredStream(OutputStream aStream) {
         super(aStream);
      }

      @Override
      public void write(byte b[]) throws IOException {
         String aString = new String(b);
         RedirectedFrame.this.aTextArea.append(aString);
         RedirectedFrame.this.aTextArea.setCaretPosition(RedirectedFrame.this.aTextArea.getText().length() - 1);

      }

      @Override
      public void write(byte b[], int off, int len) throws IOException {
         String aString = new String(b, off, len);
         RedirectedFrame.this.aTextArea.append(aString);
         RedirectedFrame.this.aTextArea.setCaretPosition(RedirectedFrame.this.aTextArea.getText().length() - 1);
      }
   }

   private void displayLog() {
      Dimension dim = getToolkit().getScreenSize();
      Rectangle abounds = getBounds();
      setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
      setVisible(true);
      requestFocus();
   }

}