package eu32k.manga2cbz;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

import eu32k.manga2cbz.generated.Manga2CbzConfig;
import eu32k.manga2cbz.generated.ObjectFactory;
import eu32k.manga2cbz.generated.RotationMode;
import eu32k.manga2cbz.generated.SplitMode;
import eu32k.manga2cbz.generated.Type;

public class Config {

   public static Manga2CbzConfig getConfig() {
      File configFile = new File("config.xml");

      if (configFile.exists()) {
         try {
            Manga2CbzConfig config = readFromXML(configFile);
            return config;
         } catch (JAXBException e) {
            System.out.println("Error: Invalid config file.");
         }
      }

      System.out.println("Creating default config...");

      Manga2CbzConfig config = new ObjectFactory().createManga2CbzConfig();

      config.setMaxWidth(768);
      config.setMaxHeight(981);
      config.setCropThreshold(200);
      config.setSplitLandscape(SplitMode.OFF);
      config.setRotateLandscape(RotationMode.CW);
      config.setThreads(0);
      config.setImageType(Type.PNG);
      config.setGrayLevels(16);

      try {
         writeToXML(config, configFile);
         FileOutputStream f = new FileOutputStream(configFile, true);
         DataOutputStream out = new DataOutputStream(f);
         out
               .writeBytes("<!--\ncropThreshold:   1 - 255 (255 means completely white)\n\nthreads:         1 - 16 (0 = automatic)\n\nsplitLandscape:  Works only if picture width is at least 2x screen width.\n                 LEFT = reading from left to right, RIGHT = reading from right to\n                 left, OFF = disabled\n                 \nrotateLandscape: Works only if picture width is bigger than picture height.\n                 CW = clockwise, CCW = counterclockwise, OFF = disabled\ntype:            JPG or PNG\n\ngrayLevels:      4, 8, 16, 32, 64, 128 or 256 (smaller than 256 only works with\n                 the gif4j library)\n\nWaring: Entering wrong values causes the whole config file to be reset to default.\n-->");
         out.flush();
         out.close();
      } catch (Exception e) {
         System.out.println("Error: Cannot write config file.");
      }

      return config;
   }

   public static void writeToXML(Manga2CbzConfig config, File file) throws JAXBException {
      JAXBContext context = JAXBContext.newInstance(Manga2CbzConfig.class);
      Marshaller m = context.createMarshaller();
      m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
      m.marshal(config, file);
   }

   public static Manga2CbzConfig readFromXML(File file) throws JAXBException {
      JAXBContext context = JAXBContext.newInstance(Manga2CbzConfig.class);

      Unmarshaller unmarshaller = context.createUnmarshaller();

      SchemaFactory sf = SchemaFactory.newInstance(javax.xml.XMLConstants.W3C_XML_SCHEMA_NS_URI);
      try {
         Schema schema = sf.newSchema(Config.class.getResource("/config.xsd"));
         unmarshaller.setSchema(schema);
      } catch (Exception e) {
         throw new JAXBException("schema error");
      }

      return (Manga2CbzConfig) unmarshaller.unmarshal(file);
   }
}
