package eu32k.manga2cbz;

import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class UserInput {

   private static JFileChooser getChooser(String title) {
      JFileChooser chooser = new JFileChooser();
      chooser.setCurrentDirectory(new java.io.File("."));
      chooser.setDialogTitle(title);
      chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
      chooser.setAcceptAllFileFilterUsed(false);
      chooser.setFileFilter(new FileFilter() {

         @Override
         public String getDescription() {
            return "directory, zip, cbz, rar, cbr";
         }

         @Override
         public boolean accept(File f) {
            if (f.isDirectory()) {
               return true;
            }
            if (f.getName().endsWith(".zip")) {
               return true;
            }
            if (f.getName().endsWith(".cbz")) {
               return true;
            }
            if (f.getName().endsWith(".cbr")) {
               return true;
            }
            if (f.getName().endsWith(".rar")) {
               return true;
            }
            return false;
         }
      });
      return chooser;
   }

   public static File getSource() {
      System.out.println("Select a source directory or file (zip / cbz / rar / cbr) ...");
      JFileChooser chooser = getChooser("Select a source directory or file (zip / cbz / rar / cbr)");

      if (chooser.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
         return chooser.getSelectedFile();
      }

      // System.exit(0);
      return null;
   }

   public static File getDestination() {
      System.out.println("Select a destination directory.");
      JFileChooser chooser = getChooser("Select a destination directory.");
      chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
      chooser.setFileFilter(new FileFilter() {

         @Override
         public String getDescription() {
            return "directory";
         }

         @Override
         public boolean accept(File f) {
            if (f.isDirectory()) {
               return true;
            }
            return false;
         }
      });
      if (chooser.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
         return chooser.getSelectedFile();

      }
      // System.exit(0);
      return null;
   }

}
