package eu32k.manga2cbz;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

import javax.imageio.ImageIO;

public class MangaImage {

   public BufferedImage img;

   public static boolean checked = false;
   public static Method quantize = null;

   public MangaImage(File source, File target, String type, int width, int height, int cropThreshold, boolean rotateCW) throws IOException {

      if (!checked) {
         File f = new File("gif4j_pro_trial_2.3.jar");
         if (f.exists()) {
            try {
               URLClassLoader child = new URLClassLoader(new URL[] { f.toURI().toURL() }, this.getClass().getClassLoader());
               Class<?> classToLoad = Class.forName("com.gif4j.quantizer.Quantizer", true, child);
               quantize = classToLoad.getMethod("quantize", int.class, BufferedImage.class, int.class);
               System.out.println("'gif4j' found and ready.");
            } catch (Exception e) {
               // NOP
            }
         }
         checked = true;
      }

      read(source);

      crop(cropThreshold);

      rotateIfLandscape(rotateCW);

      autoResize(width, height);

      if (quantize != null) {
         try {
            this.img = (BufferedImage) quantize.invoke(null, 8, this.img, 4);
         } catch (Exception e) {
            // NOP
         }
      }
      // this.img = com.gif4j.quantizer.Quantizer.quantize(8, this.img, 4);

      save(target, type);
   }

   private void read(File source) throws IOException {
      this.img = ImageIO.read(source);
   }

   private void save(File target, String type) throws IOException {
      ImageIO.write(this.img, type, target);
   }

   private void crop(int threshold) {
      int top = findTop(threshold);
      int bottom = findBottom(threshold);
      int left = findLeft(threshold);
      int right = findRight(threshold);

      if (left < right && top < bottom) {
         this.img = this.img.getSubimage(left, top, right - left, bottom - top);
      }
   }

   private int findTop(int threshold) {
      for (int i = 0; i < this.img.getHeight(); i++) {
         for (int j = 0; j < this.img.getWidth(); j++) {
            int color = this.img.getRGB(j, i);
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            if (r < threshold || g < threshold || b < threshold) {
               return i;
            }
         }
      }
      return 0;
   }

   private int findBottom(int threshold) {
      for (int i = this.img.getHeight() - 1; i >= 0; i--) {
         for (int j = 0; j < this.img.getWidth(); j++) {
            int color = this.img.getRGB(j, i);
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            if (r < threshold || g < threshold || b < threshold) {
               return i;
            }
         }
      }
      return 0;
   }

   private int findLeft(int threshold) {
      for (int i = 0; i < this.img.getWidth(); i++) {
         for (int j = 0; j < this.img.getHeight(); j++) {
            int color = this.img.getRGB(i, j);
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            if (r < threshold || g < threshold || b < threshold) {
               return i;
            }
         }
      }
      return 0;
   }

   private int findRight(int threshold) {
      for (int i = this.img.getWidth() - 1; i >= 0; i--) {
         for (int j = 0; j < this.img.getHeight(); j++) {
            int color = this.img.getRGB(i, j);
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            if (r < threshold || g < threshold || b < threshold) {
               return i;
            }
         }
      }
      return 0;
   }

   private void rotateIfLandscape(boolean cw) {
      if (this.img.getWidth() > this.img.getHeight()) {
         rotate90(cw);
      }
   }

   private void rotate90(boolean rotateCW) {
      int width = this.img.getWidth();
      int height = this.img.getHeight();
      BufferedImage rot = new BufferedImage(height, width, this.img.getType());
      if (rotateCW) {
         for (int i = 0; i < width; i++) {
            for (int j = 0; j < height; j++) {
               rot.setRGB(height - 1 - j, i, this.img.getRGB(i, j));
            }
         }
      } else {
         for (int i = 0; i < width; i++) {
            for (int j = 0; j < height; j++) {
               rot.setRGB(j, width - 1 - i, this.img.getRGB(i, j));
            }
         }
      }
      this.img = rot;
   }

   private void autoResize(int width, int height) {
      int newWidth = this.img.getWidth();
      int newHeight = this.img.getHeight();

      if (this.img.getWidth() > width || this.img.getHeight() > height) {
         // resize:
         newWidth = width;
         newHeight = height;
         double thumbRatio = (double) newWidth / (double) newHeight;
         double imageRatio = (double) this.img.getWidth() / (double) this.img.getHeight();

         if (thumbRatio < imageRatio) {
            newHeight = (int) (newWidth / imageRatio);
         } else {
            newWidth = (int) (newHeight * imageRatio);
         }
      }
      resizeAndGrayScaleImage(newWidth, newHeight);
   }

   private void resizeAndGrayScaleImage(int width, int height) {
      BufferedImage resizedImage = new BufferedImage(width, height, BufferedImage.TYPE_BYTE_GRAY);
      Graphics2D g = resizedImage.createGraphics();
      g.setComposite(AlphaComposite.Src);
      g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
      g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
      g.drawImage(this.img, 0, 0, width, height, null);
      g.dispose();
      this.img = resizedImage;
   }

}
