package eu32k.manga2cbz;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

import javax.swing.JFrame;
import javax.swing.UIManager;

import de.innosystec.unrar.Archive;
import de.innosystec.unrar.exception.RarException;
import de.innosystec.unrar.rarfile.FileHeader;

public class Util {

   private static int unzipCount = 0;

   public static String generateNumber(int i, int len) {
      String str = i + "";
      while (str.length() < len) {
         str = "0" + str;
      }
      return str;
   }

   public static void scanDirectory(File current, ArrayList<File> list, File unzipDir) {
      File[] content = null;
      if (current.isDirectory()) {
         content = current.listFiles();
      } else {
         content = new File[] { current };
      }
      for (File file : content) {
         if (file.isDirectory()) {
            // go deeper
            scanDirectory(file, list, unzipDir);

         } else if (Util.isZipArchive(file.getName())) {

            try {
               ZipFile zip = new ZipFile(file);
               System.out.println("Unzipping " + zip.getName() + "...");

               ArrayList<String> sortedEntries = new ArrayList<String>();

               Enumeration<?> entries = zip.entries();

               while (entries.hasMoreElements()) {
                  ZipEntry entry = (ZipEntry) entries.nextElement();
                  if (entry.isDirectory()) {
                     continue;
                  }
                  sortedEntries.add(entry.getName());

               }
               Collections.sort(sortedEntries, new Comparator<String>() {
                  public int compare(String strA, String strB) {
                     return strA.compareToIgnoreCase(strB);
                  }
               });

               for (String name : sortedEntries) {
                  ZipEntry entry = zip.getEntry(name);

                  InputStream in = zip.getInputStream(entry);

                  File temp = new File(name);
                  String fileName = temp.getName();

                  File f2 = new File(unzipDir.getAbsolutePath() + File.separator + "temp_" + Util.generateNumber(unzipCount++, 8) + "_" + fileName);
                  writeFile(in, f2);

                  in.close();

                  scanDirectory(f2, list, unzipDir);
               }

               zip.close();
            } catch (ZipException e) {
               e.printStackTrace();
            } catch (IOException e) {
               e.printStackTrace();
            }
         } else if (Util.isRarArchive(file.getName())) {
            try {
               System.out.println("Unraring " + file.getName() + "...");

               Archive rar = new Archive(file);
               ArrayList<FileHeader> sortedEntries = new ArrayList<FileHeader>();

               for (FileHeader fh : rar.getFileHeaders()) {
                  if (fh.isDirectory()) {
                     continue;
                  }
                  sortedEntries.add(fh);
               }
               Collections.sort(sortedEntries, new Comparator<FileHeader>() {
                  public int compare(FileHeader strA, FileHeader strB) {
                     return strA.getFileNameString().compareToIgnoreCase(strB.getFileNameString());
                  }
               });

               for (FileHeader fh : sortedEntries) {
                  File temp = new File(fh.getFileNameString());
                  String fileName = temp.getName();

                  File f2 = new File(unzipDir.getAbsolutePath() + File.separator + "temp_" + Util.generateNumber(unzipCount++, 8) + "_" + fileName);

                  OutputStream out = new BufferedOutputStream(new FileOutputStream(f2));

                  rar.extractFile(fh, out);

                  out.flush();
                  out.close();

                  scanDirectory(f2, list, unzipDir);
               }
               rar.close();
            } catch (RarException e) {
               e.printStackTrace();
            } catch (IOException e) {
               e.printStackTrace();
            }
         } else if (isImage(file.getName())) {
            list.add(file);
         }
      }
   }

   public static boolean isImage(String fileName) {
      if (fileName.toLowerCase().endsWith(".jpg") || fileName.toLowerCase().endsWith(".jpeg") || fileName.toLowerCase().endsWith(".png") || fileName.toLowerCase().endsWith(".gif")) {
         return true;
      }
      return false;
   }

   public static boolean isZipArchive(String fileName) {
      if (fileName.toLowerCase().endsWith(".zip") || fileName.toLowerCase().endsWith(".cbz")) {
         return true;
      }
      return false;
   }

   public static boolean isRarArchive(String fileName) {
      if (fileName.toLowerCase().endsWith(".rar") || fileName.toLowerCase().endsWith(".cbr")) {
         return true;
      }
      return false;
   }

   public static boolean deleteDir(File dir) {
      if (dir.isDirectory()) {
         String[] children = dir.list();
         for (int i = 0; i < children.length; i++) {
            boolean success = deleteDir(new File(dir, children[i]));
            if (!success) {
               return false;
            }
         }
      }
      return dir.delete();
   }

   public static void writeFile(InputStream in, File file) throws IOException {
      OutputStream out = new BufferedOutputStream(new FileOutputStream(file));

      byte[] buffer = new byte[1024];
      int len;

      while ((len = in.read(buffer)) >= 0) {
         out.write(buffer, 0, len);
      }
      out.close();
   }

   public static void createConsole() {
      // nimbus:
      // try {
      // for (LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
      // if ("Nimbus".equals(info.getName())) {
      // UIManager.setLookAndFeel(info.getClassName());
      // break;
      // }
      // }
      // } catch (Exception e) {
      try {
         UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
      } catch (Exception e2) {
         // NOP
      }
      // }
      new RedirectedFrame(false, false, null, 700, 600, JFrame.EXIT_ON_CLOSE);

      // JFrame frame = new JFrame("manga2cbz for iRex DR800S(G)");
      // frame.setPreferredSize(new Dimension(600, 400));
      // frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
      //
      // // Image im = Toolkit.getDefaultToolkit().getImage("icon.png");
      // // frame.setIconImage(im);
      //
      // frame.setIconImage(Toolkit.getDefaultToolkit().getImage(frame.getClass().getResource("/icon.png")));
      //
      // final JTextArea textArea = new JTextArea();
      //
      // textArea.setLineWrap(true);
      // final JScrollPane sbrText = new JScrollPane(textArea);
      // sbrText.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
      //
      // frame.add(sbrText);
      // frame.pack();
      //
      // final PipedInputStream piOut = new PipedInputStream();
      // PipedOutputStream poOut = null;
      // try {
      // poOut = new PipedOutputStream(piOut);
      // } catch (IOException e1) {
      // // NOP
      // }
      //
      // System.setOut(new PrintStream(poOut, true));
      //
      // new Thread(new Runnable() {
      // @Override
      // public void run() {
      // try {
      // int temp = 0;
      // while ((temp = piOut.read()) != -1) {
      // char c = (char) temp;
      // textArea.append(c + "");
      // textArea.setCaretPosition(textArea.getText().length());
      // // sbrText.scrollRectToVisible(new Rectangle(0,
      // // sbrText.getHeight() - 2, 1, 1));
      //
      // }
      // } catch (IOException e) {
      // // NOP
      // }
      // }
      // }).start();
      //
      // frame.setVisible(true);

   }
}
