#!/usr/bin/perl
use File::Copy;
use File::Find;
use RequestSignatureHelper; # get this Perl lib from your Amazon Web Services (AWS) account
use LWP::UserAgent;

# prepare Amazon request
use constant myAWSId	 => '--------------------'; # get your "Access Key ID" from your Amazon Web Services (AWS) account
use constant myAWSSecret => '----------------------------------------'; # get your "Secret Access Key" from your Amazon Web Services (AWS) account
use constant myEndPoint	 => 'ecs.amazonaws.com';

# set up the helper
my $helper = new RequestSignatureHelper (
    +RequestSignatureHelper::kAWSAccessKeyId => myAWSId,
    +RequestSignatureHelper::kAWSSecretKey => myAWSSecret,
    +RequestSignatureHelper::kEndPoint => myEndPoint,
);

my $userAgent = new LWP::UserAgent();

# seach for all files in the current folder, and its subfolders
my @folders = (".");
@folders = @ARGV unless $#ARGV;
foreach my $folder (@folders) {
	find(\&get_metadata, $folder);
}

sub get_metadata {
	return if -d $_; # skip is file is a directory
	return unless /978[0-9]{10}/; # skip is file does not contain EAN/ISBN13 number
	return unless (/\.pdf$/i || /\.chm$/i);  # skip if file is not PDF or CHM (ebook types I use)

	my ($ean, $type) = ($_ =~ /(978[0-9]{10}).*\.(...)/i); # get the EAN number and ebook filetype for later use

	# get book metadata from Amazon.com
	my $req = {
		Service => 'AWSECommerceService',
		Operation => 'ItemLookup',
		Version => '2009-03-31',
		ResponseGroup => 'ItemAttributes,Images,EditorialReview',
		IdType => 'EAN',
		SearchIndex => 'Books',
		ItemId => $ean
	};

	my $signedRequest = $helper->sign( $req );

	my $queryString = $helper->canonicalize($signedRequest);
	my $url = "http://" . myEndPoint . "/onca/xml?" . $queryString;
	my $res = $userAgent->get( $url )->content;

	# item not found: return
	return if $res =~ m|^.+<Errors>.+</Errors>.+$|;

	# item found: extract <Item /> part
	$res =~ s/^.+<Item>/<Item>/;
	$res =~ s|</Item>.+$|</Item>|;

	# keep selected parts only
	my ($publisher) = ($res =~ /<Publisher>(.+)<\/Publisher>/);
	my ($title) = ($res =~ /<Title>(.+)<\/Title>/);
	my ($edition) = ($res =~ /<Edition>([0-9]+).*<\/Edition>/);
	my ($publication_date) = ($res =~ /<PublicationDate>(.+)<\/PublicationDate>/);
	my ($ean) = ($res =~ /<EAN>(.+)<\/EAN>/);

	# create metadata output
	my $ebook_metadata = "";
	$ebook_metadata .= "<Publisher>$publisher</Publisher>";
	$ebook_metadata .= "<Title>$title</Title>";
	$ebook_metadata .= "<Edition>$edition</Edition>";
	$ebook_metadata .= "<PublicationDate>$publication_date</PublicationDate>";
	$ebook_metadata .= "<EAN>$ean</EAN>";

	# create new filename using the metadata fields
	$publisher =~ s/[\?:]/ /g; # replace characters not allowed in a Windows filename with a space
	$title =~ s/[\?:]/ /g; # replace characters not allowed in a Windows filename with a space
	$edition .= "e" if $edition;
	$publication_date =~ s/-//g; # remove dashes in date

	my $filename = "$publisher";
	$filename .= "_$title";
	$filename .= "_$edition";
	$filename .= "_$publication_date";
	$filename .= "_$ean";
	$filename .= ".".lc($type);

	$filename =~ s/ +/./g; # replace spaces with dot

	# complete metadata output
	$ebook_metadata .= "<File>$filename</File>";
	$ebook_metadata .= "<Type>".uc($type)."</Type>";

	# copy original file to new filename and delete the old file if copy succeeds
	copy($_, $filename) and unlink($_);
	
	# write metadata to output file
	open(OUTPUT_FILE, ">>add2books.xml"); # create or append if already exists
	print OUTPUT_FILE "<Book>$ebook_metadata</Book>\n";
	close(OUTPUT_FILE);
}

