<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:variable name="DOC_HOME">
		books
	</xsl:variable>
	<xsl:template match="/">
		<html>
			<head>
				<title>
					ebooks
				</title>
				<style>
					a { font-weight: normal; color: #000000; background-color: #FFFFFF; text-decoration: none; }
					a:hover { color: #FFFFFF; background-color: #2222FF; }
					td { font-family: Arial; font-size: 9pt; white-space: nowrap; }
					th { font-family: Arial; font-size: 9pt; white-space: nowrap; }
					.remark { font-family: Arial; font-size: 9pt; }
				</style>
			</head>
			<body>
				<table border="1" cellpadding="4" cellspacing="0">
					<tr>
						<th align="center">#</th>
						<th align="center">Type</th>
						<th align="left">Publisher</th>
						<th align="left">Title (with link)</th>
						<th align="left">Ed.</th>
						<th align="left">Publ. date</th>
						<th align="left">ISBN-13 (EAN)</th>
					</tr>
					<xsl:apply-templates select="Books/Book"/>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="Book">
		<tr>
			<td align="right">
				<xsl:value-of select="position()"/>.
			</td>
			<td align="center">
				<xsl:value-of select="Type"/>
			</td>
			<td align="left">
				<xsl:value-of select="Publisher"/>
			</td>
			<td align="left">
				<a target="_blank">
					<xsl:attribute name="href">
						<xsl:value-of select="$DOC_HOME"/>/<xsl:value-of select="File"/>
					</xsl:attribute>
					<xsl:value-of select="Title"/>
				</a>
    		</td>
			<td align="center">
				<xsl:value-of select="Edition"/>
			</td>
			<td align="center">
				<xsl:value-of select="PublicationDate"/>
			</td>
			<td align="center">
				<xsl:value-of select="EAN"/>
			</td>
    	</tr>
	</xsl:template>
</xsl:stylesheet>
