#!/bin/sh

VERSION="0.1"
BK="-ScreenFlip-${VERSION}"

# Make sure the new files exist
if [ ! -f ./screenflip.schemas ]; then
    exit 1
fi
if [ ! -f ./sysd ]; then
    exit 1
fi

# Make backup of the original sysd if no backup exists already
if [ ! -f /usr/bin/sysd${BK} ]; then
    mv /usr/bin/sysd /usr/bin/sysd${BK}
fi


# Copy the new versions into place
cp ./screenflip.schemas /etc/gconf/schemas/
cp ./sysd /usr/bin/sysd

# Update gconf
gconftool-2 --install-schema-file=/etc/gconf/schemas/screenflip.schemas

# Reboot
reboot
