#! /bin/bash

#ldconfig

PATH="/usr/local/bin:/usr/bin:/bin:/usr/bin/X11:/usr/games:/usr/local/sony/bin:/usr/sbin"
LD_LIBRARY_PATH="/opt/sony/ebook/application:/lib:/usr/lib:/usr/local/sony/lib:/opt/sony/ebook/lib"
export PATH LD_LIBRARY_PATH

# set initial date
/bin/date 0101000007

Data_Dir=/Data/chinese
AUTO_SH=$Data_Dir/autorun.sh
ERR_LOG=$Data_Dir/error.log
ERR_BAK=$Data_Dir/error.txt
W_LOG=$Data_Dir/tinyhttp.log
#mount Data filesystem
/usr/local/sony/bin/mtdmount -t vfat -o utf8 -o shortname=winnt Data /Data 
#run autorun.sh
if [ -x $AUTO_SH ]; then
  sh $AUTO_SH
fi

#start kbook application
/opt/sony/ebook/application/tinyhttp
if [ $? == 0 ]; then
	if [ -r /tmp/exitcode ]; then
		CODE=`/bin/cat /tmp/exitcode`
		/bin/rm /tmp/exitcode
#		/bin/echo $CODE
		if [ $CODE == 3 ]; then
			NUM=`grep Data /proc/mtd | awk -F: '{print $1}' | awk -Fd '{print$2}'`
			/usr/local/sony/bin/mkdosfs /dev/mtdblock$NUM
			/bin/grep Data /etc/mtab > /dev/null
			if [ $? == 0 ]; then
#				/bin/echo reboot
				/sbin/reboot
			else
#				/bin/echo restart application				
				exec /opt/sony/ebook/bin/tinyhttp.sh
			fi
		fi
	fi
	#delete error.log when normal shutdown
	/usr/local/sony/bin/mtdmount -t vfat -o utf8 -o shortname=winnt Data /Data 
	echo "shutdown -h now" >> $W_LOG
	echo $ERR_LOG >> $W_LOG
	echo $ERR_BAK >> $W_LOG
	rm -f $ERR_LOG $ERR_BAK
	umount /Data
  #	/bin/echo shutdown
	/sbin/shutdown -h now
else
#	/bin/echo reboot
	/sbin/reboot
fi
