#!/bin/bash

ImageSize=20

DataDir=/Data/chinese
EbookImg=$DataDir/ebook.img

ERR_LOG=$DataDir/error.log
ERR_BAK=$DataDir/error.txt
W_LOG=$DataDir/../work.log

#if abnormal boot last time
if [ -s $ERR_BAK ]; then
    echo "detect $ERR_BAK, stoped." >>$W_LOG
    rm  $ERR_LOG
    exit 1
fi
echo "No $ERR_BAK"

if [ -s $ERR_LOG ]; then
    echo "detect $ERR_LOG, stoped." >>$W_LOG
    mv $ERR_LOG $ERR_BAK
    exit 1
fi
echo "No $ERR_LOG"

echo "Begin...">$W_LOG

if [ -s $EbookImg ]; then
  echo "Now is `date +%c`">>$W_LOG
  if [ `date +%Y` -le 2007 ]; then
    echo "Reset detected, you should set the datetime after reset">>$W_LOG
    echo "deleting old image file">>$W_LOG
    rm -f $EbookImg
  fi
fi

if [ -s $EbookImg ]; then
  echo "Check size change">>$W_LOG
  ConfigSize=`expr $ImageSize \* 1024`
  echo "Config size is $ImageSize M" >>$W_LOG
  BlockSize=`/sbin/dumpe2fs $EbookImg |grep 'Block count:' | awk -F' ' '{print $3}'`
  echo "Current size is `expr $BlockSize \/ 1024` M" >>$W_LOG
  if [ $ConfigSize -ne $BlockSize ]; then
    echo "Image size is changed" >>$W_LOG
    rm -f $EbookImg
  fi
fi

if [ -s $EbookImg ]; then
  echo "check $EbookImg filesystem, type is ext2" >>$W_LOG
  /sbin/e2fsck -p $EbookImg >>$W_LOG
else
  echo "Create new image: $EbookImg" >>$W_LOG
  dd if=/dev/zero of=$EbookImg bs=1M count=$ImageSize >>$W_LOG 2>>$W_LOG
  if [ $? != 0 ]; then
    echo "Failed to create $EbookImg, maybe you haven't enough diskspace" >>$ERR_LOG
    exit 1
  fi
  echo "Create filsystem: $EbookImg" >>$W_LOG
  /sbin/mke2fs -F $EbookImg >>$W_LOG 2>>$W_LOG
  if [ $? != 0 ]; then
    echo "Failed to create $EbookImg filesystem" >>$ERR_LOG
    exit 1
  fi
fi

TmpPoint=/tmp/EbookTmp
SrcResDir=$TmpPoint/resources
SrcFontDir=$TmpPoint/FONT
DstResDir=/opt/sony/ebook/application/resources
DstFontDir=/opt/sony/ebook/FONT
MemResDir=$DataDir/resources
MemFontDir=$DataDir/FONT

echo "make temp directory: $TmpPoint" >>$W_LOG
mkdir -p $TmpPoint >>$W_LOG 2>>$W_LOG
if [ $? != 0 ]; then
  echo "Failed to make temp directory: $TmpPoint" >>$ERR_LOG
  exit 1
fi
echo "mount $EbookImg to temp directory: $TmpPoint" >>$W_LOG
mount -t ext2 -o loop $EbookImg $TmpPoint >>$W_LOG 2>>$W_LOG
if [ $? != 0 ]; then
  echo "Failed to mount $EbookImg to $TmpPoint" >>$ERR_LOG
  exit 1
fi

echo "copy resource from $MemResDir to $SrcResDir" >>$W_LOG
rm -rf $SrcResDir
mkdir -p $SrcResDir >>$W_LOG 2>>$W_LOG
cp -rfup $MemResDir/* $SrcResDir >>$W_LOG 2>>$W_LOG
if [ $? != 0 ]; then
  echo "Failed to copy resouces from $MemResDir to $SrcResDir" >>$ERR_LOG
  umount $TmpPoint
  rm -f $EbookImg
  exit 1
fi
echo "copy FONT from $MemFontDir to $SrcFontDir" >>$W_LOG
mkdir -p $SrcFontDir >>$W_LOG 2>>$W_LOG
cp -rfup $MemFontDir/* $SrcFontDir >>$W_LOG
if [ $? != 0 ]; then
  echo "Failed to copy FONT from $MemFontDir to $SrcFontDir" >>$ERR_LOG
  umount $TmpPoint
  rm -f $EbookImg
  exit 1
fi

echo "mount resources $SrcResDir to $DstResDir" >>$W_LOG
mount --bind $SrcResDir $DstResDir >>$W_LOG 2>>$W_LOG
if [ $? != 0 ]; then
  echo "Failed to mount resources $SrcResDir to $DstResDir" >>$ERR_LOG
  exit 1
fi
echo "mount FONT $SrcFontDir to $DstFontDir" >>$W_LOG
mount --bind $SrcFontDir $DstFontDir >>$W_LOG 2>>$W_LOG
if [ $? != 0 ]; then
  echo "Failed to mount FONT $SrcFontDir to $DstFontDir" >>$ERR_LOG
  exit 1
fi
echo "successful" >>$W_LOG

df -a >>$W_LOG
cat /proc/meminfo >>$W_LOG
ls -lR $DataDir>>$W_LOG
ls -lR $DstResDir>>$W_LOG
ls -lR $DstFontDir>>$W_LOG

echo "Notice:" >>$ERR_LOG
echo "1. This file is used to detect abnormal reboot, if you can read it by 505, It's a real error!" >>$ERR_LOG
echo "2. Don't delete this file by computer!!!!!!!!!" >>$ERR_LOG
echo "" >>$ERR_LOG
echo "This error occurs at 505 kernel, follows steps can repair this error" >>$ERR_LOG
echo "1. Delete this file and reboot" >>$ERR_LOG
echo "2. If error still occurs, It's meaning that your fonts and resources have error, So format this disk and rebuild fonts and resources file system." >>$ERR_LOG
echo "" >>$ERR_LOG
echo "good luck with you" >>$ERR_LOG

rm $ERR_BAK
