#!/bin/sh
#
# Custom CTB install script
#

MACHINE_TYPE=$1
SCRIPT=$(readlink -f "$0")
SCRIPT_DIR=`dirname "$SCRIPT"`

# Provides:
#  Functions
. common.sh

# Path to backup directory and location of installer files (required by common.sh)
INSTALL_FILES_DIR="$SCRIPT_DIR/files"
BACKUP_DIR="/media/mmcblk0p1/System/.ctbplus_backup"

# Make folders to use
mkdir -p "$BACKUP_DIR"
mkdir -p "/usr/etc/desktop"

# Require certain files before we can install
requireFile "ctb.dr800s"
requireFile "ctb.dr800sg"
requireFile "ebookmall.desktop"
#requireFile "libermeta.so.0.0.0"

# Make backups
backupFile "ctb" "/usr/bin"
backupFile "ebookmall.desktop" "/usr/etc/desktop"
#backupFile "libermeta.so.0.0.0" "/usr/lib"

# Install Files
installTypedFile "ctb" "/usr/bin" "$MACHINE_TYPE"
installFile "ebookmall.desktop" "/usr/etc/desktop"
installFile "icon-downloads-button.png" "/usr/share/ctb"
#installFile "libermeta.so.0.0.0" "/usr/lib"

# Handle Locales
backupPo "de" "ctb"
backupPo "el" "ctb"
backupPo "en" "ctb"
backupPo "es" "ctb"
backupPo "fr" "ctb"
backupPo "it" "ctb"
backupPo "nl" "ctb"
backupPo "ru" "ctb"
backupPo "zh_CN" "ctb"

installPo "de" "ctb"
installPo "el" "ctb"
installPo "en" "ctb"
installPo "es" "ctb"
installPo "fr" "ctb"
installPo "it" "ctb"
installPo "nl" "ctb"
installPo "ru" "ctb"
installPo "zh_CN" "ctb"

# Now reboot
finishInstall
