#!/bin/sh
#
#
# Custom Install Script Common Bits
#

# $1 - Filename
requireFile()
{
	if [ ! -f "$INSTALL_FILES_DIR/$1" ]; then
	  exit
	fi
}

# $1 - Filename
# $2 - Location backed up from on DR800 (Absolute)
requireBackup()
{
	if [ ! -f "$BACKUP_DIR/$2/$1" ]; then
	  exit
	fi	
}

# $1 - Filename
# $2 - Location on DR800 (Absolute)
backupFile()
{
	if [ ! -f "$BACKUP_DIR/$2/$1" ]; then
		echo "Backing up $2/1 to $BACKUP_DIR/$2/$1"
		mkdir -p "$BACKUP_DIR/$2"
		cp "$2/$1" "$BACKUP_DIR/$2/$1"
	fi
}

# $1 - Filename
# $2 - Location on DR800 (Absolute)
restoreFile()
{
	if [ -f "$BACKUP_DIR/$2/$1" ]; then
		echo "Restoring $BACKUP_DIR/$2/$1 to $2/$1"
		cp -f "$BACKUP_DIR/$2/$1" "$2/$1"
	fi
}

# $1 - Filename
# $2 - Location on DR800 (Absolute)
installFile()
{	
	echo "Installing $1 to $2/$1"
	cp -f "$INSTALL_FILES_DIR/$1" "$2/$1"
}

# $1 - Filename
# $2 - Location on DR800 (Absolute)
# $3 - Machine type (Arbitrary)
installTypedFile()
{
	echo "Installing $1.$3 to $2/$1"
	cp -f "$INSTALL_FILES_DIR/$1.$3" "$2/$1"	
}

# $1 - Filename
# $2 - Location on DR800 (Absolute)
removeFile()
{
	echo "Uninstalling $2/$1"
	rm -f "$2/$1"
}

# $1 - Locale of PO to backup
# $2 - Name of executable this po represents
backupPo()
{
	backupFile "$2.mo" "/usr/share/locale/$1/LC_MESSAGES"
} 

# $1 - Locale of PO to restore
# $2 - Name of executable this po represents
restorePo()
{
	restoreFile "$1.$2.mo" "/usr/share/locale/$1/LC_MESSAGES"
}

# $1 - Locale of PO to write
# $2 - Name of executable this po represents
installPo()
{
	installTypedFile "$2.mo" "/usr/share/locale/$1/LC_MESSAGES" "$1"
}

# $1 - Locale of PO to remove
# $2 - Name of executable this po represents
removePo()
{
	removeFile "$1.$2.mo" "/usr/share/locale/$1/LC_MESSAGES"
}

finishInstall()
{
	/sbin/reboot
	sleep 31
}