/*
 * File Name: render_result_impl.cpp
 */

/*
 * This file is part of uds-plugin-comics.
 *
 * uds-plugin-images is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-images is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include "render_result_impl.h"
#include "render_settings_impl.h"
#include "image_page.h"
#include "log.h"

namespace comics
{

utils::ObjectTable<PluginRenderResultImpl> PluginRenderResultImpl::g_instances_table;

PluginRenderResultImpl::PluginRenderResultImpl(void)
: page(0)        
{   
    LOGPRINTF("entry");
    
    // IPluginUnknown
    query_interface = query_interface_impl;
    release = release_impl;

    // IPluginRenderResult
    get_bitmap_attributes = get_bitmap_attributes_impl;
    get_anchor_from_coordinates = get_anchor_from_coordinates_impl;
    get_bounding_rectangles_from_range = get_bounding_rectangles_from_range_impl;
    get_rendered_range = get_rendered_range_impl;

    // IPluginRenderSettings, no method yet.


    // IPluginZoom
    set_zoom_factor = set_zoom_factor_impl;
    get_zoom_factor = get_zoom_factor_impl;
    get_max_zoom_factor = get_max_zoom_factor_impl;
    get_min_zoom_factor = get_min_zoom_factor_impl;

    // IPluginRotation
    set_rotation = set_rotation_impl;
    get_rotation = get_rotation_impl;

    // Initialize all supported interfaces. In render result, 
    // the render settings, zoom and rotation are read only.
    g_instances_table.add_interface<IPluginUnknown>(this);
    g_instances_table.add_interface<IPluginRenderResult>(this);
    g_instances_table.add_interface<IPluginRenderSettings>(this);
    g_instances_table.add_interface<IPluginZoom>(this);
    g_instances_table.add_interface<IPluginRotation>(this);
}

PluginRenderResultImpl::~PluginRenderResultImpl(void)
{
    LOGPRINTF("entry");
    
    if (page)
    {
        page->set_in_use_flag(false);
    }
    g_instances_table.remove(this);
}
    
void PluginRenderResultImpl::set_page(ImagePage * p)
{    
    LOGPRINTF("entry %p", p);

    page = p;
    if (page)
    {
        page->set_in_use_flag(true);
    }
}

PluginStatus
PluginRenderResultImpl::query_interface_impl(IPluginUnknown    *thiz,
                                             const UDSString   *id, 
                                             void              **ptr )
{
    LOGPRINTF("entry");

    PluginRenderResultImpl *instance = g_instances_table.get_object(thiz);
    if (g_instances_table.query_interface(instance, 
                                          id->get_buffer(id), 
                                          ptr))
    {
        return PLUGIN_OK;
    }
    return PLUGIN_FAIL;
}

int 
PluginRenderResultImpl::release_impl(IPluginUnknown  *thiz )
{
    LOGPRINTF("entry");

    PluginRenderResultImpl *instance = g_instances_table.get_object(thiz);
    instance->release_signal.safe_broadcast(instance);
    return 0;
}

PluginStatus 
PluginRenderResultImpl::get_bitmap_attributes_impl(IPluginUnknown *thiz,
                                         PluginBitmapAttributes *attributes)
{
    LOGPRINTF("entry");

    PluginRenderResultImpl *instance = g_instances_table.get_object(thiz);
 
    ImagePage *page = instance->page;
    if (page)
    {
        attributes->width = page->attributes().desired_width;
        attributes->height = page->attributes().desired_height;
        attributes->row_stride = page->attributes().row_stride;
        attributes->data = page->attributes().data;
        return PLUGIN_OK;
    }
    return PLUGIN_FAIL;
}

PluginStatus 
PluginRenderResultImpl::get_anchor_from_coordinates_impl(IPluginUnknown *thiz,
                                                 const int      x,
                                                 const int      y,
                                                 UDSString      *anchor )
{
    LOGPRINTF("entry");

    return PLUGIN_FAIL;
}

IPluginUnknown* 
PluginRenderResultImpl::get_bounding_rectangles_from_range_impl(IPluginUnknown      *thiz,
                                                                const PluginRange   *range)
{
    LOGPRINTF("entry");

    return 0;
}

PluginStatus PluginRenderResultImpl::get_rendered_range_impl(IPluginUnknown *thiz,
                                                             PluginRange    *range)
{
    LOGPRINTF("entry");

    return PLUGIN_FAIL;
}

PluginStatus PluginRenderResultImpl::set_zoom_factor_impl(IPluginUnknown* thiz,
                                                          const float zoom_factor )
{
    LOGPRINTF("entry");

    return PLUGIN_FAIL;
}

float 
PluginRenderResultImpl::get_zoom_factor_impl(IPluginUnknown* thiz )
{
    LOGPRINTF("entry");

    PluginRenderResultImpl *instance = g_instances_table.get_object(thiz);
    if (instance->page)
    {
        return static_cast<float>(instance->page->attributes().zoom);
    }
    else
    {
        return 0;
    }
}

float 
PluginRenderResultImpl::get_max_zoom_factor_impl(IPluginUnknown* thiz )
{
    LOGPRINTF("entry");

// Even not necessary to get instance from thiz.
// PluginRenderResultImpl *instance = g_instances_table.get_object(thiz);
    return static_cast<float>(comics::ImagePage::max_zoom_factor());
}

float 
PluginRenderResultImpl::get_min_zoom_factor_impl(IPluginUnknown* thiz )
{
    LOGPRINTF("entry");

    // Even not necessary to get instance from thiz.
    // PluginRenderResultImpl *instance = g_instances_table.get_object(thiz);
    return static_cast<float>(comics::ImagePage::min_zoom_factor());
}

PluginStatus 
PluginRenderResultImpl::set_rotation_impl(IPluginUnknown               *thiz,
                                          const PluginRotationDegree   rotation )
{
    LOGPRINTF("entry");

    return PLUGIN_FAIL;
}

PluginRotationDegree 
PluginRenderResultImpl::get_rotation_impl(IPluginUnknown  *thiz )
{
    LOGPRINTF("entry");

    PluginRenderResultImpl *instance = g_instances_table.get_object(thiz);
    if (instance->page)
    {
        return static_cast<PluginRotationDegree>(
                instance->page->attributes().rotation);
    }
    else
    {
        return Clockwise_Degrees_0;
    }

}

}


