/*
 * File Name: image_render_task.h
 */

/*
 * This file is part of uds-plugin-comics.
 *
 * uds-plugin-images is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-images is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef _IMAGE_RENDER_TASK_H_
#define _IMAGE_RENDER_TASK_H_

#include "thread.h"
#include "image_page.h" 
#include "images_renderer.h"
#include "images_document.h"

namespace comics
{

class ImageRenderTask : public common::Task
{
    public:
        ImageRenderTask(ImagesDocument *doc,
					    const std::string & page_anchor, 
                        const ImagePageAttrs & attributes, 
                        int reference_id,
                        ImagesRenderer *p_renderer,
                        void * p_user_data);

        virtual ~ImageRenderTask(void);

        std::string      anchor;
    public:
        virtual void execute(void);
    private:
		ImagesDocument * doc;
        ImagePageAttrs   attrs;
        int              ref_id;
        ImagesRenderer * renderer;
        void           * user_data;
};

};

#endif //_IMAGE_RENDER_TASK_H_
 

