/*
 * File Name: image_page_unittest.cpp
 */

/*
 * This file is part of uds-plugin-comics.
 *
 * uds-plugin-images is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-images is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include <cassert>
#include <iostream>
#include "image_page.h"
#include "log.h"

using namespace comics;

int main()
{
    ImagePage *page, *left_page, *right_page;

    LOGPRINTF("====BEGIN test operator()====");
    ImagePageAttrs attrs;
    page = new ImagePage("/data/wa/uds/trunk/sample/Vatican1.png", attrs);
    size_t key = (*page)();
    LOGPRINTF("key = %d", key);
    delete page;

    LOGPRINTF("Change render attributes.");
    attrs.zoom = -1;
    attrs.rotation = Clockwise_Degrees_90;
    page = new ImagePage("/data/wa/uds/trunk/sample/Vatican1.png", attrs);
    key = (*page)();
    LOGPRINTF("key = %d", key);
    delete page;

    LOGPRINTF("Changing the anchor.");
    page = new ImagePage("/data/wa/uds/trunk/sample/Vatican2.png", attrs);
    key = (*page)();
    LOGPRINTF("key = %d", key);

    LOGPRINTF("No changes.");
    key = (*page)();
    LOGPRINTF("key = %d", key);
    delete page;
    LOGPRINTF("====END test operator()====");

    LOGPRINTF("====BEGIN test operator ==  < > ====");
    attrs.zoom = -2;
    attrs.rotation = Clockwise_Degrees_270;
    left_page = new ImagePage("/data/wa/uds/trunk/sample/Pisa1.png", attrs);
    attrs.zoom = -2;
    attrs.rotation = Clockwise_Degrees_270;
    right_page = new ImagePage("/data/wa/uds/trunk/sample/Pisa1.png", attrs);
   
    LOGPRINTF("== %d", (left_page == right_page));
    LOGPRINTF("< %d", (left_page < right_page));
    LOGPRINTF("> %d", (left_page > right_page));
    delete left_page;
    delete right_page;
    LOGPRINTF("====END test operator==< > ====");

    LOGPRINTF("====BEGIN test length()====");
    page = new ImagePage("/data/wa/uds/trunk/sample/Pisa1.png", attrs);
    LOGPRINTF("page.length = %d", page->length());
    delete page;
    LOGPRINTF("====END test operator length()====");

    return 0;
}


