/*
 * File Name: thumbnail.cpp
 */

/*
 * This file is part of uds-plugin-comics.
 *
 * uds-plugin-images is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-images is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include <cassert>
#include <iostream>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>

#include <gdk-pixbuf/gdk-pixbuf-transform.h>

// This is a simple test unit 
// to see time cosumption when get thumbnail image.
// thumbnail /data/wa/uds/yehong/sample/images/1.JPG 200 300
int main(int argc, char * argv[])
{
    if (argc != 4)
    {
        return -1;
    }
    
    g_type_init();

    GdkPixbuf * loader = gdk_pixbuf_new_from_file(argv[1], 0);
    if (loader)
    {
        printf("Do Scaling...");
        struct timeval tv_start, tv_end;

        gettimeofday(&tv_start, NULL);

        int w = atoi(argv[2]);
        int h = atoi(argv[3]);
        GdkPixbuf * tmp = gdk_pixbuf_scale_simple(loader, w, h,
                                                  GDK_INTERP_NEAREST);
        if (tmp)
        {
            g_object_unref(tmp);
        }

        gettimeofday(&tv_end, NULL);

        printf("%ld \n", 
                (tv_end.tv_sec - tv_start.tv_sec) * 1000000
              + (tv_end.tv_usec - tv_start.tv_usec));

        g_object_unref(loader);
    }

    return 0;
}


