/*
 * File Name: images_renderer_unittest.cpp
 */

/*
 * This file is part of uds-plugin-comics.
 *
 * uds-plugin-images is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-images is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include <iostream>
#include <glib.h>
#include <glib-object.h>
#include "images_renderer.h"
#include "images_document.h"

using namespace comics;

int main()
{
    g_type_init();
    g_thread_init(0);

    ImagesDocument doc;
    doc.open_document("/data/wa/uds/trunk/sample");

    ImagesRenderer renderer(&doc);

    ImagePageAttrs attrs;
    attrs.desired_width = 800;
    attrs.desired_height = 600;
    attrs.zoom = 100;
    attrs.rotation = Clockwise_Degrees_0;

    int i = doc.page_count() / 2;
    std::string anchor;
    if (doc.get_anchor_of_page(i, anchor))
    {
        renderer.render(anchor, attrs, -1, 0);
    }
    // Sleep a while to wait the tasks get the chance to running.
    usleep(50*1000);

    return 0;
}


