'
' Calibre2Web.vbs
' ~~~~~~~~~~~~~~~
' This is a program designed to take the Calibre metadata.db database file
' and generate a set of heirarchical atom catalogs suitable for use with
' the iPhone/iTouch Stanza program.
'
' Author:     Dave Walker (itimpi)
' Email:      itimpi@ntlworld.com
'
' Change History
' ~~~~~~~~~~~~~~
' See README.txt file
'
' Known Bugs
' ~~~~~~~~~~
' - Count of Books for Series is wrong if any of the books have multiple authors
'   As it Is basically cosmetic And would require major code changes To Fix it Is
'   unlikely to be fixed in the VBScript version of Calibre2Web.     

Option Explicit

Const PROGNAME = "Calibre2Web"
Const PROGVERSION = "0.98"

' Some Constants to control what gets generated
Const CATALOG_CLEAR = 1         ' Clear catalog before generating new one 0=No, 1=yes
								' Not clearing is faster but can leave some superfluous files behind
Const DSNNAME="CALIBRE"
' Const DSNNAME="CALIBRE-TEST"   ' Only used when testing
Const CATALOGFOLDER="_CATALOGS"
' Const CATALOGFOLDER="_CATALOG" ' Only used when testing
Const METADATA = "metadata.db"
Const MAX_CATALOG = 200		' If the number of books exceeds this, The "All" option is not generated
Const FEED_AUTHOR="itimpi"	' The value set in the XML for the author of the catalogs
Const RECENT_ADDITIONS = 50 ' Maximum Number of books to be included in Recent Additions section
Const PAGE_SIZE=10			' Number of entries before pagination for next page

' Some VB standard constants
Const adOpenStatic = 3
Const adLockReadOnly = 1
Const adUseClient = 3

Public StartTime: StartTime = Now

' Some channel handles to files
Dim tsParent
Dim tsChild
Dim tsTopLevel

'	Create recordset objects used within the program
Public rsAuthorLookup : Set rsAuthorLookup = CreateObject("ADODB.Recordset")
Public rsBooks : Set rsBooks = CreateObject("ADODB.Recordset")
Public rsAuthorAllBooks  : Set rsAuthorAllBooks = CreateObject("ADODB.Recordset")
Public rsAuthorSeries  : Set rsAuthorSeries = CreateObject("ADODB.Recordset")
Public rsAuthorNoSeries  : Set rsAuthorNoSeries = CreateObject("ADODB.Recordset")
Public rsCategories : 
Public rsComments : Set rsComments = CreateObject("ADODB.Recordset") : rsComments.CursorLocation = adUseClient
Public rsFormat : Set rsFormat = CreateObject("ADODB.Recordset")
Public rsBooksTags : Set rsBooksTags = CreateObject("ADODB.Recordset")
Public rsSeriesBooks  : Set rsSeriesBooks = CreateObject("ADODB.Recordset")
Public rsSeriesLookup  : Set rsSeriesLookup = CreateObject("ADODB.Recordset")
Public rsTags : Set rsTags = CreateObject("ADODB.Recordset")

' =================================== INITIALIZATION ===========================

WScript.Echo " "
WScript.Echo PROGNAME & " v" & PROGVERSION
WScript.Echo " "


Public fso : Set fso = CreateObject("Scripting.FileSystemObject")
Public iIndent : iIndent = 0
Public tUpdated : tUpdated = Now

Dim CatalogPath  : CatalogPath = fso.GetParentFolderName(WScript.ScriptFullName) & "\"

WScript.Echo "DSN for metadata.db is '" & DSNNAME & "'"
WScript.Echo "Catalog Path is '" & CatalogPath &"'"
WScript.Echo "Creating Catlog files in '" & CatalogPath & CATALOGFOLDER & "'"
WScript.Echo " "

On Error Resume Next
If fso.FolderExists (CatalogPath & CATALOGFOLDER) = True Then
	If CATALOG_CLEAR <> 0 Then
		WScript.Echo "Clearing existing catalog folder"
		' Delete will fail if apps have folder open
		Call fso.DeleteFolder (CatalogPath & CATALOGFOLDER, True)
		Call fso.CreateFolder(CatalogPath & CATALOGFOLDER)
	End If
Else
	WScript.Echo("Creating new empty catalog folder")
	Call fso.CreateFolder(CatalogPath & CATALOGFOLDER)
End If
On Error Goto 0

' Open up the database and create the inital record sets
'   Items that are re-used a lot are pre-loaded into
'   memory based recordsets for improved performance.

Public obhConnection : Set objConnection = CreateObject("ADODB.Connection")
Public objConnection : objConnection.Open DSNNAME

WScript.Echo "Loading initial recordsets"

Debug.Write "rsBooks: "
rsBooks.CursorLocation = adUseClient
rsBooks.Open "SELECT  DISTINCT	 b.id AS book_id," _
		  & "            b.title AS title,"_
		  & "            a.id AS author_id," _
		  & "            b.series_index AS series_index," _
		  & "            b.path AS path," _
		  & "            s.series AS series_id" _
          & " FROM 		 books As b" _
          & " LEFT JOIN  books_series_link AS s ON b.id = s.book" _
          & " INNER JOIN books_authors_link AS al ON b.id = al.book" _
          & " INNER JOIN authors AS a ON al.author = a.id" _
          & " ORDER BY	 b.title" _
          ,objConnection, adOpenStatic, adLockReadOnly
Debug.WriteLine ("(" & rsBooks.RecordCount & ") records")

Debug.Write "rsAuthorAllBooks: "
rsAuthorAllBooks.CursorLocation = adUseClient
rsAuthorAllBooks.Open "SELECT DISTINCT	  l.book AS book_id," _
			   & "            l.author AS author_id," _
			   & "            b.title AS title," _
               & "            b.series_index AS series_index," _
		       & "            s.series AS series_id" _
               & " FROM  	  books_authors_link AS l" _
               & " LEFT JOIN  books_series_link AS s ON l.book = s.book" _
               & " INNER JOIN books AS b ON l.book = b.id" _
               & " ORDER BY	  b.title" _
               ,objConnection, adOpenStatic, adLockReadOnly
'               & " INNER JOIN data AS d ON l.book = d.book" _
'               & " LEFT JOIN  books_tags_link as tl ON b.id = tl.book" _
'               & " LEFT JOIN  tags as t on tl.tag = t.id" _
'               & " WHERE      (d.format = 'EPUB')" _
'               & "   OR		 ((t.name = 'PAPER') OR (t.name='WISHLIST') OR (t.name='WANTED'))" _
Debug.WriteLine ("(" & rsAuthorAllBooks.RecordCount & ") records")

Debug.Write "rsAuthorLookup: "
rsAuthorLookup.CursorLocation = adUseClient
rsAuthorLookup.Open "SELECT DISTINCT  a.id AS author_id," _
				 & "          a.name AS name," _
				 & "          l.book AS book_id" _
   	             & " FROM     books_authors_link AS l"_
       	         & " INNER JOIN authors AS a ON l.author = a.id" _
               	 & " ORDER BY a.name" _
       	         , objConnection, adOpenStatic, adLockReadOnly
Debug.WriteLine ("(" & rsAuthorLookup.RecordCount & ") records")

Debug.Write "rsAuthorSeries: "
rsAuthorSeries.CursorLocation = adUseClient
rsAuthorSeries.Open "SELECT DISTINCT" _
			   & "            a.author AS author_id," _
			   & "            l.series AS series_id," _
               & "            s.name AS name" _
               & " FROM 	  books_series_link AS l" _
               & " INNER JOIN series AS s ON l.series = s.id" _
               & " INNER JOIN books_authors_link AS a on l.book = a.book" _
               & " ORDER BY	  s.name" _
               ,objConnection, adOpenStatic, adLockReadOnly
'               & " INNER JOIN data AS d ON l.book = d.book" _
'               & " LEFT JOIN  books_tags_link as tl ON l.book = tl.book" _
'               & " LEFT JOIN  tags as t on tl.tag = t.id" _
'               & " WHERE      (d.format = 'EPUB')" _
'               & "   OR		 ((t.name = 'PAPER') OR (t.name='WISHLIST') OR (t.name='WANTED'))" _
Debug.WriteLine ("(" & rsAuthorSeries.RecordCount & ") records")

Debug.Write "rsAuthorNoSeries: "
rsAuthorNoSeries.CursorLocation = adUseClient
rsAuthorNoSeries.Open "SELECT DISTINCT a.book AS book_id," _
			   & "            a.author AS author_id," _
			   & "            b.title AS title," _
               & "            b.series_index AS series_index," _
		       & "            s.series AS series_id" _
               & " FROM  	  books_authors_link AS a" _
               & " LEFT JOIN  books_series_link AS s ON a.book = s.book" _
               & " INNER JOIN books AS b ON a.book = b.id" _
               & " WHERE      s.book IS NULL" _
               & " ORDER BY	  b.title" _
               ,objConnection, adOpenStatic, adLockReadOnly
'               & " INNER JOIN data AS d ON a.book = d.book" _
Debug.WriteLine ("(" & rsAuthorNoSeries.RecordCount & ") records")

Debug.Write "rsSeriesBooks: "
rsSeriesBooks.CursorLocation = adUseClient
rsSeriesBooks.Open "SELECT DISTINCT	l.book AS book_id," _
			   & "            l.series AS series_id," _
               & "            b.series_index AS series_index," _
			   & "            s.name AS name" _
               & " FROM 	  books_series_link AS l" _
               & " INNER JOIN series AS s ON l.series = s.id" _
               & " INNER JOIN books AS b ON l.book = b.id" _
               & " ORDER BY	  s.name ASC, b.series_index ASC" _
               ,objConnection, adOpenStatic, adLockReadOnly
'               & " INNER JOIN data AS d ON l.book = d.book" _
'               & " LEFT JOIN  books_tags_link as tl ON l.book = tl.book" _
'               & " LEFT JOIN  tags as t on tl.tag = t.id" _
'               & " WHERE      (d.format = 'EPUB')" _
'               & "   OR		 ((t.name = 'PAPER') OR (t.name='WISHLIST') OR (t.name='WANTED'))" _
Debug.WriteLine ("(" & rsSeriesBooks.RecordCount & ") records")

Debug.Write "rsSeriesLookup: "
rsSeriesLookup.CursorLocation = adUseClient
rsSeriesLookup.Open "SELECT  DISTINCT id AS series_id," _
			   & "            name" _
               & " FROM       series" _
               ,objConnection, adOpenStatic, adLockReadOnly
Debug.WriteLine ("(" & rsSeriesLookup.RecordCount & ") records")

Debug.Write "rsTags: "
rsTags.CursorLocation = adUseClient
rsTags.Open "SELECT DISTINCT  id," _
         & "          name" _
	     & " FROM	  tags" _
	     & " ORDER BY name" _
        ,objConnection, adOpenStatic, adLockReadOnly
Debug.WriteLine ("(" & rsTags.RecordCount & ") records")

Debug.WriteLine (" DONE")

Dim x, sFileName

Set tsTopLevel=fso.OpenTextFile (CatalogPath & CATALOGFOLDER & "\catalog.xml", 2, True)
Call FeedHeader (tsTopLevel, _
				 "Calibre::Catalog", _
				 "Calibre eBook Library")
         
' ==================================== MAIN PROCESSING LOOP ===================

'--------------- RECENT ADDITIONS --------------
WScript.Echo "Creating Recent Additions catalogs" 

Public iPage: iPage = 0
Set rsTitles = CreateObject("ADODB.Recordset")
rsTitles.CursorLocation = adUseClient
Call EntryCatalog (tsTopLevel, _
					"Recent Additions", _
					"" & RECENT_ADDITIONS & " most recently added Books", _
					"Recent1")
Do
	Dim iRecords
	iRecords = RECENT_ADDITIONS - (iPage * PAGE_SIZE)
	If iRecords > PAGE_SIZE Then
		iRecords = PAGE_SIZE
	End If
	Debug.Write ("Loading rsTitles for page " & (iPage+1) & ": " )
	rsTitles.Open "SELECT 	b.id AS book_id," _
			  & "           b.title AS name"_
	          & " FROM 		books As b" _
	          & " ORDER BY	b.timestamp DESC" _
	          & " LIMIT " & iRecords _
	          & " OFFSET " & (iPage * PAGE_SIZE) _
	          ,objConnection, adOpenStatic, adLockReadOnly
	Debug.WriteLine ("(" & rsTitles.RecordCount & " records)")
	' Handle case of there being less books in library than 
	If rstitles.RecordCount = 0 Then
		Exit Do
	Else
	End If
	iPage = iPage + 1
	
	Set tsParent=fso.OpenTextFile (CatalogPath & CATALOGFOLDER & "\" & "Recent" & iPage & ".xml", 2, True)
	Call FeedHeader (tsParent, _
					"Calibre:Recent", _
					"Recent")
	If (iPage * PAGE_SIZE) < RECENT_ADDITIONS Then
		tsParent.WriteLine ("  <link rel=""next"" type=""application/atom+xml"" href=""./Recent" & (iPage+1) & ".xml"" />") 
	End If		
	
	Call ListBooks (tsParent, rsTitles, False)	
	Call FeedTrailer (tsParent)
	tsParent.Close
	rsTitles.Close
	WScript.Sleep 500
Loop While (iPage * PAGE_SIZE) < RECENT_ADDITIONS
Set rsTitles = Nothing
WScript.Echo " DONE"				

'---------------- AUTHORS ---------------

WScript.Echo "Creating Author catalog files"
            
Debug.Write ("Loading rsAuthors: ")
Public rsAuthors : Set rsAuthors = CreateObject("ADODB.Recordset")
rsAuthors.CursorLocation = adUseClient
rsAuthors.Open "SELECT DISTINCT a.id AS id,"_
            & "             a.name AS name" _
            & " FROM        authors AS a"_
            & " LEFT JOIN   books_authors_link AS al ON a.id = al.author" _
            & " WHERE       al.book IS NOT NULL" _
            & " ORDER BY name" _
            , objConnection, adOpenStatic, adLockReadOnly
Debug.WriteLine ("(" & rsAuthors.RecordCount & " records)")

Call EntryCatalog ( tsTopLevel, _
					"Books by Author", _
					"Alphabetical index of the " & rsAuthors.RecordCount & " Authors", _
					"Authors")

Set tsParent=fso.OpenTextFile (CatalogPath & CATALOGFOLDER & "\Authors.xml", 2, True)
Call FeedHeader (tsParent, _
				 "Calibre:Authors", _
				 "Authors")
If rsAuthors.RecordCount> 0 Then
	Debug.WriteLine ("  Generating Authors<nn> files" )
	rsAuthors.MoveFirst
	While rsAuthors.EOF = False
		Dim iAuthorId : iAuthorId = rsAuthors("id") 
		Debug.Write (iAuthorId)
		rsAuthorAllBooks.Filter = "author_id = " & iAuthorId
		If rsAuthorAllBooks.RecordCount = 0 Then
			Debug.Write " "
		Else
			Debug.Write "."
			Call AuthorBooks(iAuthorId)
		End If
		rsAuthors.MoveNext
	Wend
End If
Debug.WriteLine("")
call CatalogByLetter (tsParent, _
					  rsAuthors, _
					  "name", _
					  "Author", _
					  "Author", _
					  "author_id", _
					  False, _
					  False) 
Call FeedTrailer (tsParent)
tsParent.Close
rsAuthors.Close
Set rsAuthors = Nothing
WScript.Echo " DONE"

'----------------- SERIES ----------
WScript.Echo "Creating Series catalog files"

Debug.Write ("Loading rsSeries: ")
Public rsSeries : Set rsSeries = CreateObject("ADODB.Recordset")
rsSeries.CursorLocation = adUseClient
rsSeries.Open "SELECT DISTINCT	s.id AS id," _
           & "       	s.name AS name" _
           & " FROM     series AS s" _
           & " INNER JOIN books_series_link AS l ON s.id = l.series" _
           & " ORDER BY s.name" _
           , objConnection, adOpenStatic, adLockReadOnly
Debug.WriteLine ("(" & rsSeries.RecordCount & " records)")

Call EntryCatalog ( tsTopLevel, _
					"Books by Series", _
					"Alphabetical index of the " & rsSeries.RecordCount & " Series", _
					"Series")

Set tsParent=fso.OpenTextFile (CatalogPath & CATALOGFOLDER & "\" & "Series.xml", 2, True)
Call FeedHeader (tsParent, _
				"Calibre:Series", _
				"Series")
If rsSeries.RecordCount > 0 Then
	Debug.WriteLine ("  Generating Series<nn> files" )
	rsSeries.MoveFirst
	While rsSeries.EOF = False
		Dim iSeriesId : iSeriesId = rsSeries("id")
		Debug.Write (iSeriesId)
			' Check we have some books for this series
		rsSeriesBooks.Filter = "series_id = " & iSeriesId
		If rsSeriesBooks.RecordCount = 0 Then
			Debug.Write " "
		Else
			Debug.Write "."
			Call SeriesBooks (iSeriesId) 
		End If
		rsSeries.MoveNext
	Wend
End if
Debug.WriteLine("")
Call CatalogByLetter (tsParent, _
					  rsSeries, _
					  "name", _
					  "Series", _
					  "Series", _
					  "series_id", _
					  False, _
					  True) 
Call FeedTrailer (tsParent)
tsParent.Close
rsSeries.Close
Set rsSeries = Nothing
WScript.Echo " DONE"

'----------------- TITLES ------------
WScript.Echo "Creating Titles catalog files" 

Debug.Write ("Loading rsTitles: ")
Public rsTitles : Set rsTitles = CreateObject("ADODB.Recordset")
rsTitles.CursorLocation = adUseClient
rsTitles.Open "SELECT 	b.id AS book_id," _
		  & "           b.title AS name"_
          & " FROM 		books As b" _
          & " ORDER BY	b.title" _
          ,objConnection, adOpenStatic, adLockReadOnly
Debug.WriteLine ("(" & rsTitles.RecordCount & " records)")

Call EntryCatalog ( tsTopLevel, _
					"Books by Title", _
					"Alphabetical index of the " & rsTitles.RecordCount & " Titles", _
					"Titles")

Set tsParent=fso.OpenTextFile (CatalogPath & CATALOGFOLDER & "\" & "Titles.xml", 2, True)
Call FeedHeader (tsParent, _
				"Calibre:Titles", _
				"Titles")

Call CatalogByLetter (tsParent, _	
					  rsTitles, _
					  "name", _
					  "Titles", _
					  "Books", _
					  "book_id", _
					  True, _
					  False) 
Call FeedTrailer (tsParent)
tsParent.Close
rsTitles.Close
Set rsTitles = Nothing
WScript.Echo " DONE"

'------------- CATEGORIES -----------
WScript.Echo "Creating Category catalog files"

Debug.Write ("Loading rsCategories: ")
Set rsCategories = CreateObject("ADODB.Recordset")
rsCategories.CursorLocation = adUseClient
rsCategories.Open "SELECT id," _
          & "       name" _
          & " FROM  tags"_
          & " ORDER BY name" _
          , objConnection, adOpenStatic, adLockReadOnly
Debug.WriteLine (" DONE (" & rsCategories.RecordCount & " records)")

Call EntryCatalog (tsTopLevel, _
					"Books by Category", _
					"Alphabetical index of the " & rsCategories.RecordCount & " Categories", _
					"Category")

Set tsParent=fso.OpenTextFile (CatalogPath & CATALOGFOLDER & "\" & "Category.xml", 2, True)
Call FeedHeader (tsParent, _
				  "Calibre:Category", _
				  "Category")

Debug.Write "rsCategoryBooks: "
Public rsCategoryBooks  : Set rsCategoryBooks = CreateObject("ADODB.Recordset")
rsCategoryBooks.CursorLocation = adUseClient
rsCategoryBooks.Open "SELECT DISTINCT" _
			   & "            tl.tag as tag_id, " _
			   & "            tl.book AS book_id," _
			   & "            b.title AS title" _
               & " FROM       books_tags_link as tl" _
               & " INNER JOIN books AS b ON tl.book = b.id" _
               & " INNER JOIN tags as t on tl.tag = t.id" _
               & " ORDER BY	  t.name ASC, b.title ASC" _
               ,objConnection, adOpenStatic, adLockReadOnly
Debug.WriteLine ("(" & rsCategoryBooks.RecordCount & ") records")

If rsCategories.RecordCount > 0 Then
	Debug.WriteLine ("  Generating Category<nn> files" )

	rsCategories.MoveFirst
	While rsCategories.EOF = False
		Dim iCategoryId : iCategoryId = rsCategories("id")
		Debug.Write (iCategoryId)
		rsCategoryBooks.Filter = "tag_id = " & iCategoryId

			' Check we have some books for this series
		If rsCategoryBooks.RecordCount = 0 Then
			Debug.Write " "
		Else
			Debug.Write (".")
			Call CategoryBooks (tsParent, iCategoryId) 
		End If
		rsCategories.MoveNext
	Wend
End If

rsCategoryBooks.Close
Set rsCategoryBooks = Nothing
Call FeedTrailer (tsParent)
tsParent.Close
Set tsParent = Nothing
rsCategories.Close
Set rsCategories = Nothing

WScript.Echo " DONE"
				
'------------- PROGRAM CLOSE ------
' Finish by closing down the Database tidily
Call FeedTrailer (tsTopLevel)
tsTopLevel.Close
rsAuthorAllBooks.Close
rsAuthorLookup.Close
rsBooks.Close
rsSeriesBooks.Close
rsSeriesLookup.Close
rsTags.Close
Set rsAuthorAllBooks = Nothing
Set rsAuthorLookup = Nothing
Set rsAuthorNoSeries = Nothing
Set rsAuthorSeries = Nothing
Set rsBooks=Nothing
Set rsFormat=Nothing
Set rsSeriesBooks=Nothing
Set rsSeriesLookup=Nothing
Set rsTags=Nothing
Set rsTitles=Nothing
objConnection.Close
Set objConnection=Nothing
WScript.Echo "FINISHED CREATING STANZA CATALOGS"
WScript.Echo "Run completed in " & DateDiff("s",StartTime, Now) & " seconds"

'================================ FUNCTIONS and PROCEDURES =====================

'--------------------- CatalogByLetter ---------------------------
' Function used when there are too many entries to sensibly load
' them into a single catalog.   Provides an additional level of
' indirection by sorting according to the first letter of the
' items to be cataloged.

Sub  CatalogByLetter (tsParent, _
					   rs, _
					   field_name, _
					   catalog_type, _
					   catalog_name, _
					   book_filter_field, _
					   bList, _
					   bSeries_Index)
	Dim sFileName
	Dim ts
	Dim x
	Dim sChar
	Dim sCatalogName
	Dim sCountName 
	Dim sFilter : sFilter = "" & rs.Filter
	Const cLetters = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"

	
	Debug.WriteLine ("  Generating " & catalog_type & "-X files")
	For x = 1 To Len(cLetters)
	    sChar = Mid (cLetters,x,1)
		Debug.Write (sChar)
		If (sFilter = "") Or (sFilter = "0") Then
			sFilter = ""
			rs.Filter = field_name & " LIKE '" & sChar & "*'"
		Else
			rs.Filter = "(" & sFilter & ") AND (" & field_name & " LIKE '" & sChar & "*')"
		End If
		If rs.RecordCount > 0 Then
			Debug.Write (" ")
			sFileName = catalog_type & "-" & sChar
			' Ensure we use plural of catalog_type
			If blist = True Then
				sCountName = "Book"
			Else
				sCountName = catalog_type
			End If
			If (Right (sCountName,1) <> "s") And (rs.RecordCount > 1) Then
				sCountName = sCountName & "s"
			End If
			sCatalogName = catalog_name
			If (Right (sCatalogName,1) <> "s") And (rs.RecordCount > 1) Then
				sCatalogName = sCatalogName & "s"
			End If
			
			Call EntryCatalog ( tsParent, _
								sCatalogName & ": " & sChar, _
								rs.RecordCount & " " & sCountName, _
								sFileName)
			Set ts=fso.OpenTextFile (CatalogPath & CATALOGFOLDER & "\" & sFileName & ".xml", 2, True)
			Call FeedHeader (ts, _
							"Calibre:" & catalog_type & sChar, _
							catalog_type & ": " & sChar)
			If bList = False Then
				rs.MoveFirst
				While rs.EOF = False
					Dim iFilterId : iFilterId = rs.Fields("id")
					rsBooks.Filter = book_filter_field &  " = " & iFilterId
					If rsBooks.RecordCount = 1 Then
						Call EntryCatalog ( ts, _
											rs.fields(field_name), _
										  	"1 Book" , _
										  	catalog_type & iFilterId)
					Else
						Call EntryCatalog ( ts, _
											rs.fields(field_name), _
										  	rsBooks.RecordCount & " Books" , _
										  	catalog_type & iFilterId)
					End If
					rs.MoveNext
				Wend
			Else
				Call ListBooks (ts, rs, bSeries_Index)
			End if
			Call FeedTrailer (ts)
			ts.close
			Set ts = Nothing
		Else
			Debug.Write (".")
		End If
	Next
	Debug.WriteLine(" DONE")
	rs.Filter = sFilter
End Sub


' ------------------------AuthorBooks --------------------
'	Function to List Books for a Author Given the Author id
'
'	If any books by this author are part of a series, then
'	it will first generate an entry for "All Books".
'	Next will come a list of pointers to the series that
'	this author has contributed to.  Note that if this
'	pointer is followed the full list of books in the
'	series is shown whatever the author
'
'	Finally any books that are not part of any Series
'	are shown

Sub AuthorBooks (author_id)
	Dim iBookId
	Dim tsAuthor, tsChild

	Dim sFileName : sFileName = "Author" & author_id
	
	Set tsAuthor=fso.OpenTextFile (CatalogPath & CATALOGFOLDER & "\" & sFileName & ".xml", 2, True)
	Call FeedHeader (tsAuthor, _
					 "Calibre:Author" & author_id, _
					 rsAuthors("name"))

	rsAuthorSeries.Filter = "author_id = " & author_id
	If rsAuthorSeries.RecordCount > 0 Then
		' Do the All Case
		Call EntryCatalog ( tsAuthor, _
							"All Books", _
							rsAuthorAllBooks.RecordCount & " Books", _
							sfileName & "-All")
		Set tsChild=fso.OpenTextFile (CatalogPath & CATALOGFOLDER & "\" & sFileName & "-All.xml", 2, True)
		Call FeedHeader (tsChild, _
						 "Calibre:" & sFileName & ":All", _
						 "All Books for " & getAuthor(author_id))
	
		Call ListBooks(tsChild, rsAuthorAllBooks, False)
		Call FeedTrailer (tsChild)
		tsChild.Close
		Set tsChild = Nothing
		
		' Then list any series
		Dim iSeriesId
		rsAuthorSeries.MoveFirst
		While rsAuthorSeries.EOF = False
			iSeriesId = rsAuthorSeries("series_id")
			sFileName = "Series" & iSeriesId
			rsSeriesBooks.Filter = "series_id = " & iSeriesId
			Call EntryCatalog ( tsAuthor, _
							"Series: " & rsAuthorSeries.Fields("name"), _
							rsSeriesBooks.RecordCount & " Books", _
							sFileName)
			rsAuthorSeries.MoveNext
		Wend
	End If
	' Finally list any books not in a series
	' (series_id NULL in rsBooks)
	rsAuthorNoSeries.Filter = "author_id = " & author_id
	If rsAuthorNoSeries.RecordCount > 0 Then
		Call ListBooks(tsAuthor, rsAuthorNoSeries, False)
	End If
	
	Call FeedTrailer (tsAuthor)
	tsAuthor.Close
	Set tsAuthor=Nothing
End Sub

' ------------------------SeriesBooks ---------------------
'	Function to List Books for a Series Given the Series id.
'
'	Generates a file with a name of the form Series#.xml
'	where # is the Series-Id.   Also adds an entry to
'	the file indetified by 'ts' pointing to the generated
'	Series#.xml file	

Sub SeriesBooks (series_id)
	Dim tsSeries
	Dim sFileName: sFileName = "Series" & series_id
	
	Set tsSeries=fso.OpenTextFile ( CatalogPath & CATALOGFOLDER & "\" & sFileName & ".xml", 2, True)
	Call FeedHeader (tsSeries, _
					 "Calibre:Series" & series_id, _
					 rsSeries("name"))
	Call ListBooks (tsSeries, rsSeriesBooks, True)
	Call FeedTrailer (tsSeries)
	tsSeries.Close
	Set tsSeries=Nothing
End Sub

' ------------------------CategoryBooks ---------------------
'	Function to List Books for a Category Given the Category id.
'
'	Generates a file with a name of the form Category#.xml
'	where # is the Category-Id.   Also adds an entry to
'	the file indetified by 'ts' pointing to the generated
'	Category#.xml file	

Sub CategoryBooks (ts, tag_id)
	Dim tsCategory
	Dim sFileName: sFileName = "Category" & tag_id
	
	' Pointer to This category
	Call EntryCatalog ( ts, _
						rsCategories("name"), _
						rsCategoryBooks.RecordCount & " Books", _
						sFileName)
	Set tsCategory=fso.OpenTextFile ( CatalogPath & CATALOGFOLDER & "\" & sFileName & ".xml", 2, True)
	Call FeedHeader (tsCategory, _
					 "Calibre:Category" & tag_id, _
					 rsCategories("name"))
	If rsCategoryBooks.RecordCount > MAX_CATALOG Then
		Call CatalogByLetter (tsCategory, _	
							  rsCategoryBooks, _
							  "title", _
							  sFileName, _
							  rsCategories("name"), _
							  "book_id", _
							  True, _
							  False) 
	Else
		Call ListBooks (tsCategory, rsCategoryBooks, False)
	End if
	Call FeedTrailer (tsCategory)
	tsCategory.Close
	Set tsCategory=Nothing
End Sub

'----------------------- ListBooks ------------------
'	Function to List All Books in the supplied recordset
'	It assumes that the 'rs' record set has already been
'	filtered to the books to be listed, and that it has
'	a member book_id that can be used to find the book
'	details and is also correctly ordered.
'
'	The following record sets are used by this function:
'		rsBooks


Sub ListBooks (ts, rs, bSeries_Index)
	Dim iBookId
	
	If rs.RecordCount = 0 Then
		Debug.WriteLine "[DEBUG} Listbooks: RecordCount = 0"
		Exit Sub
	End If
	rs.MoveFirst
	While rs.EOF = False
		iBookId = rs ("book_id")
		rsBooks.Filter = "book_id = " & iBookId
		If rsBooks.RecordCount = 0 Then
			Debug.WriteLine "[DEBUG} ListBooks: Unable to find book_id=" & iBookId & " in rsBooks"
			Exit Sub
		End If
		Call EntryBook (ts, iBookId, bSeries_Index)
		rs.MoveNext
		' The nature of the way we created the rs recordsets means that
		' there can be more than one record per book (one per author/book)
		' We want to skip over these extra records when listing the books
		Do
			If rs.EOF = True Then
				Exit Do
			End If
			If rs("book_id") <> iBookId Then
				Exit Do
			End If
			' Debug.WriteLine ("[DEBUG] ListBooks: Skipping extra record in rsBooks for book_id=" & iBookId & ", Author_id=" & rsBooks.Fields("author_id") & ", Title=" & rsBooks.Fields("title"))
			rs.MoveNext
		Loop
	Wend
End Sub


' ------------------- EntryCatalog ---------------
' Create an entry pointing to a new catalog level
Sub EntryCatalog (ts, title, comment, file)
	Call EntryHeader (ts)
	ts.writeline (space(iIndent) & "<title>" & EscapedXML(title) & "</title>")
    ts.writeline (space(iIndent) & "<id>urn:Calibre:" & file & "</id>")
    Call UpdatedTag (ts)
    ts.writeLine (Space(iIndent) & "<link type=""application/atom+xml"" href=""" & "./" & EscapedURL(file) & ".xml""/>")
    If Len (comment) > 0 Then
		ts.Write (Space(iIndent) & "<content type=""html"">")
    	On Error Resume Next
    	ts.Write (EscapedXML (comment))	
    	On Error Goto 0
    	ts.WriteLine ("</content>")
	End If
 	Call EntryTrailer (ts)
End Sub

' ------------------- EntryBook -------------
' Create a Catalog entry for the given book.
'
' The following record sets are accessed to provide
' Further information about this book:
'		rsTags
'		rsComments
'		rsAuthorLookup
' Certain tags are treated as having special meaning
' and result in text being appended to the title as follows:
'	Tag			Added		Comments
'	~~~			~~~~~		~~~~~~~~
'	Omnibus		(Omnibus)	Always
'	PAPER		[P]			Only if No eBook
'	WISHLIST	[W]			Only if No eBook
'	WANTED		[W]			Only if no eBook

Sub EntryBook (ts, book_id, bSeriesIndex)

	' Load up book details into local variables for effeciency/ease of use
	Dim sAuthorName : 	sAuthorName = getBookAuthors(book_id)
	Dim sPath : sPath = rsBooks.Fields ("path")
	Dim sTitle : sTitle = rsBooks.Fields ("title")
	Dim sTitleExtra : sTitleExtra = " "
	Dim sTags : sTags = getBookTags(book_id)
'	Dim iSize : iSize = rsBooks.Fields ("book_size")
	Dim iSeriesId : iSeriesId = 0 + rsBooks.Fields ("series_id")
	Dim iSeriesIndex : iSeriesIndex = rsBooks.Fields("series_index")
	Dim sCoverPath : sCoverPath = CatalogPath & sPath & "/cover.jpg"
	Dim sBookFullName
	Dim bFileExists
	Dim sPathTitle, sPathAuthor
	Dim x
	sPathTitle = Right(sPath,Len(sPath) - InStr(sPath, "/"))
	' Remove the (#) part from the end
	x = Len(sPathTitle) - 4		' Always at least (#) so no need to look at last characters)	
	' Scan backwards for " (" as this could occur as part of title as well
	Do 
		If Mid(sPathTitle, x + 1, 2) = " (" Then
			Exit Do
		End If
		x = x - 1
	Loop
	sPathTitle = Left(sPathTitle,x)
	sPathAuthor = Left(sPath,InStr(sPath, "/") - 1) 
	sBookFullName = sPath & "/" & sPathTitle & " - " & sPathAuthor  & ".epub"
	bFileExists = fso.FileExists (CatalogPath & sBookFullName)
	bFileExists = True	
	Call EntryHeader (ts)
	ts.Write (Space(iIndent) & "<title>")
	If bSeriesIndex = True Then
		If InStr(sTags, "Omni") = 0 Then
			ts.Write (rsBooks("series_index") & ": ")
		End If
	End If
	
	If InStr (sTags, "Omni") > 0 Then
		sTitleExtra = sTitleExtra & "(Omnibus) "
	End If
	
	If bFileExists = False Then
		If InStr (sTags,"PAPER") > 0 Then
			sTitleExtra = sTitleExtra & "[P]" 
		End If
		If (InStr (sTags, "WISHLIST") > 0) Or (InStr(sTags, "WANTED") > 0) Then
			sTitleExtra = sTitleExtra & "[W]"
		End If
	End If
	ts.Write ( EscapedXML (sTitle & sTitleExtra))
	ts.WriteLine ("</title>")
	ts.WriteLine (Space(iIndent) & "<id>urn:calibre:book" & book_id & "</id>")
	ts.WriteLine (Space(iIndent) & "<author><name>" & EscapedXML(sAuthorName) & "</name></author>")
	Call UpdatedTag (ts)
	' Only generate book download link if book actually exists to download
	If bFileExists = True Then
		ts.WriteLine (Space(iIndent) & "<link type=""application/epub+zip"" href=""" & EscapedURL ( "../" & sBookFullName) & """/>")
	End If
	' Only generate icon tags if cover art exists
	If fso.FileExists (sCoverPath) Then
		ts.WriteLine (Space(iIndent) & "<link rel=""x-stanza-cover-image"" type=""image/png"" href=""" & EscapedURL("../" & sPath & "/cover.jpg") & """/>")
		ts.WriteLine (Space(iIndent) & "<link rel=""x-stanza-cover-image-thumbnail"" type=""image/png"" href=""" & EscapedURL("../" & sPath & "/cover.jpg") & """/>")
	End If
	' Comment (Summary)
	Dim summary: 	summary = getBookComments(book_id)
	ts.WriteLine (Space(iIndent) & "<content type=""xhtml"">")
     ts.WriteLine (Space(iIndent+2) & "<div xmlns=""http://www.w3.org/1999/xhtml"">")
'    If iSize > 0 Then
'		ts.WriteLine (Space(iIndent+4) & "<B>Size:</B> " & iSize & "<BR />")
'	End If
	If sTags <> "" Then
		ts.WriteLine (Space(iIndent+4) & "<B>Tags:</B> " & EscapedXML(getBookTags(book_id)) & "<BR />")
	End If
	
	If iSeriesId > 0 Then
		ts.WriteLine (Space(iIndent+4) & "<B>Series:</B> " & EscapedXML(getSeriesName(iSeriesId)) & "<BR />")
		ts.WriteLine (Space(iIndent+4) & "<B>Series Index:</B> " & iSeriesIndex & "<BR />")
	End If

	If Len (summary) > 12 Then
		If Left (summary,Len("SUMMARY:")) = "SUMMARY:" Then
			summary = Mid(summary,Len("SUMMARY:")+1)
			ts.Write (Space(iIndent) & "<B>SUMMARY:</B>")
		End If			
		summary = EscapedXML(summary)
		On Error Resume Next
		' Not sure why this satement SOMETIMEs errors!
    	ts.WriteLine (summary)	
    	On Error Goto 0
	End If
  	ts.WriteLine (Space(iIndent+2) & "</div>")
   	ts.WriteLine (Space(iIndent) & "</content>")
	
	Call EntryTrailer (ts)
End Sub


' ----------------- CheckForFormat ------------
' See if a book exists in a particular format
Function checkFormatExists (book_id, format_type)

rsFormat.Open "SELECT 	book," _
           & " FROM 		data" _
           & " WHERE     format = '" & format_type & "'" _
           ,objConnection, adOpenStatic, adLockReadOnly
If rsFormat.Recordcount = 0 Then
	CheckForFormat = False
Else
	CheckForFormat = True
End If
rsFormat.Close
rsFormat=Nothing
End Function

' -----------------getAuthors ------------
' Get author for a given author-id

Function getAuthor (author_id)
	rsAuthorLookup.Filter = "author_id = " & author_id
	If rsAuthorLookup.Recordcount = 0 Then
		Debug.WriteLine "[DEBUG] No authors for Author_id=" & author_id
		getAuthor = "<unknown>"
	Else
		rsAuthorLookup.MoveFirst
		getAuthor = rsAuthorLookup.fields("name")
	End If
End Function

' -----------------getBookAuthors ------------
' Get author(s)s for a book.  If there are 
' multiple authors separated by 'and'

Function getBookAuthors (book_id)
	Dim sAuthorName
	sAuthorName = ""

	rsAuthorLookup.Filter = "book_id = " & book_id
	If rsAuthorLookup.Recordcount = 0 Then
		Debug.WriteLine "[DEBUG] No authors for Book_id=" & book_id
	Else
		rsAuthorLookup.MoveFirst
		While rsAuthorLookup.EOF = False
			If sAuthorName <> "" Then
				sAuthorName = sAuthorName & " and "
			End If
			sAuthorName = sAuthorName & rsAuthorLookup.fields("name")
			rsAuthorLookup.MoveNext
		Wend
	End If
	getBookAuthors = sAuthorName
End Function


'----------------- getBookComments ---------------
' Get comments associated with a book.
Function getBookComments (book_id)
	Dim sComments
	Dim sSQL
	sSQL = "SELECT DISTINCT" _
          & "       text" _
          & " FROM  comments"_
          & " WHERE book = " & book_id
    rsComments.Open sSQL, objConnection, adOpenStatic, adLockReadOnly
       
    sComments = ""   
    If rsComments.RecordCount > 0 Then
	    rsComments.MoveFirst
	    sComments = rsComments.Fields("text")
    End If
    rsComments.Close
	getBookComments = sComments
End Function

'--------------- getBookTags -------------
' Return taggs associated with a book as a 
' comma separated list.
Function getBookTags (book_id)
	Dim sTags
	Dim sSQL
	sSQL = "SELECT 	     tag" _
       	 & " FROM 		 books_tags_link" _
         & " WHERE       book = " & book_id 
    rsBooksTags.Open sSQL, objConnection, adOpenStatic, adLockReadOnly
       
    sTags = ""   
    If rsBooksTags.RecordCount > 0 Then
	    rsBooksTags.MoveFirst
    	While rsBooksTags.EOF= False
    		If sTags <> "" Then
    			sTags = sTags & ", "
	    	End If
			rsTags.Filter = "id = " & rsBooksTags.Fields("tag")
			If rsTags.RecordCount = 0 Then
				' There should always be a tags table record!
				Debug.WriteLine "[DEBUG] No tag record for tag_id=" & rsBooks.Fields("tag")
			Else
	    		sTags = sTags & rsTags.Fields("name")			
			End If
    		rsBooksTags.MoveNext
    	Wend
    End If
    rsBooksTags.Close
	getBookTags = sTags
End Function

'----------------- getSeriesName ---------------
Function getSeriesName (series_id)
	Dim sSeriesName : sSeriesName = ""
	
	If (0 + series_id) > 0 Then
		rsSeriesLookup.Filter = "series_id = " & series_id
		If rsSeriesLookup.RecordCount = 1 Then
			sSeriesName = rsSeriesLookup.Fields("name")
		Else
			Debug.WriteLine "{DEBUG}: getSeriesName: unexpected rsseriesLookup.RecordCount value of " & rsSeriesLookup.RecordCount & " for series_id=" & series_id
		End If
	End If
	getSeriesName = sSeriesName
End Function

' ---------------- EntryHeader ---------------
' Output tag that starts an an Atom Entry
Sub EntryHeader (ts)
	ts.WriteLine (Space(iIndent) & "<entry>")
	iIndent = iIndent + 2
End Sub

' -------------- EntryTrailer -----------------
' Out put the tag that terminates an Atom Entry
Sub EntryTrailer (ts)
	iIndent = iIndent - 2
	ts.WriteLine (Space(iIndent) & "</entry>")
End Sub

' ------------- FeedHeader ---------------
'	Procedure to output the Atom Header for catalogs
Sub FeedHeader (ts, urn, title)
	ts.WriteLine("<?xml version=""1.0"" encoding=""utf-8""?>")
	ts.WriteLine("<feed xmlns=""http://www.w3.org/2005/Atom"">")
	iIndent = iIndent + 2
	ts.WriteLine (Space(iIndent) & "<generator>" & PROGNAME & " v" & PROGVERSION &"</generator>")
    ts.WriteLine(Space(iIndent) & "<title>" & EscapedXML(title) & "</title>")
	ts.WriteLine (Space(iIndent) & "<id>urn:" & urn & ":</id>")
	ts.Writeline (Space(iIndent) & "<link rel=""self"" type=""application/atom+xml"" href=""http://www.example.com/catalog.atom"" />") 
  	Call UpdatedTag (ts)
  	ts.WriteLine(Space(iIndent) & "<author>")
  	iIndent = iIndent + 2
    	ts.WriteLine (Space(iIndent) & "<name>" & FEED_AUTHOR & "</name>")
		ts.WriteLine (Space(iIndent) & "<uri>http://calibre.kovidgoyal.net</uri>")
	    iIndent = iIndent - 2
	ts.WriteLine(Space(iIndent) & "</author>")
'	<subtitle>
'	      Read online, where you do everything else.
'	</subtitle>
'	<icon>http://www.bookglutton.com/images/favicon.ico</icon>
'	<logo>http://www.bookglutton.com/images/redbook.png</logo>

'	<link rel="search" title="Search This Feed" type="application/atom+xml" href="http://www.bookglutton.com/api/stanza?q={searchTerms}"/>

End Sub

' ------------- FeedTrailer ---------------
' Outpout the tag that terminates an atom 
' catalog file
Sub FeedTrailer (ts)
	iIndent = iIndent - 2
	ts.WriteLine ("</feed>")
End Sub

' --------------- UpdatedTag --------------
Sub UpdatedTag (ts)
	tUpdated = Now
  	ts.WriteLine (Space(iIndent) & "<updated>" & Year(tUpdated) & "-" & Month(tUpdated) & "-" & Day(tUpdated) _
  								 & "T" & Hour(tUpdated) & ":" & Minute(tUpdated) & ":" & Second(tUpdated) & "Z</updated>")
End Sub

'----------------- EscapedURL ------------
' Escape ASCII characters that have special
' meaning in a URL and all non-ASCII ones.

Function EscapedURL (url)
	Dim x, y, z, ch
	Dim myurl : myurl = url
	
	On Error Resume Next
	
	y = Len(myurl)
	If y = 0 Then
		EscapedURL = ""
		Exit Function
	End If

	x = 1	
	Do
		ch = Mid (myurl,x,1)
		z = Asc(ch)
		If (instr (" ""&()?", ch)) _
		or (z > 127 And z < 255) Then
			' We found one, so handle all occurrences
			myurl = Replace (myurl, ch, "%" & right("00" & Hex(z),2))
			' String will be longer, so reset end point
			y = Len(myurl)
		End If
		x = x +1
		If x > y Then
			Exit Do
		End if
	Loop
	EscapedURL = myurl
	Exit Function
ErrorLabel:
	WScript.Echo "Error in EscapedURL" & vbcrlf _
		& ", x=" & x & ", z=" & z & ", y=" & y & vbcrlf _
		& ", myurl=" & myurl
End Function


'----------------- EscapedXML ------------
' A not very elegant way to ensure any characters outside
' the allowed encodingin XML are escaped correctly in text
' so that it conforms to XHTML standard for text.

Function EscapedXML (xml)
	Dim x,y, z
	Dim myxml : myxml = xml
	

	
	y = Len(myxml)
	If y = 0 Then
		EscapedXML = ""
		Exit Function
	End If

	' First the commonest ASCII characters in standard ANSI
	' Start with the ampersand character itself
	myxml = Replace (myxml, "&", "&amp;")
	' then the greater than one used to start tags (which puts in unescaped ampersands)
	myxml = Replace (myxml, "<", "&lt;")
	x = 1	
	' We need to escape any non-ASCII characters
	' Now brute force for those above 127
	Do
		Dim ch, z2
		ch = Mid (myxml,x,1)
		z = AscW(ch)		' Need to allow for Unicode characters ins tring
		If (z > 127) Then
			' We found one, so handle all occurrences
			myxml = Replace (myxml, ch, "&#" & z & ";")
			' String will be longer, so reset end point
			y = Len(myxml)
			x = x + 3  ' little optimisation to avoid scanning first escaped sequence
		End If
		x = x +1
		If x > y Then
			Exit Do
		End if
	Loop
	' Switch any end-of-lines to markup tags
	myxml = Replace (myxml, Chr(13) & Chr(10), "<BR />")
	myxml = Replace (myxml, Chr(13), "<BR />")
	myxml = Replace (myxml, Chr(10), "<BR />")

	EscapedXML = myxml
	Exit Function
ErrorLabel:
	Wscript.Echo "Error in EscapedXML" & vbcrlf _
		& ", x=" & x & ", z=" & z & ", y=" & y & vbcrlf _
		& ", myxml=" & myxml
End Function
