
#include "config.h"

#include "pdf.h"

#include <gtk/gtk.h>

// poppler includes
#include "goo/gmem.h"
#include "goo/GooList.h"
#include "Object.h"
#include "SplashOutputDev.h"
#include "splash/SplashTypes.h"
#include "splash/SplashBitmap.h"
#include "PDFDoc.h"
#include "GlobalParams.h"
#include "ErrorCodes.h"

static PDFDoc *newDoc=NULL;
static SplashOutputDev *output_dev=NULL;
static SplashBitmap *bitmap=NULL;

void pdf_init()
{
	static int initialised = 0;
	
	if (initialised == 0)
	{
		// printf("pdf_init\n");
		
		initialised = 1;
		
		// init globals vars of poppler
		if (globalParams == NULL)
		{
			globalParams = new GlobalParams();
		}
	
	}
}

void pdf_deinit()
{
	// printf("pdf_deinit\n");

	if (globalParams != NULL)
	{
		delete globalParams;
		globalParams = NULL;
	}
}

// TODO: add return value as reference and to indicate load was a success
void pdf_load(char *pdfname)
{
	GooString *filename_g;
	int err;
	PDFDoc *doc;
	
	// printf("pdf_load\n");
	// make sure we are initialised
	pdf_init();
	
	filename_g = new GooString(pdfname);
	
	// open the document
	doc = new PDFDoc(filename_g);
	
	//delete filename_g; ?? not done in iRex code R1.5
	
	if (!doc->isOk())
	{
		printf("Could not open doc %s\n", pdfname);
		err = doc->getErrorCode();
		delete doc;
		return;
	}
	
	// update global doc
	if(newDoc)
	{
		// printf("delete doc\n"); // should not happpn?
		delete newDoc;
	}
	newDoc = doc;
	
	// delete previous
	//if (output_dev) delete output_dev;
	
	if (output_dev == NULL)
	{
		SplashColorMode mode = splashModeMono8;
    	static SplashColor white;
		

		white[0] = 255;
		white[1] = 255;
		white[2] = 255;
		output_dev = new SplashOutputDev(mode, 4, gFalse, white);
		// printf("pdf_init output_dev=%x\n", (int)output_dev);
	}
	
	// link document to output device
	// printf("startDoc\n");
	output_dev->startDoc(newDoc->getXRef());
	
	// 
}

void pdf_unload()
{
	// printf("pdf_unload\n");
	// free resources
	// TODO

	// printf("pdf_unload-dev\n");
	// It seems that this must be freed before doc, otherwise you get an double-free exception
	if (output_dev)
	{
		delete output_dev;
		output_dev = NULL;
	}

	// printf("pdf_unload-doc\n");
	if (newDoc)
	{
		delete newDoc;
		newDoc = NULL;
	}
	
	// printf("pdf_unload-end\n");	
}

int pdf_number_pages()
{
	if (newDoc)
	{
		// printf("pdf_number_pages:%d\n", newDoc->getNumPages());
		return newDoc->getNumPages();
	}
	else
	{
		//printf("pdf_number_pages: no doc!!\n");
		return -1;
	}
}

int pdf_page_get_size(int page_nr, double *pWidth, double *pHeight, int *pRotate)
{
	*pWidth = 0.0;
	*pHeight = 0.0;
	*pRotate = 0;
	
	//printf("pdf_page_get_size\n");
	if( page_nr <= pdf_number_pages())
	{
		if (newDoc)
		{
			*pWidth = newDoc->getPageCropWidth(page_nr);
			*pHeight = newDoc->getPageCropHeight(page_nr);
			*pRotate = newDoc->getPageRotate(page_nr);
			printf("pdf_page_get_size: %dx%d r=%d\n", (int)*pWidth, (int)*pHeight, *pRotate);
			// printf("media %dx%d\n", (int)newDoc->getPageMediaWidth(page_nr), (int)newDoc->getPageMediaHeight(page_nr));
			
			return 1;
		}
	}
	return 0;
}

void pdf_page_render(int page_nr, int scaled_width, int scaled_height, double scale, int rotate, GdkPixbuf *pixbuf)
{
    SplashColorPtr color_ptr;
	int splash_width, splash_height, splash_rowstride;
	int pixbuf_rowstride, pixbuf_n_channels;
	guchar *pixbuf_data, *dst;
	int x, y;
	
	// printf("pdf_page_render: page=%d, %f\n", page_nr, scale);
	/*
	// TODO: Using PageSlice might be more memory efficient
	newDoc->displayPageSlice(output_dev,
				  	         page_nr,
							 72.0 * scale, 72.0 * scale,
							 0, 
							 gFalse,
							 gTrue,
							 gFalse,
							 0,0,
							 scaled_width, scaled_height);
	*/
	newDoc->displayPage(output_dev,
						page_nr,
						72.0 * scale, 72.0 * scale,
						rotate, 
						gFalse,
						gTrue,
						gFalse);

	// this takes over ownership of the bitmap!
	bitmap = output_dev->takeBitmap();
    color_ptr = bitmap->getDataPtr ();
	
	splash_width = bitmap->getWidth ();
	splash_height = bitmap->getHeight ();
	splash_rowstride = bitmap->getRowSize ();
	printf("pdf_page_render splash %dx%d %d\n", splash_width, splash_height, splash_rowstride);

	pixbuf_data = gdk_pixbuf_get_pixels (pixbuf);
	pixbuf_rowstride = gdk_pixbuf_get_rowstride (pixbuf);
	pixbuf_n_channels = gdk_pixbuf_get_n_channels (pixbuf);
	// printf("pdf_page_render pixbuf: %d %d\n", pixbuf_rowstride/3, pixbuf_n_channels); 

	if (splash_width > gdk_pixbuf_get_width (pixbuf))
		splash_width = gdk_pixbuf_get_width (pixbuf);
	if (splash_height > gdk_pixbuf_get_height (pixbuf))
		splash_height = gdk_pixbuf_get_height (pixbuf);
	
	SplashColorPtr pixel = new Guchar[4];
	for (y = 0; y < splash_height; y++)
	{
		dst = pixbuf_data + y * pixbuf_rowstride;
		for (x = 0; x < splash_width; x++)
		{
			bitmap->getPixel(x, y, pixel);
			// Debug-logging code
			//if(y>100 && y<105 && x>100 && x < 105)
			//{
			//	printf("data: %02d %02d %02d %02d\n", pixel[0], pixel[1], pixel[2], pixel[3]);
			//}
			dst[0] = pixel[0];
			if (pixbuf_n_channels > 1)
				dst[1] = pixel[0];
			if (pixbuf_n_channels > 2)
				dst[2] = pixel[0];
			if (pixbuf_n_channels > 3)
				dst[3] = 0xff;
			dst += pixbuf_n_channels;
		}
	}
	delete [] pixel;
	
	// ownership of bitmap is transferred, we do not use it anymore, so release it
	// release old bitmap
	if (bitmap)
	{
		delete bitmap;
		bitmap = NULL;
	}
}

