#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "dr-file.h"
#include "xournal.h"

#include <string.h>
#include <gtk/gtk.h>
#include <sys/stat.h>
#include <locale.h>
#include <liberutils/er_error.h>
#include <libermetadb/ermetadb.h>

#define TEMP_PATH "/media/mmcblk0p1/Programs"

// writing and reading a temp file.
gboolean
save_to_temp_file(void)
{
  	gchar *tmpfn;
  	gboolean success;

  	end_text();
  	reset_focus();
	// Some people report that auto shutdown can corrupt files, so never save to
	// existing file
  	//if (ui.filename == NULL) 
	{
	  	tmpfn = g_build_filename(TEMP_PATH, ".xournal_sav.xoj", NULL);
  	}
	//else
	//{
	//	tmpfn = g_strdup(ui.filename);
	//}
	
  	// overwrite any exsisting!
  	success = save_journal(tmpfn);
  	// we can not take any action, since we are running in background or
  	// we are shutting down
	
  	g_free(tmpfn);
	
  	return success;
}

gboolean
read_from_temp_file(void)
{
    gchar *tmpfn;
    gboolean success;

    tmpfn = g_build_filename(TEMP_PATH, ".xournal_sav.xoj", NULL);

    success = open_journal(tmpfn);
    if (success)
    {
	    // The file exsisted and is now read, so remove it.
	    g_remove(tmpfn);
    }
	
    g_free(tmpfn);
	
    return success;
}

gboolean
write_scribbles_to_file(const char *filename)
{
	FILE *f;
	GList *pagelist, *layerlist, *itemlist, *list;
	struct Page *pg, *tmppg;
	struct Layer *layer;
	struct Item *item;
	int page_num;
	int layer_num;
	int i;
	
	f = fopen(filename, "w");
	if (f==NULL) return FALSE;
	chk_attach_names();

	setlocale(LC_NUMERIC, "C");

	// Create the header for the file
	fprintf(f, "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
	fprintf(f, "<notes>\n"); // notes
	fprintf(f, "<version><number>1.0</number><organisation>xournal</organisation></version>\n");
	// indicate scribbles are in 72DPI resolution 
	// Precision can be improved by converting all coordinates to a higher resolution
	// since gnome_canvas stores then as floats and they are outputted as ints
	fprintf(f, "<screen><units>px</units><dpi>72</dpi></screen>\n");
	fprintf(f, "<pages>\n"); // pages
	
	page_num = 1;
    for (pagelist = journal.pages; pagelist!=NULL; pagelist = pagelist->next) 
	{
        pg = (struct Page *)pagelist->data;
		// TODO: orientation is fixed at this moment!
        fprintf(f, "<page backgroundcolor=\"#0\" id=\"%d\"><orientation>0</orientation> <height>%d</height> <width>%d</width>\n", 
				page_num, (int)pg->height, (int)pg->width);
		layer_num = 0;
        for (layerlist = pg->layers; layerlist!=NULL; layerlist = layerlist->next) 
		{
			// strokes
      		fprintf(f, "<strokes>\n");

			layer = (struct Layer *)layerlist->data;
      		for (itemlist = layer->items; itemlist!=NULL; itemlist = itemlist->next) 
			{
        		item = (struct Item *)itemlist->data;
        		if (item->type == ITEM_STROKE) 
				{
					// stroke
					fprintf(f, "<stroke color=\"#%d\"  layer=\"%d\"  penSize=\"2\" linestyle=\"solid\"  zoom=\"100.0\">\n",
						item->brush.color_no, layer_num/*, item->brush.thickness_no*/);
          			for (i=0;i<item->path->num_points;i++)
					{
            			fprintf(f, "%d %d 0\n", (int)item->path->coords[2*i], (int)item->path->coords[2*i+1]);
					}
          			fprintf(f, "</stroke>\n"); // end stoke
        		}
      		}
      		fprintf(f, "</strokes>\n"); // end stokes
			layer_num++;
    	}
    	fprintf(f, "</page>\n"); // end page
		page_num++;
  	}
	fprintf(f, "</pages>\n"); // end pages
	fprintf(f, "</notes>\n"); // end notes
		
	fclose(f);
	setlocale(LC_NUMERIC, "");

	return TRUE;
}

void
add_file_to_metadata(char *filename)
{
	int ret = ER_OK;
	erMetadb *metadb = NULL;
	gchar *dir = NULL;
	int ok = 1;
	
	// create new database object
	metadb = ermetadb_new();
	if (metadb == NULL)
	{
		printf("ERROR: could not create database object!\n");
		ok = 0;
		return;
	}

	// determine directory
	dir = g_path_get_dirname(filename);
	printf("Extracted dir: %s\n", dir);
	
	{
		GString *gdir = g_string_new(dir);
		GString *name = g_string_new(g_basename(filename));
		gint64 filesize;
		gint64 filedate;
		int rc;
		
		rc = ermetadb_open_database(metadb, gdir);
		if (rc == ER_NOT_FOUND)
		{
			printf("No database in directory\n");
			ok = 0;
		}
		else if (rc == ERMETADB_DATABASE_BUSY)
		{
			printf("Database busy\n");
			ok = 0;
		}
		else if (rc != ER_OK)
		{
			printf("Database open error: 0x%x\n", rc);
			ok = 0;
		}
		else
		{
			// get file info
			if (ok)
			{
    			struct stat     statbuf;
				
			    rc = stat(filename, &statbuf);
				if ( S_ISREG(statbuf.st_mode) )
				{
					filesize     = statbuf.st_size;
					filedate     = statbuf.st_mtime;
				}
				else if ( S_ISDIR(statbuf.st_mode) )
				{
					printf("ERROR: unexpected, file is a directory [%s]\n", filename);
					ok = 0;
				}
				else
				{
					printf("ignore unknown file type [%s]", filename);
					ok = 0;
				}
			}
			
			if (ok)
			{
    			metadata_table   *values         = NULL;
				int col;
				
				// database is opened, lock it
				rc = ermetadb_begin_transaction(metadb);
				
				// add file
				rc = ermetadb_add_document(metadb, name, filesize, filedate);
				printf("Added file [%s]\n", filename);
				
				if (rc == ER_OK)
				{
					// adjust the is_template flag and sort_priority
					col = 0;
					values = metadata_table_new();
					if (values == NULL)
					{
						rc = ER_FAIL;
					}
					if (rc == ER_OK)
					{
						rc = metadata_table_add_column(values, "is_template");
						if (rc == ER_OK)
						{
							rc = metadata_table_set_int64( values, col++, 0 );
						}
					}
					if (rc == ER_OK)
					{
						rc = metadata_table_add_column(values, "sort_priority");
						if (rc == ER_OK)
						{
							rc = metadata_table_set_int64( values,
															col++,
															MDB_SORT_PRIORITY_FILE );
						}
					}
					if (rc == ER_OK)
					{
						rc = ermetadb_set_file_metadata( metadb, name, values );
					}
					if (rc != ER_OK)
					{
						printf("cannot adjust file_metadata for [%s]", name->str);
					}
					if (values)
					{
						metadata_table_free(values);
						values = NULL;
					}
				}
				// unlock database
				rc = ermetadb_end_transaction(metadb);
			}
		}
	
		g_string_free(gdir, TRUE);
		g_string_free(name, TRUE);
	}
	
	g_free(dir);
	// release the database object
	ermetadb_free(metadb);
}
