#!/usr/bin/python
#

class Unbuffered:
	def __init__(self, stream):
		self.stream = stream
	def write(self, data):
		self.stream.write(data)
		self.stream.flush()
	def __getattr__(self, attr):
		return getattr(self.stream, attr)

import sys
sys.stdout=Unbuffered(sys.stdout)

if not __name__ == "__main__":
	from calibre.customize import FileTypePlugin

	class Demo(FileTypePlugin):

		name                = 'Demo' # Name of the plugin
		description         = 'Demonstrates a dialog during import'
		supported_platforms = ['linux', 'osx', 'windows'] # Platforms this plugin will run on
		author              = 'Paul Durrant' # The author of this plugin
		version             = (1, 0, 0)   # The version number of this plugin
		file_types          = set(['prc','mobi','azw']) # The file types that this plugin will be applied to
		on_import           = True # Run this plugin during the import

	
		def run(self, path_to_ebook):
			from calibre.gui2 import is_ok_to_use_qt
			from PyQt4.Qt import QMessageBox
			if is_ok_to_use_qt():
				d = QMessageBox(QMessageBox.Warning, "Demo Plugin", "Demo Message")
				d.raise_()
				d.exec_()
			return path_to_ebook


if __name__ == "__main__":
	print "Demo Calibre Plugin. "
	sys.exit(0)
