#!/usr/bin/python
#
# A dummy Calibre plug-in
#
# Changelog
#  1.00 - First try

class Unbuffered:
	def __init__(self, stream):
		self.stream = stream
	def write(self, data):
		self.stream.write(data)
		self.stream.flush()
	def __getattr__(self, attr):
		return getattr(self.stream, attr)

import sys
sys.stdout=Unbuffered(sys.stdout)

import struct,binascii


if not __name__ == "__main__":
	from calibre.customize import FileTypePlugin

	class MobiDeDRM(FileTypePlugin):

		name                = 'Dummy' # Name of the plugin
		description         = 'Just passes the file on to Calibre'
		supported_platforms = ['linux', 'osx', 'windows'] # Platforms this plugin will run on
		author              = 'Paul Durrant' # The author of this plugin
		version             = (1, 0, 0)   # The version number of this plugin
		file_types          = set(['prc','mobi','azw']) # The file types that this plugin will be applied to
		on_import           = True # Run this plugin during the import

	
		def run(self, path_to_ebook):
			of = self.temporary_file('.mobi')
			data_file = file(path_to_ebook, 'rb').read()
			file(of.name, 'wb').write(data_file)
			return of.name


if __name__ == "__main__":
	print "Dummy Calibre plug-in."
	sys.exit(0)
