#!/usr/bin/perl

use strict;
use Archive::Zip;
use XML::Simple;
use POSIX;
use utf8;

binmode(STDOUT, ":utf8");

foreach (@ARGV) {
  &read_epub_file($_);
}

exit 0;

sub read_epub_file {
  my $file = shift;

  # Read the EPUB file
  my $epub = Archive::Zip->new($file);

  # Read the META-INF/container.xml file to find the OPF file
  my $xml = $epub->contents("META-INF/container.xml");
  my $container = XML::Simple::XMLin($xml);
  my $opf = $container->{rootfiles}->{rootfile}->{'full-path'};

  # Set the path of the OPF file
  my $path = $opf;
  $path = "" unless ( $path =~ s/\/[^\/]*/\// );

  # Read the OPF file to find the title and authors
  $xml = $epub->contents($opf);
  my $content = XML::Simple::XMLin($xml,ForceArray=>['dc:title','dc:creator'],ForceContent=>['dc:title','dc:creator']);
  my @title = @{$content->{metadata}->{'dc:title'}};
  my @authors = @{$content->{metadata}->{'dc:creator'}};

  # Print title(s) and author(s)
  for my $i ( 0 .. $#title ) {
    if ($i == 0) { print "Title(s): " } else { print "          " };
    print $title[$i]{content},"\n";
  }
  print "Author(s): ";
  for my $i ( 0 .. $#authors ) {
    print $authors[$i]{content};
    if ($authors[$i]{'opf:role'}) { print " ($authors[$i]{'opf:role'})" };
    if ($i < $#authors) { print "; " } else { print "\n" };
  }

  # Compute and print the number of pages, as defined by ADE
  my $total_pages = 0;
  my @spine = @{$content->{spine}->{itemref}};
  for my $i ( 0 .. $#spine ) {
    $spine[$i]{href} = $content->{manifest}->{item}->{$spine[$i]{idref}}->{href};
    $spine[$i]{size} = $epub->memberNamed($path.$spine[$i]{href})->compressedSize();
    $spine[$i]{pages} = ceil($spine[$i]{size}/1024);
    $total_pages+=$spine[$i]{pages}
  }
  print "Pages: $total_pages\n\n";
}
