#!/bin/sh

# Remove djvuplugin 0.1.x first:
# Restore mobipocket
if [ ! -e /usr/lib/uds/libuds-plugin-mobipocket.so ]; then
        if [ -e /media/mmcblk0p1/Programs/_djvuplugin/bak/libuds-plugin-mobipocket.so ]; then
			/bin/cp /media/mmcblk0p1/Programs/_djvuplugin/bak/libuds-plugin-mobipocket.so        /usr/lib/uds/libuds-plugin-mobipocket.so
			/bin/rm /media/mmcblk0p1/Programs/_djvuplugin/bak/libuds-plugin-mobipocket.so
        fi
fi
# Restore schemas:
if [[ -e /media/mmcblk0p1/Programs/_djvuplugin/bak/ctb.schemas ]]
then
	/bin/cp /media/mmcblk0p1/Programs/_djvuplugin/bak/ctb.schemas /etc/gconf/schemas/ctb.schemas
	/bin/rm /media/mmcblk0p1/Programs/_djvuplugin/bak/ctb.schemas
fi
if [[ -e /media/mmcblk0p1/Programs/_djvuplugin/bak/\%gconf-tree.xml ]]
then
	/bin/cp /media/mmcblk0p1/Programs/_djvuplugin/bak/\%gconf-tree.xml /etc/gconf/gconf.xml.defaults/\%gconf-tree.xml
	/bin/rm /media/mmcblk0p1/Programs/_djvuplugin/bak/\%gconf-tree.xml
fi

# Apply UDS patch for firmware version 1.7.1
if [[ "`/usr/bin/md5sum /usr/bin/uds`" = "35e0801bcc25cde1660ef7ee22033412  /usr/bin/uds" ]]
then
	/bin/cp /usr/bin/uds /media/mmcblk0p1/Programs/_djvuplugin/bak/uds
	/bin/cp /media/mmcblk0p1/Programs/_djvuplugin/files/uds /usr/bin/uds
	/bin/chmod 755 /usr/bin/uds
fi

# Adapt gconf to bind djvu files with uds
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
/bin/cp -f /media/mmcblk0p1/Programs/_djvuplugin/files/djvu.schemas /etc/gconf/schemas/djvu.schemas
gconftool-2 --makefile-install-rule /etc/gconf/schemas/djvu.schemas

# If the schema was already installed make sure it gets the correct value
gconftool-2 --type list --list-type=string --set /apps/er/sys/ctb/filetypes/doc-djvu/extensions "[djvu,djv]"
gconftool-2 --type string --set /apps/er/sys/ctb/filetypes/doc-djvu/icon_name "djvu"
gconftool-2 --type string --set /apps/er/sys/ctb/filetypes/doc-djvu/viewer_cmd "uds"

# Create Backup of dr1000.ini
/bin/cp -f /media/mmcblk0p1/System/dr1000.ini /media/mmcblk0p1/System/dr1000.djvu.ini
# and save current settings to disk
/usr/bin/erconftool -e /apps/er

# Copy the djvu-filetype icons
/bin/cp -f /media/mmcblk0p1/Programs/_djvuplugin/files/icon-djvu-medium.png      /usr/share/ctb/icon-djvu-medium.png
/bin/cp -f /media/mmcblk0p1/Programs/_djvuplugin/files/icon-djvu-mini.png        /usr/share/ctb/icon-djvu-mini.png
/bin/cp -f /media/mmcblk0p1/Programs/_djvuplugin/files/icon-djvu-small.png       /usr/share/ctb/icon-djvu-small.png

# Copy the extra libraries needed for the plugin
/bin/cp -f /media/mmcblk0p1/Programs/_djvuplugin/files/libuds-plugin-djvu.so     /usr/lib/uds/libuds-plugin-djvu.so
/bin/cp -f /media/mmcblk0p1/Programs/_djvuplugin/files/libdjvulibre.so.21        /usr/lib/libdjvulibre.so.21

/sbin/reboot
sleep 31
