#include <stdio.h>
#include <stdlib.h>

typedef unsigned int DWORD;
typedef unsigned char BYTE;

struct BinHeader {
  /* 00 */ DWORD sig1;
  /* 04 */ DWORD sig2;
  /* 08 */ DWORD offXorBuf;
  /* 0C */ DWORD offVerCheck;
  /* 10 */ DWORD offDeviceID;
  /* 14 */ DWORD offFiles[6];
  /* 2C */ DWORD dwXorBufSize;
  /* 30 */ DWORD dwVerCheckSize;
  /* 34 */ DWORD dwDeviceIDSize;
  /* 38 */ DWORD dwFileSizes[6];
  /* 50 */ DWORD dwHeaderChecksum;
  /* 54 */ DWORD dwUnk2;
  /* 58 */ DWORD dwUnk3;
  /* 5C */ DWORD dwUnk4;
};

BYTE g_xorkey[] = {
  0x06, 0x04, 0xC1, 0x6C, 0x3C, 0x3E, 0x3F, 0x44, 0x10, 0x6D, 0x63, 0x4C, 0x18, 0x23, 0x1D, 0x01,
  0x57, 0x37, 0x54, 0x4C, 0x01, 0xE1, 0x9A, 0x55, 0x5D, 0x67, 0x3E, 0x1B, 0x83, 0x57, 0x26, 0x7C,
  0x3E, 0x1F, 0xDB, 0x09, 0x12, 0x8F, 0x29, 0x0D, 0x72, 0xD1, 0x03, 0xC5, 0x3E, 0x22, 0x36, 0x9A,
  0x74, 0x01, 0x5D, 0x1B, 0x4B, 0x32, 0x88, 0x27, 0xF5, 0x34, 0x98, 0x3D, 0x59, 0x7B, 0xCD, 0x08,
  0x84, 0xB3, 0x23, 0x47, 0x32, 0x5D, 0x40, 0xDD, 0xE7, 0x16, 0xCE, 0x4A, 0x9D, 0x3F, 0xB9, 0x97,
  0xC7, 0xCA, 0x3C, 0xE9, 0x89, 0x9E, 0xAE, 0x03, 0x28, 0x3D, 0x9F, 0x0B, 0xC0, 0xA4, 0x23, 0x91
};

BYTE* g_XorKeyFiles = NULL;
DWORD g_XorKeyFilesLen = 0;

void XorBlock(void* buf, DWORD size, bool xorType)
{
  BYTE* pKey = xorType?g_xorkey:g_XorKeyFiles;
  if (!pKey)
  {
    printf("no xor key!!");
    return;
  }
  DWORD klen = xorType?sizeof(g_xorkey):g_XorKeyFilesLen;
  BYTE* pKeyEnd = pKey+klen;
  DWORD* p2=(DWORD*)buf;
  BYTE* pKeyPtr=pKey;
  if (klen%4==0)
    while (size>4)
    {
      (*p2)^=*(DWORD*)pKeyPtr;
      p2++;
      pKeyPtr+=4;
      if (pKeyPtr==pKeyEnd)
        pKeyPtr=pKey;
      size-=4;
    }

  BYTE* p1=(BYTE*)p2;
  while (size)
  {
    (*p1)^=*pKeyPtr;
    p1++;
    pKeyPtr++;
    if (pKeyPtr==pKeyEnd)
      pKeyPtr=pKey;
    size--;
  }
}

char *filenames[] = {"version","os1.tgz","os1.tgz.csm","os2.tgz","os2.tgz.csm","mstick.tar"};
void DecodeFile(FILE* inFile, BinHeader& header, int number)
{
  BYTE buffer[0x19000];
  fseek(inFile, header.offFiles[number], SEEK_SET);
  DWORD size = header.dwFileSizes[number];
  printf("Decoding %s...",filenames[number]);
  FILE* outFile = fopen(filenames[number],"wb");
  if (!outFile)
  {
     perror("Error opening output file");
     return;
  }
  while(size)
  {
    DWORD toRead=sizeof(buffer);
    if (toRead>size) toRead = size;
    if (1!=fread(buffer, toRead, 1, inFile))
    {
      perror("Error reading input file");
      return;
    }
    XorBlock(buffer, toRead, number==5);
    if (1!=fwrite(buffer, toRead, 1, outFile))
    {
      perror("Error writing to output file");
      return;
    }
    size-=toRead;
  }
  fclose(outFile);
  printf("done.\n");
}

void PrintVersion(BYTE* verbuf)
{
  //01 00 00 06 16 00
  //01 00 00 04 08 01
  //01 00 00 04 20 01
  printf("%d.%d.%d%d.%d%d%d%d%d",verbuf[0],verbuf[1],verbuf[2]>>4,verbuf[2]&0xF,
  verbuf[3]>>4,verbuf[3]&0xF,verbuf[4]>>4,verbuf[4]&0xF,verbuf[5]);
}

int main(int argc, char* argv[])
{
  printf("Librie firmware dumper 0.1\n");
  if (argc<2)
  {
    printf("Usage: fw_dumper data.bin\n");
    return 1;
  }
  FILE* binFile = fopen(argv[1],"rb");
  if (!binFile)
  {
    perror("opening input file");
    return 2;
  }
  BinHeader header;
  if (1!=fread(&header,sizeof(header),1,binFile))
  {
    perror("reading input file");
    return 2;
  }
  XorBlock(&header,sizeof(header),true);
  if (header.sig1!=0x19890411 || header.sig2!=0x1000528) //what happened on 1989.04.11? birthday of a developer?
  {
    printf("Bad bin signature\n");
    return 2;
  }
  fseek(binFile, header.offXorBuf, SEEK_SET);
  g_XorKeyFilesLen = header.dwXorBufSize;
  g_XorKeyFiles = (BYTE*)malloc(g_XorKeyFilesLen);
  if (1!=fread(g_XorKeyFiles, g_XorKeyFilesLen, 1, binFile))
  {
    perror("reading input file");
    return 2;
  }
  fseek(binFile, header.offVerCheck, SEEK_SET);
  BYTE* verBuf = (BYTE*)malloc(header.dwVerCheckSize);
  if (1!=fread(verBuf, header.dwVerCheckSize, 1, binFile))
  {
    perror("reading input file");
    return 2;
  }
  printf("Expected device version: ");
  PrintVersion(verBuf);
  printf(" - ");
  PrintVersion(verBuf+6);
  printf("\n");
  verBuf = (BYTE*)realloc(verBuf, header.dwDeviceIDSize+1);
  fseek(binFile, header.offDeviceID, SEEK_SET);
  if (1!=fread(verBuf, header.dwDeviceIDSize, 1, binFile))
  {
    perror("reading input file");
    return 2;
  }
  verBuf[header.dwDeviceIDSize]=0;
  printf("Device name: %s\n",verBuf);
  for (int i=0;i<6;i++)
    DecodeFile(binFile, header, i);
  fclose(binFile);
}
