/*
 * File Name: marker_entry_impl.h
 */

/*
 * This file is part of uds-plugin-pdf.
 *
 * uds-plugin-pdf is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-pdf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef PDF_MARKER_ENTRY_IMPL_H_
#define PDF_MARKER_ENTRY_IMPL_H_

#include "plugin_inc.h"
#include "string_impl.h"
#include "log.h"

namespace pdf
{

class MarkerEntryImpl
{
public:
    MarkerEntryImpl();
    ~MarkerEntryImpl();

    // Disconnect this node with other siblings or children.
    void disconnect();

public:
    PluginMarkerType    type;           /**< The marker type. */
    UDSString           *anchor;        /**< The anchor. Not sure which anchor. 
                                             Itself or anchor it points to. */
    UDSString           *text;          /**< The display text. */
    MarkerEntryImpl     *sibling;       /**< The next sibling entry. */
    MarkerEntryImpl     *first_child;   /**< The first child entry. */
    unsigned int        uds_ext_size;   /**< uds_private size in bytes. */
    unsigned char       *uds_private;   /**< uds-private data. */
};

};  // namespace pdf

#endif

