/*
 * File Name: marker_entry_impl.cpp
 */

/*
 * This file is part of uds-plugin-pdf.
 *
 * uds-plugin-pdf is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-pdf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#include "marker_entry_impl.h"
#include "log.h"

namespace pdf
{
MarkerEntryImpl::MarkerEntryImpl()
{
    type = MARKER_UDS_PRIVATE;
    anchor = 0;
    text = 0;
    sibling = 0;
    first_child = 0;
    uds_ext_size = 0;
    uds_private = 0;
}

void MarkerEntryImpl::disconnect()
{
    sibling = 0;
    first_child = 0;
}

MarkerEntryImpl::~MarkerEntryImpl()
{
    if (first_child != 0)
    {
        delete first_child;
        first_child = 0;
    }
    
    if (sibling != 0)
    {
        delete sibling;
        sibling = 0;
    }

    if (anchor)
    {
        delete (StringImpl*)anchor;
        anchor = 0;
    }
    
    if (text)
    {
        LOGPRINTF("delete marker %s\n", text->get_buffer(text));
        delete (StringImpl*)text;
        text = 0;
    }
   
    if (uds_private)
    {
        delete [] uds_private;
        uds_private = 0;
    }
}

}  // namespace pdf

