/*
 * File Name: plugin_error.h
 */

/*
 * This file is part of uds-plugin-common.
 *
 * uds-plugin-common is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-common is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef PLUGIN_ERROR_H_
#define PLUGIN_ERROR_H_

#ifdef __cplusplus
extern "C" {
#endif

/** 
 * @brief Definition of error code for specific functions
 */

/**
 * @brief PluginStatus Function return code definition
 */
#define GENERAL_STATUS_START            2
#define VIEW_STATUS_START               20
#define RENDER_SETTINGS_STATUS_START    30

typedef enum
{
    PLUGIN_OK   = 0,
    PLUGIN_FAIL = 1,

    PLUGIN_OUT_OF_BUFFER = GENERAL_STATUS_START,
    PLUGIN_NOT_SUPPORTED,

    PLUGIN_END_PAGE_ALREADY = VIEW_STATUS_START,
    PLUGIN_START_PAGE_ALREADY,

    PLUGIN_MAX_ZOOM_ALREADY = RENDER_SETTINGS_STATUS_START,
    PLUGIN_MIN_ZOOM_ALREADY,

    PLUGIN_INVALID_PID,
    PLUGIN_WRONG_PASSWORD,
    PLUGIN_NO_DICTS,
    PLUGIN_NO_DICT_RESULTS,

    PLUGIN_ERROR_OPEN_FILE,
    PLUGIN_ERROR_FILE_EXPIRED,
    PLUGIN_ERROR_MULTI_PART_EBOOKS,
    PLUGIN_ERROR_PALMDOC,


    PLUGIN_OUT_OF_MEMORY,

    PLUGIN_UNSUPPORTED_ENCODING,

} PluginStatus;

#ifdef __cplusplus
}
#endif 

#endif

