/*
 * File Name: plugin_document.h
 */

/*
 * This file is part of uds-plugin-common.
 *
 * uds-plugin-common is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * uds-plugin-common is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

#ifndef PLUGIN_DOCUMENT_H_
#define PLUGIN_DOCUMENT_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "plugin_type.h"
#include "plugin_unknown.h"

/**
 * @brief Universal Document Shell Plugin Document interface.
 * Through IPluginDocument, caller can open and close a specified document,
 * estimate whether an interface pointer delegates an opened document object,
 * and create a new view object.
 */
typedef struct 
{

    /**
     * @brief Open specified document. 
     * @param thiz IPluginUnknown pointer of document object.
     * @param path The path of the document.
     * @return TODO. Add return code here.
     */
    PluginStatus (* open )( IPluginUnknown    *thiz, 
                            const UDSString   *path );

    /**
     * @brief Check whether the current document object has been opened or not.
     * @param thiz The IPluginUnknown pointer of document object.
     * @return Returns PLUGIN_TRUE if the document has been successfully
     * opened, otherwise returns PLUGIN_FALSE.
     */
    PluginBool (* is_open )( IPluginUnknown    *thiz );

    /**
     * @brief Close document. This document object won't be destroyed
     * immediately after calling this function. The object can be used to
     * open another document.
     * @param thiz The IPluginUnknown pointer of document object to be closed.
     * @return TODO. Add return code here.
     */
    PluginStatus (* close )( IPluginUnknown     *thiz );

    /**
     * @brief Create view object.
     * @param thiz IPluginUnknown pinter of document object.
     * @return Returns the IPluginUnknown pointer of new created view object. 
     * If the view object is failed to be created, this function returns NULL.
     */
    IPluginUnknown * (* create_view )( IPluginUnknown   *thiz );

} IPluginDocument;

#ifdef __cplusplus
}
#endif 

#endif

