#!/usr/bin/perl

require HTML::HeadParser;
#<sequence number="Nummer des Romans in der Reihe" name="Name der Reihe"/>

my %g_meta =
(
	'author-first'	=> '',
	'author-last'	=> '',
	'book-sequence'	=> '',
	'book-order'	=> '0',
	'book-title'	=> '',
);

#----------------------------------------------------------------------------------------
sub ReadHtmlHeader
{
	%g_meta = ();
	my( $filename ) = @_;
	my $p = HTML::HeadParser->new;
	$p->parse_file( $filename );

	$g_meta{ 'book-sequence' }	= $p->header('X-Meta-BOOKREIHE');
	$g_meta{ 'book-order' }		= $p->header('X-Meta-BOOKORDER');
	$g_meta{ 'book-title' }		= $p->header('X-Meta-BOOKTITLE');

	$g_meta{ 'author-last' }	= $p->header('X-Meta-BOOKAUTHOR');
}
#----------------------------------------------------------------------------------------
sub WriteFB2Header
{
	print << "EOT"
<?xml version="1.0" encoding="iso-8859-1"?>
<FictionBook xmlns:l="http://www.w3.org/1999/xlink" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.gribuser.ru/xml/fictionbook/2.0">
<description>
	<title-info>
		<genre></genre>
		<author>
			<first-name></first-name>
			<middle-name></middle-name>
			<last-name>$g_meta{'author-last'}</last-name>
		</author>
		<book-title>$g_meta{'book-title'}</book-title>
		<date></date>
		<coverpage>
		</coverpage>
		<lang></lang>
	</title-info>
	<document-info>
		<sequence number="$g_meta{'book-order'}" name="$g_meta{'book-sequence'}"/>
		<author>
			<first-name></first-name>
			<last-name>$g_meta{'author-last'}</last-name>
		</author>
		<program-used></program-used>
		<date value=""></date>
		<src-url></src-url>
		<src-ocr></src-ocr>
		<id></id>
		<version></version>
	</document-info>
	<publish-info>
	</publish-info>
</description>
<body>
EOT
}
#----------------------------------------------------------------------------------------
sub WriteFB2Footer
{
	print << "EOT"
</body>
</FictionBook>
EOT
}

#========================================================================================
package MyParser;
require HTML::Filter;
@ISA=qw(HTML::Filter);
#----------------------------------------------------------------------------------------
sub start
{
	my $self	= shift;
	my $tag		= $_[0];

	$self->{ 'tag' }	= $tag;

	if( $tag eq "p" )
	{
		print "<p>";
		$self->{ 'visible' }++;
		return;
	}
	if( $tag eq "b" )
	{
		print "<strong>";
		return;
	}
	if( $tag eq "i" )
	{
		print "<emphasis>";
		return;
	}
	if( $tag =~ /^h([1-2])$/i )
	{
		if( $1 == 2 )
		{
			if( $self->{ 'section' } )
			{
				print "\n", "</section>", "\n";
			}
			$self->{ 'section' }=1;
			print "\n", "<section>", "\n";
		}
		print "<title><p>";
		$self->{ 'visible' }++;
		return;
	}

	#$self->SUPER::start(@_);
}  
#----------------------------------------------------------------------------------------
sub end
{
	my $self	= shift;
	my $tag		= $_[0];

	if( $tag eq "p" )
	{
		print "</p>";
		$self->{ 'visible' }--;
		return;
	}
	if( $tag eq "b" )
	{
		print "</strong>";
		return;
	}
	if( $tag eq "i" )
	{
		print "</emphasis>";
		return;
	}
	if( $tag =~ /^h[1-2]$/i )
	{
		print "</p></title>";
		$self->{ 'visible' }--;
		return;
	}
	if( $tag eq "body" )
	{
		if( $self->{ 'section' } )
		{
			print "\n", "</section>", "\n";
		}
		return;
	}
}
#----------------------------------------------------------------------------------------
sub text
{
	my $self	= shift;
	#my $text	= shift;
	#$self->{ 'mtitle' } = $text if $self->{ 'title' };
	$self->SUPER::text(@_);
}
#----------------------------------------------------------------------------------------
sub output
{
	my $self	= shift;

	if( $self->{ 'visible' } )
	{
		$self->SUPER::output(@_);
	}
}

#========================================================================================
package main;

my @G = ();

push(@G,glob($_)) for( @ARGV );

foreach my $file( @G )	
{
	if( $file =~ /.+\.x?html?$/i )
	{
		print STDERR "$file\n";
		ConvertFile( $file );
	}
}

#----------------------------------------------------------------------------------------
sub ConvertFile
{
	my ( $infile ) = @_;
	ReadHtmlHeader( $infile );
	my $outfile = $infile;
	$outfile =~ s/\.(.+)$/.fb2/; 

	open( OUT, ">$outfile" ) or die( "$outfile: $!" );
	my $prev = select( OUT );
	WriteFB2Header();
	my $p = MyParser->new;
	$p->{ 'visible' } = 0;
	$p->parse_file( $infile );
	WriteFB2Footer();
	select( $prev );
}

