#!/bin/sh

_FUNCTIONS=/etc/rc.d/functions
[ -f ${_FUNCTIONS} ] && . ${_FUNCTIONS}

. /etc/sysconfig/mntus


_EIPUTS=/usr/sbin/eiputs
[ -f ${_EIPUTS} ] && . ${_EIPUTS}


MSG_SLLVL_D="debug"
MSG_SLLVL_I="info"
MSG_SLLVL_W="warn"
MSG_SLLVL_E="err"
MSG_SLLVL_C="crit"
MSG_SLNUM_D=0
MSG_SLNUM_I=1
MSG_SLNUM_W=2
MSG_SLNUM_E=3
MSG_SLNUM_C=4
MSG_CUR_LVL=/var/local/system/syslog_level

ERR_GENERAL=U000
ERR_BUNDLE_VER=U001
ERR_BUNDLE_MD5=U002
ERR_IMAGE_MD5=U003
ERR_UPDATE_MISSING=U004
ERR_UPDATE_TMPDIR=U005
ERR_UPDATE_FAILED=U006
ERR_EXTRACT_FAILED=U020


display_error_code()
{
    eips 1 $((${SCREEN_Y_RES} / ${EIPS_Y_RES} - 2)) $1
}

update_percent_complete()
{
    _PERCENT_COMPLETE=$((${_PERCENT_COMPLETE} + $1))
    update_progressbar ${_PERCENT_COMPLETE}
}


logmsg()
{
    local _NVPAIRS
    local _FREETEXT
    local _MSG_SLLVL
    local _MSG_SLNUM

    _MSG_LEVEL=$1
    _MSG_COMP=$2

    { [ $# -ge 4 ] && _NVPAIRS=$3 && shift ; }

    _FREETEXT=$3

    eval _MSG_SLLVL=\${MSG_SLLVL_$_MSG_LEVEL}
    eval _MSG_SLNUM=\${MSG_SLNUM_$_MSG_LEVEL}

    local _CURLVL

    { [ -f $MSG_CUR_LVL ] && _CURLVL=`cat $MSG_CUR_LVL` ; } || _CURLVL=1

    if [ $_MSG_SLNUM -ge $_CURLVL ]; then
        /usr/bin/logger -p local4.$_MSG_SLLVL -t "webupdate" "$_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
    fi

    [ "$_MSG_LEVEL" != "D" ] && echo "webupdate: $_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
}


get_version()
{
  awk '/System/ { print $4 }' /etc/version.txt | \
    awk -F- '{ print $3 "0" $1 }' | \
    sed 's/^0*//'
}


remove_bundles()
{
    while [ $# -gt 0 ]; do
        local _VER=`dd if="$1" bs=1 count=4 2>/dev/null | xargs`

        case "${_VER}" in

            "FC02" | "FD03" )
                /usr/bin/logger -p local4.info -t "webupdate" "I def:rebootf:file=\"$1\":removing update file"

                rm -f "$1"
                ;;

            *)
                ;;

        esac

        shift
    done
}


#################################################
## Set some variables
#################################################
#set -x

_PWD=`pwd -P`
_VER=`get_version`


#################################################
## Custom code start
#################################################

update_percent_complete 2

mv *.ttf /usr/java/lib/fonts

update_percent_complete 33

cp /usr/java/lib/font.properties /mnt/us/font.properties.orig

sed -i -e "s/Caecilia_LT_65_Medium\.ttf/Serif_Regular\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/Caecilia_LT_75_Bold\.ttf/Serif_Bold\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/Caecilia_LT_66_Medium_Italic\.ttf/Serif_Italic\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/Caecilia_LT_76_Bold_Italic\.ttf/Serif_BoldItalic\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/Helvetica_LT_65_Medium\.ttf/Sans_Regular\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/Helvetica_LT_75_Bold\.ttf/Sans_Bold\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/Helvetica_LT_66_Medium_Italic\.ttf/Sans_Italic\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/Helvetica_LT_76_Bold_Italic\.ttf/Sans_BoldItalic\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/KindleBlackboxRegular\.ttf/Mono_Regular\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/KindleBlackboxBold\.ttf/Mono_Bold\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/KindleBlackboxItalic\.ttf/Mono_Italic\.ttf/" /usr/java/lib/font.properties
sed -i -e "s/KindleBlackboxBoldItalic\.ttf/Mono_BoldItalic\.ttf/" /usr/java/lib/font.properties

cp /usr/java/lib/font.properties /mnt/us/font.properties.new

update_percent_complete 66

cp /opt/amazon/ebook/config/netfront.ini /mnt/us/netfront.ini.orig

sed -i -e "s/Caecilia_LT_65_Medium\.ttf/Serif_Regular\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/Caecilia_LT_75_Bold\.ttf/Serif_Bold\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/Caecilia_LT_66_Medium_Italic\.ttf/Serif_Italic\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/Caecilia_LT_76_Bold_Italic\.ttf/Serif_BoldItalic\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/Helvetica_LT_65_Medium\.ttf/Sans_Regular\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/Helvetica_LT_75_Bold\.ttf/Sans_Bold\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/Helvetica_LT_66_Medium_Italic\.ttf/Sans_Italic\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/Helvetica_LT_76_Bold_Italic\.ttf/Sans_BoldItalic\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/KindleBlackboxRegular\.ttf/Mono_Regular\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/KindleBlackboxBold\.ttf/Mono_Bold\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/KindleBlackboxItalic\.ttf/Mono_Italic\.ttf/" /opt/amazon/ebook/config/netfront.ini
sed -i -e "s/KindleBlackboxBoldItalic\.ttf/Mono_BoldItalic\.ttf/" /opt/amazon/ebook/config/netfront.ini

cp /opt/amazon/ebook/config/netfront.ini /mnt/us/netfront.ini.new

update_percent_complete 98

sed -i -e "s/)\( + UFH\(ack\)\? [0-9]\.[0-9]\)\?/) + UFH 0.3/" /etc/prettyversion.txt

update_progressbar 100

#################################################
## Custom code end
#################################################


#################################################
## Remove all bundle files from the userstore
#################################################
logmsg "I" "webupdate" "removing bundles from userstore"
remove_bundles ${MNTUS_MP}/*.bin


logmsg "I" "done" "id=`basename $0 .ffs`,version=`cat /etc/version.txt | awk /System/\ '{ print $4 }'`" "update complete"


update_percent_complete 90

update_percent_complete 100

return 0



