#!/bin/sh

# Version 0.10 (20091129), ebs, jya
V="0.10"

U=/mnt/us
L=$U/usbnetwork_install.log
R=$U/usbnet
T=/test/bin
S=usbnetwork
PSTARTSCRIPT=/etc/init.d/usbnet
STARTSCRIPT=usbnet

# Result codes,
# at the moment we don't really return an error - don't want to scare people :)
OK=0
ERR=$OK

RS=$R/$S
TS=$T/$S

echo >> $L
echo "usbnetwork v$V, `date`" >> $L

update_progressbar 50

# Link already exists ?
if [ -L $TS ]; then
    echo "symbolic link $TS -> `readlink $TS` exists, deleting..." >> $L
    rm -f $TS >> $L 2>&1 || exit $ERR
fi

LIST="/usr/sbin/dropbearmulti /usr/bin/dropbear /usr/bin/dbclient"
for var in $LIST; do
    if [ -L $var ]; then
	echo "symbolic link $var -> `readlink $var` exists, deleting..." >> $L
	DBM=$(readlink $var)
	if [ "$DBM" = "/mnt/us/usbnet/bin/dropbearmulti" ]; then
	    rm -f $var >> $L 2>&1 || exit $ERR
	else
	    echo "symbolic link not ours skipping..." >> $L
	fi
    fi
done

# Delete startup script
if [ -f $PSTARTSCRIPT ]; then
	echo "$PSTARTSCRIPT exists, deleting..." >> $L
	rm -f $PSTARTSCRIPT >> $L 2>&1 || exit $ERR
fi

if [ -L /etc/rcS.d/S72usbnet ]; then
	echo "symbolic link /etc/rcS.d/S72usbnet exists, deleting..." >> $L
	rm -f /etc/rcS.d/S72usbnet >> $L 2>&1 || exit $ERR
fi

sed -e "s/USE_WAN : false/USE_WAN : true/g" -i /opt/amazon/ebook/config/framework.mario.conf  >> $L 2>&1 || exit $ERR

rm -f /etc/resolv.d/resolv.conf.default >> $L 2>&1 || exit $ERR
touch /etc/resolv.d/resolv.conf.default >> $L 2>&1 || exit $ERR
cp -f /etc/resolv.d/resolv.conf.default /var/run/resolv.conf >> $L 2>&1 || exit $ERR

echo "Done!" >> $L

update_progressbar 100

exit $OK
