import re
from calibre.web.feeds.news import BasicNewsRecipe
class EandP(BasicNewsRecipe):
    title              = u'Editor and Publisher'
    __author__         = u'Xanthan Gum'
    description        = 'News about newspapers and journalism.'    
    no_stylesheets     = True     
     
    oldest_article = 7
    max_articles_per_feed = 100
    
    # Font formatting code borrowed from kwetal
    
    extra_css = '''
                 body{font-family:verdana,arial,helvetica,geneva,sans-serif ;}
                 h1{font-size: xx-large;}
                 h2{font-size: large;}
                '''
    
    # Delete everything before the article
    
    remove_tags_before = dict(name='font', attrs={'class':'titlebar_black'}) 
    
    # Delete everything after the article
          
    preprocess_regexps = [(re.compile(r'<!--endclickprintinclude-->.*</body>', re.DOTALL|re.IGNORECASE),
                           lambda match: '</body>'),]
   
    feeds = [(u'Breaking News', u'http://feeds.feedburner.com/EditorAndPublisher-BreakingNews'),
             (u'Business News', u'http://feeds.feedburner.com/EditorAndPublisher-BusinessNews'),
             (u'Newsroom', u'http://feeds.feedburner.com/EditorAndPublisher-Newsroom'),
             (u'Technology News', u'http://feeds.feedburner.com/EditorAndPublisher-Technology'),
             (u'Syndicates News', u'http://feeds.feedburner.com/EditorAndPublisher-Syndicates')]   