from calibre.web.feeds.news import BasicNewsRecipe

class NrcInternationalRecipe(BasicNewsRecipe):
    __license__  = 'GPL v3'
    __author__ = 'kwetal'
    language = 'en_NL'
    version = 1
    
    title = u'NRC International'
    publisher = u'PCM / NRC Handelsblad BV'
    category = u'News'
    description = '"Lux et Libertas" Dutch news in English'
    
    oldest_article = 14
    max_articles_per_feed = 100
    use_embedded_content = False
    
    no_stylesheets = True
    encoding = 'iso-8859-1'

    # Feeds from: http://www.nrc.nl/international/About/article2254289.ece/Our_RSS_options
    feeds = []
    feeds.append((u'Frontpage', u'http://www.nrc.nl/international/?service=Rss'))
    feeds.append((u'Dutch News', u'http://www.nrc.nl/rss/category/41/National'))
    feeds.append((u'World', u'http://www.nrc.nl/rss/category/28/World'))
    feeds.append((u'Europe', u'http://www.nrc.nl/rss/category/24/Europe'))
    feeds.append((u'Business', u'http://www.nrc.nl/rss/category/23/Business'))
    feeds.append((u'Arts', u'http://www.nrc.nl/rss/category/26/Arts'))
    feeds.append((u'Sports', u'http://www.nrc.nl/rss/category/21/Sports'))
    feeds.append((u'Science', u'http://www.nrc.nl/rss/category/27/Science'))
    feeds.append((u'Politics', u'http://www.nrc.nl/rss/category/22/Politics'))
    feeds.append((u'Media', u'http://www.nrc.nl/rss/category/42/Media'))
    feeds.append((u'Tourism', u'http://www.nrc.nl/rss/category/61/Tourism'))
    feeds.append((u'Editorial', u'http://www.nrc.nl/rss/category/101/Editorial'))
    feeds.append((u'Opinion', u'http://www.nrc.nl/international/opinion/?service=Rss'))
    feeds.append((u'Features', u'http://www.nrc.nl/international/Features/?service=Rss'))
    
    keep_only_tags =[]
    keep_only_tags.append(dict(name = 'div', attrs = {'class' : 'article clearfix'}))
    
    remove_tags =[]
    remove_tags.append(dict(name = 'table'))
    
    extra_css = '''
                        body {font-family: verdana, arial, helvetica, geneva, sans-serif;}
                        h1 {font-size: xx-large; font-weight: bold; margin: 0.4em; padding: 0em; text-align: left;}
                        h2 {font-size: large; font-weight: bold; margin: 0.1em; padding: 0em;}
                        h3 {font-size: x-small; margin: 0.3em; padding: 0em; color: #696969}
                        span.fotocredit {font-size: xx-small; font-style: italic; color: #666666; display: block; margin: 0.2em}
                        div.article_introduction {font-weight: bold; margin-top: 0.3em; margin-bottom: 0.1em;}
                        li {margin-bottom: 0.6em;}
                    '''
    
    def print_version(self, url):
        return url + '?service=Print'
