/**
 *
 * Copyright (c) 2007 Mitch Reierson.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <iostream>
#include "exception.h"
#include "proxy1150.h"

void usage() 
{
  cout << "Usage: eb1150 [-options] \n";
  cout << "where -options are: \n";
  cout << "\t -h host - specify an alternate host address for a personal content server otherwise the default servers are used \n\n";
}

int main(int argc, char* argv[])
{
  cout << "eb1150 0.1 (Dec 19 2007) - eBookWise/GemStar 1150 communication daemon\n";
  cout << "Licensed under the GNU General Public License. ABSOLUTELY NO WARRANTY.\nSee the GNU GPL for details.\n";
  
  char* host = "";
  try {
    if (argc > 1) {
      if (strcmp(argv[1], "-h") == 0) {
	if (argc > 2) {
	  host = argv[2];
	} else {
	  throw InvalidArgumentError();
	}
      } else {
	throw InvalidArgumentError();
      }
    }

    Proxy1150 proxy(host);

    // Run the main communication loop
    proxy.do_loop();

  } catch (InvalidArgumentError) {
    cerr << "\nError: Invalid arguments.  Please correct them and try again.\n\n";
    usage();
    return 1;

  } catch (...) {
    cerr << "\nError: Unknown exception thrown\n";
    return 1;
  }

  return 0;
}
