import sys
from bytework import *
import array

class EmbiidException(Exception):
    pass

class cryptor:
  
  def __init__(self, seed):
    a = seed/1000.0
    self.xorvec = []
    for i in xrange(0x400):
      b = int(a/127773)
      c = a - b*127773
      a = c*16807 - b*2836
      if a<0: a+=2147483647
      self.xorvec.append(int(a/2147483647*256)&0xFF)
    #print [hex(i)+":"+hex(self.xorvec[i]) for i in xrange(0x400)]
  
  def decr_file(self, f, l):
    "Decrypt l bytes from file f at current position"

    pos = f.tell()
    a = array.array('B')
    a.fromfile(f,l)
    for i in xrange(l):
      b = self.xorvec[pos%0x400]
      v = a[i]^b
      if v!=0x1A: a[i] = v
      pos+=1
    return a.tostring()
    #return self.decr_str(f.read(l),pos)

def getUserCryptor():
    "Find user key and name in a personalized EmbiidReader.exe"
    try:
        f = file("EmbiidReader.exe","rb").read()
    except:
        raise EmbiidException("Cannot open EmbiidReader.exe");
    i1 = f.find("\xFF\xFF\xFF\xFF\x80\x00\x00\x00")
    if i1==-1: raise EmbiidException("Cannot find user ID in EmbiidReader.exe");
    i1+=8
    i2 = f.find("\xFF\xFF\xFF\xFF\x80\x00\x00\x00", i1+0x80)
    if i2!=-1: raise EmbiidException("Ambiguous user ID in EmbiidReader.exe");
    if f[i1+0x84:i1+0x8C]!='\xFF\xFF\xFF\xFF\x32\x00\x00\x00':
        raise EmbiidException("Unable to find the user name in EmbiidReader.exe");
    user_id = f[i1+0x8C:i1+0xBE].rstrip(' ')
    t1 = 1
    sum = 0
    for i in xrange(0x80):
        t1 = (t1+ord(f[i1+i]))%0xFFF1;
        sum = (sum+t1)%0xFFF1;
    seed = (sum<<16)|t1
    if seed&0x80000000: seed=-((~seed)&0xFFFFFFFF)-1
    return (cryptor(seed), user_id);

def chap2html(chap):
    "Convert Embiid's tagged text to more proper HTML"
    chap = chap.replace('\r','<br/>\n')
    chap = chap.replace('<c>','<p style="page-break-after:always"/>')
    chap = chap.replace('\t','')
    return chap

def parseEmbiid(fname):
    html = ""
    f = file(fname,"rb")
    c = cryptor(getSDWord(f))
    typ = c.decr_file(f,5)
    if typ!='EBook' and typ!='Valid':
        raise EmbiidException("Not an Embiid book")
    off_cover, len_cover = getSDWord(f), getSDWord(f)
    if fname[-4]==".":
        picname = fname[:-4]+".jpg"
    else:
        picname = fname+".jpg"

    b11 = ord(c.decr_file(f,1))
    title = c.decr_file(f,0x32).rstrip(' ')
    author = c.decr_file(f,0x3BA).rstrip(' ')
    html += '<html><meta http-equiv="Content-Type" content="text/html; charset=windows-1252">'+\
            "<head><title>"+title+" by "+author+"</title></head><body>\n"
    if off_cover>=0 and len_cover>=0:
        html += '<center><img src="'+picname+'"></center>\n'
    chaplens = [getDWord(f) for i in xrange(getWord(f))]
    f.seek(0x800)
    if typ=='EBook':
        c2, user_id = getUserCryptor()
        html += "<center><H3>This book belongs to "+user_id+"</H3></center>\n"
    else:
        c2 = c
    chapters = [c2.decr_file(f,cl) for cl in chaplens]
    for ch in chapters:
        html += '<!-- chapter break -->\n'
        html += chap2html(ch)
    html += "</body></html>"
    if off_cover>=0 and len_cover>=0:
        f.seek(off_cover)
        file(picname,"wb").write(f.read(len_cover))    
    return html
try:
    print "Embiid to HTML converter 0.1 (c) 2007 Igor Skochinsky"
    if len(sys.argv)<2:
      print "Usage: embiid.py <file.ebk|file.ubk>"
    else:
      fname = sys.argv[1]
      html = parseEmbiid(fname)
      if fname[-4]==".":
          outfname = fname[:-4]+".html"
      else:
          outfname = fname+".html"
      file(outfname,"w").write(html)

except EmbiidException, e:
    print "Error: "+e.message

