import struct

def getByte(f):
    return struct.unpack("<B",f.read(1))[0];

def getWord(f):
    return struct.unpack("<H",f.read(2))[0];

def getSWord(f):
    return struct.unpack("<h",f.read(2))[0];

def getDWord(f):
    return struct.unpack("<I",f.read(4))[0];

def getSDWord(f):
    return struct.unpack("<i",f.read(4))[0];

def getQWord(f):
    return struct.unpack("<Q",f.read(8))[0];

def getDouble(f):
    return struct.unpack("<d",f.read(8))[0];

def getFourcc(f):
    return f.read(4)

def getString(f):
    s = ""
    while True:
        c = f.read(1)
        if c=='\x00': break
        s += c
    return s

def strByte(s,off=0):
    return struct.unpack("<B",s[off])[0];

def strSByte(s,off=0):
    return struct.unpack("<b",s[off])[0];

def strSWord(s,off=0):
    return struct.unpack("<h",s[off:off+2])[0];

def strWord(s,off=0):
    return struct.unpack("<H",s[off:off+2])[0];

def strSDWord(s,off=0):
    return struct.unpack("<i",s[off:off+4])[0];

def strDWord(s,off=0):
    return struct.unpack("<L",s[off:off+4])[0];

def strPutDWord(s,off,i):
    return s[:off]+struct.pack("<L",i)+s[off+4:];

def strDouble(s,off=0):
    return struct.unpack("<d",s[off:off+8])[0];

def strString(s,off=0):
    res = ""
    while True:
        c = s[off]
        if c=='\x00': break
        res += c
        off += 1
    return res
